//-----------------------------------------------------------------------------
//
//	PICSTART Plus programming interface
//
//-----------------------------------------------------------------------------
//
//	Cosmodog, Ltd.
//	415 West Superior Street
//	Chicago, IL   60610-3429
//	http://www.cosmodog.com
//
//-----------------------------------------------------------------------------
//
//	this interface to the PICSTART Plus programmer is provided in an effort
//	to make the PICSTART (and thus, the PIC family of microcontrollers) useful
//	and accessible across multiple platforms, not just one particularly well-
//	known, unstable one.
//
//-----------------------------------------------------------------------------
//
//	Copyright (C) 1999 Cosmodog, Ltd.
//
//	This program is free software; you can redistribute it and/or
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//-----------------------------------------------------------------------------

#include "includes.h"

//-----------------------------------------------------------------------------
//
//	DEBUG motorola S-records should be supported, too
//
#define DATARECORD 0
#define ENDRECORD 1
#define EXTADDRESS 2
#define REC_LENGTH	16

static void DumpIntelHexLine(FILE *theFile,unsigned int address,unsigned char *theBytes,int numBytes)
// Create a line of intel hex output to theFile
{
	int
		checkSum;
	int
		i;

	fprintf(theFile,":%02X%04X%02X",numBytes,address,DATARECORD);
	checkSum=0;
	for(i=0;i<numBytes;i++)
	{
		checkSum+=theBytes[i];
		fprintf(theFile,"%02X",theBytes[i]);
	}
	checkSum+=(address&0xFF)+(address>>8)+numBytes+DATARECORD;
	fprintf(theFile,"%02X\n",(-checkSum)&0xFF);

}

static void DumpIntelHexEOR(FILE *theFile)
// Dump an end of file record marker out to theFile
{
	fprintf(theFile,":00000001FF\n");					// provide end record
}


// DEBUG should be able to specify intel hex or motorola S
//
void WriteHexRecord(FILE *outFile, UINT8 *theBuffer, UINT16 address, UINT16 size)
{
	int bytesLeft;
	bytesLeft = size;
	while(bytesLeft)
	{
		int numBytes = bytesLeft > REC_LENGTH ? REC_LENGTH : bytesLeft;
		DumpIntelHexLine(outFile,address,&theBuffer[size-bytesLeft],numBytes);
		address+=numBytes;						
		bytesLeft -= numBytes;
	}
	DumpIntelHexEOR(outFile);
}
