<?php
  /**************************************************************************\
  * phpgwtimetrack - Setup                                                   *
  * http://www.phpgroupware.org                                              *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: mysql_newtables.inc.php,v 1.5 2001/07/16 13:23:26 rschader Exp $ */
  echo 'Installing new tables...<br>';
  // Take back my customers table one way or another:
  echo 'Creating Customers table...<br>';
  $sql = "CREATE TABLE phpgw_ttrack_customers (
    company_id int(10) unsigned NOT NULL auto_increment,
    company_name varchar(255),
    website varchar(80),
    ftpsite varchar(80),
    industry_type varchar(50),
    status varchar(30),
    software varchar(40),
    lastjobnum int(10) unsigned,
    lastjobfinished date,
    busrelationship varchar(30),
    notes text,
    active char(1) DEFAULT 'N' NOT NULL,
    PRIMARY KEY (company_id)
  )";
  $phpgw->db->query($sql);  

  // id was con, this field needs to be the same as the id field in phpgw_accounts
  echo 'Creating Employee Profiles table...<br>';
  $sql = "CREATE TABLE phpgw_ttrack_employee_profiles (
    id int(11) DEFAULT '0' NOT NULL,
    lid varchar(20),
    title varchar(255),
    phone_number varchar(255),
    comments text,
    mobilephn varchar(24),
    pager varchar(20),
    hire_date date,
    yearly_vacation_hours smallint(5) unsigned,
    vacation_hours_used_todate smallint(5) unsigned,
    location_id int(10) unsigned,
    inorout char(1) DEFAULT 'I' NOT NULL,
    PRIMARY KEY (id)
  )";
  $phpgw->db->query($sql);

  echo 'Creating Job Details table...<br>';
  $sql = "CREATE TABLE phpgw_ttrack_job_details (
    detail_id int(10) unsigned NOT NULL auto_increment,
    job_id int(10) unsigned DEFAULT '0' NOT NULL,
    account_id int(10) unsigned DEFAULT '0' NOT NULL,
    work_catagory_id int(10) unsigned DEFAULT '0' NOT NULL,
    work_date date,
    start_time time,
    end_time time,
    num_hours float(10,2) unsigned,
    detail_billable char(1),
    comments text,
    exported char(1),
    export_timestamp int(11),
    PRIMARY KEY (detail_id)
  )";
  $phpgw->db->query($sql);

  echo 'Creating Job Status table...<br>';
  $sql = "CREATE TABLE phpgw_ttrack_job_status (
    status_id int(10) unsigned DEFAULT '0' NOT NULL auto_increment,
    status_name varchar(20),
    PRIMARY KEY (status_id)
  )";
  $phpgw->db->query($sql);

  echo 'Creating Jobs table...<br>';
  $sql = "CREATE TABLE phpgw_ttrack_jobs (
    job_id int(10) unsigned NOT NULL auto_increment,
    company_id int(10) unsigned DEFAULT '0' NOT NULL,
    contact_id int(10) unsigned,
    account_id int(10) unsigned DEFAULT '0' NOT NULL,
    job_number int(10) unsigned DEFAULT '100' NOT NULL,
    job_revision varchar(5),
    description text,
    quote_date date,
    quoted_hours int(11),
    opened_date date,
    deadline date,
    approved_by int(10) unsigned,
    status_id int(10) unsigned DEFAULT '0' NOT NULL,
    billable char(1),
    summary varchar(60),
    completed_date date,
    paid_date date,
    cancelled_date date,
    total_hours float(10,2) unsigned,
    exported char(1),
    export_timestamp int(11),
    PRIMARY KEY (job_id)
  )";
  $phpgw->db->query($sql);

  echo 'Creating Locations table...<br>';
  $sql = "CREATE TABLE phpgw_ttrack_locations (
    location_id int(10) unsigned NOT NULL auto_increment,
    location_name varchar(50) DEFAULT '0' NOT NULL,
    PRIMARY KEY (location_id)
  )";
  $phpgw->db->query($sql);

  echo 'Creating Work Catagories table...<br>';
  $sql = "CREATE TABLE phpgw_ttrack_work_catagories (
    work_catagory_id int(10) unsigned NOT NULL auto_increment,
    catagory_desc varchar(50),
    PRIMARY KEY (work_catagory_id)
  )";
  $phpgw->db->query($sql);

echo 'Adding Timetrack to applications table...<br>';
// Core groupware can't seem to makeup their mind to include timetrack in the applications table
// so it looks like I will have to test for it's presence
 $phpgw->db->query("SELECT app_name from phpgw_applications WHERE app_name='timetrack'");
 $phpgw->db->next_record();
 if($phpgw->db->f(0) != "timetrack") {
 $phpgw->db->query("INSERT INTO phpgw_applications (
   app_name, app_title, app_enabled, app_order, app_tables, app_version) 
   VALUES ('timetrack','Time Tracking',1,12,
   'phpgw_ttrack_customers,phpgw_ttrack_employee_profiles,phpgw_ttrack_job_details,phpgw_ttrack_job_status,phpgw_ttrack_jobs,phpgw_ttrack_locations,phpgw_ttrack_work_catagories',
   '0.9.10')");
 } else {
   $phpgw->db->query("UPDATE phpgw_applications SET app_version='0.9.10' WHERE app_name='timetrack'");
 }
?>
