<?php
	/***************************************************************************\
	* phpGroupWare - Notes                                                      *
	* http://www.phpgroupware.org                                               *
	* Written by : Andy Holman (LoCdOg)                                         *
	*              Bettina Gille [ceb@phpgroupware.org]                         *
	* -------------------------------------------------                         *
	* This program is free software; you can redistribute it and/or modify it   *
	* under the terms of the GNU General Public License as published by the     *
	* Free Software Foundation; either version 2 of the License, or (at your    *
	* option) any later version.                                                *
	\***************************************************************************/
	/* $Id: class.bo.inc.php,v 1.2 2001/12/10 01:00:27 milosch Exp $ */

	class bo
	{
		var $start;
		var $search;
		var $filter;
		var $cat_id;

		var $public_functions = array(
			'_list'            => True,
			'read'             => True,
			'save'             => True,
			'delete'           => True,
			'check_perms'      => True,
			'set_font'         => True,
			'set_font_size'    => True,
			'read_preferences' => True,
			'save_preferences' => True
		);

		var $soap_functions = array(
			'list' => array(
				'in'  => array('int','int','struct','string','int'),
				'out' => array('array')
			),
			'read' => array(
				'in'  => array('int','struct'),
				'out' => array('array')
			),
			'save' => array(
				'in'  => array('int','struct'),
				'out' => array()
			),
			'delete' => array(
				'in'  => array('int','struct'),
				'out' => array()
			)
		);

		function bo($session=False)
		{
			$this->so = CreateObject('notes.so');

			if ($session)
			{
				$this->read_sessiondata();
				$this->use_session = True;
			}

			global $start, $search, $filter, $cat_id;

			if(isset($start)) { $this->start = $start; }
			if(isset($search)) { $this->search = $search; }
			if(!empty($filter)) { $this->filter = $filter; }
			if(isset($cat_id)) { $this->cat_id = $cat_id; }
		}

		function list_methods($_type='xmlrpc')
		{
			/*
			  This handles introspection or discovery by the logged in client,
			  in which case the input might be an array.  The server always calls
			  this function to fill the server dispatch map using a string.
			*/
			if (is_array($_type))
			{
				$_type = $_type['type'] ? $_type['type'] : $_type[0];
			}
			switch($_type)
			{
				case 'xmlrpc':
					$xml_functions = array(
						'read' => array(
							'function'  => 'read',
							'signature' => array(array(xmlrpcInt,xmlrpcStruct)),
							'docstring' => lang('Read a single entry by passing the id and fieldlist.')
						),
						'save' => array(
							'function'  => 'save',
							'signature' => array(array(xmlrpcStruct,xmlrpcStruct)),
							'docstring' => lang('Update a single entry by passing the fields.')
						),
						'delete' => array(
							'function'  => 'delete',
							'signature' => array(array(xmlrpcBoolean,xmlrpcInt)),
							'docstring' => lang('Delete a single entry by passing the id.')
						),
						'list' => array(
							'function'  => '_list',
							'signature' => array(array(xmlrpcStruct,xmlrpcStruct)),
							'docstring' => lang('Read a list of entries.')
						),
						'list_methods' => array(
							'function'  => 'list_methods',
							'signature' => array(array(xmlrpcStruct,xmlrpcString)),
							'docstring' => lang('Read this list of methods.')
						)
					);
					return $xml_functions;
					break;
				case 'soap':
					return $this->soap_functions;
					break;
				default:
					return array();
					break;
			}
		}

		function save_sessiondata($data)
		{
			if ($this->use_session)
			{
				$GLOBALS['phpgw']->session->appsession('session_data','notes',$data);
			}
		}

		function read_sessiondata()
		{
			$data = $GLOBALS['phpgw']->session->appsession('session_data','notes');

			$this->start   = $data['start'];
			$this->search  = $data['search'];
			$this->filter  = $data['filter'];
			$this->cat_id  = $data['cat_id'];
		}

		function check_perms($has, $needed)
		{
			return (!!($has & $needed) == True);
		}

		function set_font()
		{
			if (isset($GLOBALS['phpgw_info']['user']['preferences']['notes']['notes_font']))
			{
				$font = $GLOBALS['phpgw_info']['user']['preferences']['notes']['notes_font'];
			}
			else
			{
				$font = 'Arial';
			}
			return $font;
		}

		function set_font_size()
		{
			if (isset($GLOBALS['phpgw_info']['user']['preferences']['notes']['notes_font_size']))
			{
				$font_size = $GLOBALS['phpgw_info']['user']['preferences']['notes']['notes_font_size'];
			}
			else
			{
				$font_size = '3';
			}
			return $font_size;
		}

		function _list($start = '', $search = '', $filter = '', $cat_id = '')
		{
			if (is_array($start))
			{
				$params = $start;
			}
			else
			{
				$params['start']  = $start;
				$params['search'] = $search;
				$params['filter'] = $filter;
				$params['cat_id'] = $cat_id;
			}

			$notes = $this->so->read_notes($params['start'],$params['search'],$params['filter'],$params['cat_id']);
			$this->total_records = $this->so->total_records;

			for ($i=0; $i<count($notes); $i++)
			{
				$notes[$i]['date']  = $GLOBALS['phpgw']->common->show_date($notes[$i]['date']);
				$notes[$i]['owner'] = $GLOBALS['phpgw']->accounts->id2name($notes[$i]['owner']);
			}

			return $notes;
		}

		function read($note_id)
		{
			$note = $this->so->read_single_note($note_id);
			return $note;
		}

		function save($note)
		{
			if ($note['access'])
			{
				$note['access'] = 'private';
			}
			else
			{
				$note['access'] = 'public';
			}

			if ($note['id'])
			{
				if ($note['id'] != 0)
				{
					$note_id = $note['id'];
					$this->so->edit_note($note);
				}
			}
			else
			{
				$note_id = $this->so->add_note($note);
			}
			return $note_id;
		}

		function delete($params)
		{
			if (is_array($params))
			{
				$this->so->delete_note($params[0]);
			}
			else
			{
				$this->so->delete_note($params);
			}
			return True;
		}

		function read_preferences()
		{
			$GLOBALS['phpgw']->preferences->read_repository();

			$prefs = array();

			if ($GLOBALS['phpgw_info']['user']['preferences']['notes'])
			{
				$prefs['notes_font'] = $GLOBALS['phpgw_info']['user']['preferences']['notes']['notes_font'];
				$prefs['notes_font_size'] = $GLOBALS['phpgw_info']['user']['preferences']['notes']['notes_font_size'];
			}
			return $prefs;
		}

		function save_preferences($prefs)
		{
			$GLOBALS['phpgw']->preferences->read_repository();

			if ($prefs)
			{
				$GLOBALS['phpgw']->preferences->change('notes','notes_font',$prefs['notes_font']);
				$GLOBALS['phpgw']->preferences->change('notes','notes_font_size',$prefs['notes_font_size']);
				$GLOBALS['phpgw']->preferences->save_repository(True);
			}
		}
	}
?>
