<?php
	/*******************************************************************\
	* phpGroupWare - Netsaint                                           *
	* http://www.phpgroupware.org                                       *
	*                                                                   *
	* Administration Tool for NetSaint Network Monitor                  *
	* http://www.netsaint.org                                           *
	* Ethan A. Galstad <netsaint@linuxbox.com>                          *
	*                                                                   *
	* Written by Bettina Gille [ceb@phpgroupware.org]                   *
	* -----------------------------------------------                   *
	* Copyright (C) 2001 Bettina Gille                                  *
	*                                                                   *
	* This program is free software; you can redistribute it and/or     *
	* modify it under the terms of the GNU General Public License as    *
	* published by the Free Software Foundation; either version 2 of    *
	* the License, or (at your option) any later version.               *
	*                                                                   *
	* This program is distributed in the hope that it will be useful,   *
	* but WITHOUT ANY WARRANTY; without even the implied warranty of    *
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  *
	* General Public License for more details.                          *
	*                                                                   *
	* You should have received a copy of the GNU General Public License *
	* along with this program; if not, write to the Free Software       *
	* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.         *
	\*******************************************************************/
	/* $Id: class.bonshost.inc.php,v 1.13 2001/09/06 22:56:15 bettina Exp $ */

	class bonshost
	{
		var $action;
		var $start;
		var $query;
		var $sort;
		var $order;
		var $filter;
		var $cat_id;

		var $public_functions = array
		(
			'read_hosts'		=> True,
			'read_single_host'	=> True,
			'save_host'			=> True,
			'delete_host'		=> True,
			'check_values'		=> True,
			'select_host_list'	=> True
		);

		function bonshost($session=False, $action = '')
		{
			global $phpgw;

			$this->sonshost = CreateObject('netsaint.sonshost');

			if ($session)
			{
				$this->read_sessiondata($action);
				$this->use_session = True;
			}

			global $start, $query, $filter, $sort, $order, $cat_id;

			if(isset($start)) { $this->start = $start; }
			if(isset($query)) { $this->query = $query; }
			if(!empty($filter)) { $this->filter = $filter; }
			if(isset($sort)) { $this->sort = $sort; }
			if(isset($order)) { $this->order = $order; }
			if(isset($cat_id)) { $this->cat_id = $cat_id; }
		}

		function type($action)
		{
			switch ($action)
			{
				case 'host'	: $column = 'netsaint_host'; break;
				case 'hg'	: $column = 'netsaint_hg'; break;
			}
			return $column;
		}

		function save_sessiondata($data, $action)
		{
			global $phpgw;

			if ($this->use_session)
			{
				$column = $this->type($action);
				$phpgw->session->appsession('session_data',$column,$data);
			}
		}

		function read_sessiondata($action)
		{
			global $phpgw;

			$column = $this->type($action);
			$data = $phpgw->session->appsession('session_data',$column);

			$this->start	= $data['start'];
			$this->query	= $data['query'];
			$this->filter	= $data['filter'];
			$this->sort 	= $data['sort'];
			$this->order	= $data['order'];
			$this->cat_id	= $data['cat_id'];
		}

		function read_hosts($action, $start, $limit, $query, $filter, $sort, $order, $cat_id)
		{
			if ($action == 'host')
			{
				$host = $this->sonshost->read_hosts($start, $limit, $query, $filter, $sort, $order, $cat_id);
			}
			else
			{
				$host = $this->sonshost->read_hgs($start, $limit, $query, $filter, $sort, $order, $cat_id);
			}
			$this->total_records = $this->sonshost->total_records;
			return $host;
		}

		function read_single_host($action, $h_id)
		{
			if ($action == 'host')
			{
				$host = $this->sonshost->read_single_host($h_id);
			}
			else
			{
				$host = $this->sonshost->read_single_hg($h_id);
			}
			return $host;
		}

		function select_host_list($selected)
		{
			$h = $this->sonshost->select_host_list($selected);
			return $h;
		}

		function check_values($action, $values)
		{
			global $phpgw;

			if (!$values['name'])
			{
				$error[] = lang('Please enter a name !');
			}
			else
			{
				if (strlen($values['name']) >= 25)
				{
					$error[] = lang('The short name can not exceed 25 characters in length !');
				}
				else
				{
					$exists = $this->sonshost->exists($action, $values['name'], $values['id']);
					if ($exists)
					{
						$error[] = lang('This name has been used already !');
					}
				}
			}

			if (!$values['alias'])
			{
				$error[] = lang('Please enter a description !');
			}

			if (strlen($values['alias']) >= 255)
			{
				$error[] = lang('The description can not exceed 255 characters in length !');
			}

			if ($action == 'hg')
			{
				if (!$values['hosts'])
				{
					$error[] = lang('Please choose hosts !');
				}

				if (!$values['cg'])
				{
					$error[] = lang('Please choose contact group(s) !');
				}
			}

			if (is_array($error))
			{
				return $error;
			}
		}

		function save_host($action, $values)
		{
			if ($values['access'])
			{
				$values['access'] = 'private';
			}
			else
			{
				$values['access'] = 'public';
			}

			if ($action == 'host')
			{
				if ($values['recover'])
				{
					$values['recover'] = '1';
				}
				else
				{
					$values['recover'] = '0';
				}

				if ($values['down'])
				{
					$values['down'] = '1';
				}
				else
				{
					$values['down'] = '0';
				}

				if ($values['unreach'])
				{
					$values['unreach'] = '1';
				}
				else
				{
					$values['unreach'] = '0';
				}

				$values['max'] = intval($values['max']);
				$values['intval'] = intval($values['intval']);

				if ($values['id'])
				{
					if ($values['id'] != 0)
					{
						$this->sonshost->edit_host($values);
					}
				}
				else
				{
					$this->sonshost->add_host($values);
				}
			}
			else
			{
				if ($values['id'])
				{
					if ($values['id'] != 0)
					{
						$this->sonshost->edit_hg($values);
					}
				}
				else
				{
					$this->sonshost->add_hg($values);
				}
			}
		}

		function delete_host($action,$h_id)
		{
			$this->sonshost->delete_host($action, $h_id);
		}
	}
?>
