<?php
include('inc/datefunctions.php');
class ccsDb
{
	var $fieldArray;
	var $objTimestamp;
	var $objDate;
	var $emptyTimestamp;
	var $res;

	function ccsDb()
	{

		$this->objTimestamp = new Timestamp;
		$this->objDate = new Date;
		$this->res = 0;

		$this->emptyTimestamp = 'null';
	}

		// function stolen shamelessly from DCL	   
	function InitFromGlobals() 
	{
		reset($this->fieldArray);
		while (list($key, $field) = each($this->fieldArray))
		{
			if (IsSet($GLOBALS[$field])) 
			{
				$this->$field = $this->GPCStripSlashes($GLOBALS[$field]);
			}
		}
	}
		// function stolen shamelessly from DCL
	function GPCStripSlashes($thisString)
	{
		if (get_magic_quotes_gpc() == 0)
			return $thisString;

		return stripslashes($thisString);
	}

		// function stolen shamelessly from DCL
	function DBAddSlashes($thisString)
	{
		if (!IsSet($thisString) || $thisString == '')
			return '';

		return addslashes($thisString);
	}


	function DisplayToSQL($thisDate)
	{
		global $dcl_info;

		$eregStr = str_replace('m', '([0-9]{2})', $dcl_info['DCL_DATE_FORMAT']);
		$eregStr = str_replace('d', '([0-9]{2})', $eregStr);
		$eregStr = str_replace('Y', '([0-9]{4})', $eregStr);
		if(ereg('^' . $eregStr . ' ([0-9]{2}).([0-9]{2}).([0-9]{2})$', $thisDate))
			return "'" . $this->ArrangeTimeStampForInsert($thisDate) . "'";
		else
			return "'" . $this->ArrangeDateForInsert($thisDate) . "'";
	}

	function ArrangeDateForInsert($thisDate)
	{
		$this->objDate->SetFromDisplay($thisDate);
		return $this->objDate->ToDB();
	}

	function ArrangeTimeStampForInsert($thisStamp)
	{
		global $dcl_domain_info, $dcl_domain;

		/* if ($dcl_domain_info[$dcl_domain]['dbVersionMjr'] < 7)
			return $thisStamp; */

		$this->objTimestamp->SetFromDisplay($thisStamp);
		return $this->objTimestamp->ToDB();
	}

	function FormatDateForDisplay($thisDate)
	{
		if ($thisDate == '')
			return '';

		$this->objDate->SetFromDB($thisDate);
		return $this->objDate->ToDisplay();
	}

	function FormatTimeStampForDisplay($thisStamp)
	{
		global $dcl_domain_info, $dcl_domain;

		if ($thisStamp == '')
			return '';

		/*	if ($dcl_domain_info[$dcl_domain]['dbVersionMjr'] < 7)
			return $thisStamp; */

		$this->objTimestamp->SetFromDB($thisStamp);
		return $this->objTimestamp->ToDisplay();
	}

	function GetDateSQL()
	{
            // From Urmet Janes for MSSQL support
		return 'now()';
	}

	function FetchAllRows()
	{
		if ($this->db->num_rows() > 0 && $this->db->num_fields() > 0)
		{
			$retVal = array();
			for ($i = 0; $i < $this->db->num_rows(); $i++)
			{
				for ($j = 0; $j < $this->db->num_fields(); $j++)
				{
                        // Explicitly set array to use integer indexing and
                        // don't trust the cursor member.  We just want to
                        // return an array.
					$retVal[$i][$j] = pg_Result($this->db->Query_ID,  $i, $j);
                        // Attempt to set the correct type if this field not a string
					if (!pg_FieldIsNULL($this->db->Query_ID, $i, $j))
					{
						switch(pg_FieldType($this->db->Query_ID, $j))
						{
							case 'int4':
								{
									settype($retVal[$i][$j], 'integer');
								}
								break;
							case 'float':
							case 'float8':
								{
									settype($retVal[$i][$j], 'double');
								}
								break;
						}
					}
				}
			}
			return $retVal;
		}
		else
			return NULL;
	}

}
?>
