# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be) for editing python files.

# Embedded icon is taken from www.openclipart.org (public domain)

from core import models
from core.translation import _t

#---PIL
def init():
    global Image, ImageChops
    import Image, ImageChops
    
def saturation(image,amount=50):
    """Adjust brightness from black to white
    - amount: -1(black) 0 (unchanged) 1(white)
    - repeat: how many times it should be repeated"""
    if amount == 0:
        return image
    amount /= 100.0
    grey    = image.convert("L").convert(image.mode)
    if amount < 0:
        #grayscale
        im = Image.blend(image,grey,-amount)
    else:
        #overcolored = Image - (alpha * Grey) / (1 - alpha)
        alpha           = 0.7
        alpha_g         = grey.point(lambda x: x * alpha)
        i_minus_alpha_g = ImageChops.subtract(image, alpha_g)
        overcolored     = i_minus_alpha_g.point(lambda x: x / (1-alpha))
        im = Image.blend(image,overcolored,amount)
    #fix image transparency mask
    if image.mode == 'RGBA':
        im.putalpha(image.split()[-1])
    return im

#---Phatch
class Action(models.Action):
    label       = _t('Saturation')
    author      = 'Stani'
    email       = 'spe.stani.be@gmail.com'
    init        = staticmethod(init)
    pil         = staticmethod(saturation)
    version     = '0.1'
    tags        = [_t('colours')]
    __doc__     = _t('Adjust saturation from grayscale to high')
    
    def interface(self,fields):
        fields[_t('Amount')] = self.SliderField(-100,-100,100)
        
    icon = \
'x\xda\x01[\x10\xa4\xef\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\
\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\x08\
\x08|\x08d\x88\x00\x00\x10\x12IDATh\x81\xb5\x99{\xaceU}\xc7\xbf\xbf\xf5\xd8\
\xfb\xec\xbd\xcf\xeb>\xe6r\xef\x0c30\x0f\x18\x01a\x06("\xd0 \x08\xc1i} \xf5\
\x15Q\x1b[H\xf1\x91\xd4\xa6Z\x08M[4AmCl\xc5\x18\x1a\t\x8ai5(\x8f\xd6b\x15Q\t\
\x9a@\x15EEK\x91\xa18\x0c\x0c3wf\xee\x9d{\xeey\xed\xd7Z\xeb\xf7\xeb\x1fSR:0\
\x0e\x8f\xcb79\xc9\xce>+\xeb\xf7\xfd\xec\xfd;k\xfd\xd6\xef\x10\x9e%\x11\xc1\
\x8bQ\xeb}\xdf\xbd\x18T\xbf\xc3X\xd9\xdcI\xccd\x16Q2\x0ejq\xb9\xc0\x13\x8a\
\xa2\x9b\x96\xbep\xde7_\xd4\x84/PD\xf4\x7f\xd7\xcf\xfe\xe2\x85\x02\xa4\xef\
\xba\xfb5"\xf9\xe7W\x1f\xd58\xe6\xf4M]\xbd\xaa\x9bQ\x1cGBDT\xb2r\xdf~\xb4\\\
\x1a\x8fr\xe3\x8aj\x07<\xfe\xbew\xe3\xb9\xdf=t\x8e\x87\xbf\x9au%\xf7\xd7*\
\xa8\xe3I\xd1\x8c\x89\xa7\t2Z\x12\n;\xc8\xaa\xbbC\xda\xfe\xc6\to~\xb2^q\x80\
\xf8\xedw]\n\x8c\xae\xdbp\xccQt\xde)\xd3v\xb2\xdb\n\xcd,\xe1N\x16!\x8d4i\x05\
\x1aV\x81\xc7\xa5\xc3c\xf3\xe3\xf0\xe8\x13\x07T\x9e\x17;\x1e]p\x97\x8c\xbf\
\xf0\xba\xc5\x1d\xf7\x92\xaevD\xd7\x8aW\xefI\xdb\xb3\x8dFw.\xd8\xe6&\xa3\xe2\
\x19\ra\tn\xc1\xd7\xa3\xa7\xc9\x15{\xf6\x07,||\xc3%K\xb7\xbfl\x80o\xac#\x13\
\x85\xd6\xbb\x97\xec\xe4\xb6}\xdd\xb5o\xebtR\x15E\x11\x87\xcd\xa7U\xd5[?\xdc\
\xef\xce\xcep\x1a\xc3$\x06\xcah\x90\x08P\x07\xf0\xd2\xd8\xf3S\x8b\xb9<\xbe\
\xeb\x80\xf9\xf6\xcf\x16~\xf5\x8d\x13^\xffo\x89/\xff\xbc\xd9\x9d\xec\xb6\xd7\
\x9e\xab\x1b\x93\x1b\xc5f\xabD\xc5I m\x01\x02\xd8\x07\xe2*W\xf5h\x1e\xe3\xdd\
_^\xaa]\xb8e\xdd[z\xd7\xbc$\x80\xbb\x89\x94\x9fJ?\xc5\x9d\xee%\xc9\xdcl[\xd6\
\x1e7\x9dNtu\x944\xe0\x1e}8\xc8h\xc4U\xed\xe1\xd6\xbf\xda\xe1\x8d\x97\x16\
\x8ds/\n\xed\x18\xd63xP\xc1\r+\x84^\x0e\xb7\xb7\xef\xbdy\xec\xba\xd6\xf9\xf9\
\xb5\x93\xab\xd7\xce\r\xdbG\x9f\xca\x8d\xc95^\xb7\xe7\x02\xa5\xab\x03LS\x832\
\r\x15+\x90!\x84Zq\xb1\x04\xb7\xff\xcb\x07\xc6\xf3\x0f\xa1*\xc6\x9f\x9a\xdb\
\xb6\xf4O/\n\xe0;\x9dx\xae\x80\xba=Y5\xbda\xe6\r\xdb"jO6m\xabm\x9aS]Di*\xc4\
\x1e\xe2\x03BQb\xb4\xe3\xbfe\xbc\xd8SNY\xff\xaa\xcf\xdd(\xc1\xc6\xf2\xf0"\
\xfa\xbd\x02\xf5\xd2\x18\xce\xed\xbd_\xbd\xf6\xc9\x8b\xd7&]#\xed\xb9\r\xe5\
\xaa5G-\xea\xceFOvB`Z\x04\xdd\xd2\xd0\xabb\xa8\xae\x05\xa5\n\xa4\t`\x81\x1b\
\xc0\x1f\xf8\x85\x1f\xfe\xe6\xb3Ke\xd1\xff\xe0\xdcE\xbd\x1f\xbe \x80o\x12\
\xa92\x8b~91;3\xbd\xfa\xa2\x8btk\xcd\x1a\x14\xd9\xc4T\xfb\xe894\xa6\xa6\xc46\
"!R@\x08\x10W\xc3/-\xa1\x9a\xdfC\x83\xc7\x1f\x87\xeb\x0f@\x1f\xbfa\xf8\x94\
\xb4\xf3^\x0e\xd7\xef\xf7\xf8\xb4\x87N:z\xaa[*3\x91J\x15\xaf\n\xabVoX\xe8t:}\
D\x13\x02\xdd\xd20\xd3\x16f6\x82^\x15\x83\xda\x164\x11\x01\xa5\x87\x94\x0c.\
\x82\xdf\xffS\x1a\xee\xbck\x98\xf7\x1e8o\xcd\x1b\x97\x9ez6\x80z\xde\xa4O\xa3\
\x7fh\xcf\xac\x9a]s\xe1Ev\xe6\xe8\xd5\xceN\xcd\xc4\x8d\xa9)A\x94\x88\x90\x16\
\x98\x88(k\x02\x8d\x06\xc4\x18\x98,\x95l\xb6\xcbs\xafY\x8b\xc95\n\xa3\xbfxw2\
\x9e\xdf\xcb\xc3\x1a\xfe\xd5\xbf:g\xae\x1b\x8fT\x83#\x89F\x19g\xbd\x94F\x8f\
\xf5\xdbx\xfaiF\xbe\xd7C\x16j\xc8\xd0\x03%\x035\x83\xba\x11h.\x012\x03(\x02\
\x192\xd3\'\xfal\xeew[qd.;\xd4\xeas\x00\xbe\x99\xd8\x13k\xd0;\xe6N?\x83\xa6&\
\xbb\xf5\xc4\xf4D\xe9\x84b\t\x0cf\x11\xa5\x88t\xb7\x8b\xe8\x98\rZO\xad"(\x8d\
 \x80\xd8!1\xd7\x9c\xae_\xcb\xddd\xa8g>\xfe\xeeI\xbd\xf3_m\xd7\xef\x8c\xd2ZA\
\x89\x12a\x16\xcf\xa3PT\xa5\xad\x16\x0e(yb\x87\x96bo\x80\x1cp\x90e\x7f\x10dP\
\x03\xfd\x1a\xe8\xd5\xc0\xd8C\xf2\x00\x88D\xd3\x9b]\xa3\x95\xfc\xce\xa1~\xcd\
\xa17\xc6\x8c\x9bg\xd7\xaf\xb3\xddUS\xa1\xdbiV*\xf8P\x150F\x19Q\xde\x0b\xbc\
\x87\x04&(\x85P\x16\x08\xce\x81}\x0e\xaes\x81\xab\x19\xce!;\xeex\x9av\x8fju\
\xc7U3\xd9i$\xd46\xc2\xca\x08\x14\t\x83\xe1B\x89\x03u\xd5\x9d\xadz\x8b\xd8QZ\
\xda\x1c9\xe8\x84\xa0, \x10`o\t!@\x9c\x80\x1d\x83\xc7\x0c\x13\xa9\xb8;\xbbv\
\xf1\xfb\xed\x13\x01<\xf2\xbc\x00\xb7G\xe6\x1c\x06\x8e\x9f\xd8\xb4\x91[@a\
\x98CoP5\x83\xf7\xa4\x94\x11\xaar\xf2\xb9\x85\xec\x9d\x17\xd7;\xe0]\xed%\x8c\
r\x91\xba\x0f\x19\xe4bj\x07\xd4\x0e\xa6\x91psv\x0e\xf6W\xbfn(\xafX\xb4\x16"\
\x82\x90\x02D\x01P\x18\xb9\xa4\x05Y\xdc\x8f\xb2\x16\xd9\x13\x02\xad\xd7%\x14\
\x03\xc8\x03(3\x80!\x08\x0bx\x14\xc0 \x04k\xc4\xa6:\xb2t\xc9a\x01\x18xC\x02\
\xb0}l{\x11\xf5\x17G\x98\xea\x18\xa7\x82f\xd6\x00\x84\xbcU,,\x90\xba\x12X\
\x03\xef\x02\x87q\x0e\xd4K\x90<\x17aO\xa8\xbc\x90\xf70\xe5~\x05\x94\xa8~\xa6\
\xa0~\x1f\x00\x91\x08H\xc8hQ\xc4\x14D\xdb\xa1K\x9b\xad\xa8\x18\xa3\xd7\x03\
\xd6<\x9c\x83\xfa\x1ez.\x06u5\x84\x08\\\t\xd8\x10\xa4\xa1%\x18\x11jZm\xf0\
\x9a\xc3\xa6\x90\x179\xb5E\xc4j\xcf\x9e\n[O\xb12\x1a\xb1\xb2\xc1\xa1\x02d4\
\x96*\xcfa\xcaRB\x96\n\x19\x8d\xe0\x83\xb8\xc1@H-BII\x1c\x82\xa0\xf2 \xef\
\xa5\xe1\x07\x86\x00\xe8]\xacx\x88 \x13\x02\x0eBL\x80"b\x16Q\xb5\xd8\x18\x94\
\x8f\xc5\x07\x83}\xcb\x96\xe6\x8a\x12\xbc\xa7\x06\x9a\xfa\xe0\'\xd1\xe0TC\
\x92@\x92\x04\xdd\x98\x8d8\x8a\xcco\x03X\xaf\x88\xc4v:\x908\xd12\x1e{mBp\xcb\
\x05\xdc8\x87NS\xd0\xae\xdd\x12\x1d\xbd\x86\xa1\x95\xb0\xf7\x8c\x10\xc8t*b\
\xa9E\x9c\x079\x07r\xcc\xad\x88i\x94\xc6\x08u\r\xbe\xbf\xd6\xf4\xa6(\x80\x02\
D\x04BF\x81\x08\x8e\xad\x81\x00\x80(\xee\xd5\x91\x9e\xb1\x15d\xc8\xc0\x90\
\x81\x8c!Y\x80\xa4\x1a\x92jp\xc2T<0\x86\x8d\xfca\x01j\xc1QJ+\x89\x8e\x7fU\
\x14F\xa3\x9a\x9d\x86\xb5\xce\xe5\xf3\x07D\x86\xb9\x988\x12\xb6V\xb28\x01AH\
\'\r"\t\xa0\xa8\x02\xa8&T5B\xed\xe1\xc7\xb9\xf6~HYfQ\xe55\xfc\xbe@JiR:\x05L\
\x02A\x02\x88F \x8e@\x03\r\xae\x98\x9c\x06B\x00\xf8\x7f\xd7x\x19\x04H?@R\x06\
g\x1cjRn\xd4\x8b\xc0\xa1:,@\x10D\xaa\xd5qND\xf9\xe1\x88B\xa9\xa0\xe3\xda\x93\
\x08\xb1\xf7\xe4@\xa2\x18T>\xf94l\x1a\x8bD\x16\xb6\x95\x02\xb1\x03\xa9\x1a\
\xbc\xbc,n\x94S=*0\xac\x17\xc1"\x10\x08d\x89\xa1T\x03d\x1b\x04\x9d\x88A\x8a\
\xc0\nF\x07\x80\x9aJ\x88H\xb9\xda\xc13\x84\x88\x88 \x10\x01\x84\x01\xee\x07\
\x84\xe5 \xb56\x128B\x10>,\x80\x06\x06\xd2\xedd\xe5h\x8c\xc4(DFQ\\\x155\xd5F\
\xc4{\x10i\x12\n\xe0\xc1P\\\x91\x13%\r\xc5\xae\xe6\x80\xa0\xa0\n!\xcf\xc4eE\
\xc4\x01\x10\xe0\xa0\t\x80\xc0\xa4\x0e(\xa2u\xa9\x90\xca\x08\xa6\x01\xa95i#\
\x80\xeeh0\x98\xd9\xc7\xb2\\0GP\xb6\x11\xe5\x10\x88/\xeb\x84}\xd0\xd6\xa8BC\
\n\xc7\x1c\x890\x1d\x1e@\xeb\x85\xf18o\x16J\xab\xc4\x10E\x9a\xc8h\xc0\xe4\
\xbar6\x8a\x956 \x1bAY\xad\x14\x89HU!\xf8Z\xc3\xd7dZ\x81\x82c\xa8\x83Y\x0e\
\x11\x00\x0c@\x00\xd1\n<&2*\x16\xd2\r\x82J V\x93\xd1\x01@\xa2I9\xb0\xaf!nYC\
\x93\xf8\xbcL\x98\x85\xe0E\x89\x08\xd5\x95\xcf\xb4Fu\xf0\x81\xc8\xbe\xc3\x02\
\x88\xf7O-\xcf\xcfoh\x15\x05\x1a\x9a\x8c\xa9\xabZ\x1bPgbn\xe8\xb3V\x83\xd2D(\
\x8e\xc9\x18\x0bEB\x9a\x83\x90+\x05\x15@M!\r>h\x98\x08\xc2J\x80@\x12\x04\x01\
\x80\xcd\x15\x08\x96`b(4H+\x8d\xd4\xd65$S\x10\x07\xa2\x02l\x1b\n\x9c\x07f(\
\x08\x08,\x003$\x08\xbc\xe3\x86\x04\xd6\x80\xbf\xff\xf0\x00\xc0\xa3c\xc1\x05\
\xc3\xfe\xc0\xa4\n!\xd2\xca\xc4\xa6!\xd3\x86{Ck\xa6\xb8\x11\x135\x12\xe88\
\x82\x06AI\x00\xd5\x86Pi!\x19\x12\x00(\x08\xb1@\x98\x14\x14\x0b\x89\x88\xb0\
\x00\\\xc8A\x00\x89\xa0t\x0cMV"Sy\xf8X\x0bb@l\x00Y\xc0\xcb\xc1\x9f\x00\x03\
\xc2B`\x06XH\x82\x90p M\xee;\xcf\xf6|h-to\x0e\xe81\xb3\x1e\xb3\xe8\x9c\xc5\
\x94\xcaFAi\xdd\xb1z`#C&M\xa0\xd2\x94t\x96A\xa7\x19\xe9\xb4I\xaa\x91(mR2\x10\
RD\xa4\x05\xe4\xb8)\x08\x02\xf6\x02M\x00f"\xb8\x8a\x11j@S\x8a\xc8d\x01\xaai!\
\r\x82\x18\x12\x13)\x92\x88\xc0\xe1`\xa9\x12\x02\x0e^\x0b$01\x07\x03\xe0\x81\
\xc6Y\xd2?,\xc0e"wk`\x7f\x1f0#\x113b6\x85\xd2\xa6\xd6&\x9a\xb0\xdc7\xc6\x8a\
\x8d,\x99\xa4A\xaa\x99\x1153B\x9a\x92J2R\x94@\'\ti\x01)\x089\xceD\x1c\x10\
\xfc\xc1\xc5\x04\xabb@\x02H\x14\x14\xc5\x14\xd9\x96\x085-(\xb1$Z!6\x02!%\x01\
@`\x083!0\xc0A\x07\xcf\xd696\x10\xfe\xfc!\x0f\xfc\xb9\xd5h\x06|q\x19\xd0}\
\x81\x1d\xb2\xd8\xb1\xc0\x14L\xba\x06\x99\xc9\x88z\xda\x1a2I\x02\x93&\xa4\
\xd3\x8cT\x9a\x82\x1a\t8$\x84\xa8\x01\xd2\x1a\xe4\x99\xc0B\xa5W\xcc\x81\x89c\
\x80\xd9Q\xf0\x8e\x08B\x10\x86!\x0e\x10\xad\x05\xc6\x08\x8c\x91\xb6&\x04Q`(\
\x04V`V"l\x82g\xe3}\xb0J\xf8\xa1\xec\x1c\xf7\xd0\x11\x01:\xc0\'\t\xe8\xf5\
\x00\xd3\x17\x98\xa1\xf7:g6U\x10\xa3\xc5\xd5\x89Qc\x8a\x0c\x99n\x07\xd1D\x07\
\xb6\xdd&\x95\xa5\xc4l\x88K\x05\x88@\x82#\x16\x8f2\x18\xd4\x01\x10\x03\n\xae\
\x02|\r_W\x08u!\xe4\xcb\x00\x16\r!%q\xa4D\x07\xcd!\x18a\xb6\xc2\xc1\xb2\x0f\
\xb6,B\xe4}\x88\x8c\xe2\xb1\x91\xf0\xb1C\xbd>/\xc0\xbbDx\x1a\xb8b\x19P=\xc0,\
\xd5\xce\xf6\xca\xca,\x97\x95\x1aWN+W\xe4Jk\xa7\x9bMR\xdd\x0e\xa9v\xeb`:\xa5\
MrCM\x01D\xde\x07\x14\xb5\xa3Qh\xa0\xf6\x0ci\x88H]\x91\xab\np]\x10W\xe3P\xe4\
c-\xc1\x83\x9dS\xdc&\x92P+\xe1\xda\x88\xafMYq4.8\n\x81\xad"QJ\xf07\xd9\xf9\
\xf2\xf4\xf3\x01<\xe7<\x00\x00\x97\x8b|\xebsDw.\x01\x17\xdb\xaa\x12]\x96Dy\
\xae0\x1es\x92$H\xea|\xc4U\xd5QY\xa2\x10\xc7\xa0$\x81\xc4\x11<b\x94}F\x10FU\
\xd7\xa8\xbd\x00P\x12%\x81\xb8\x1e\x89\xd2\rb=\x10e\x8c\xb71\t\xd7\x84\xd0\
\x16\x94\x9c+?\xca\xad\xb8\\\x89\x0b\xfa`y$\xca\x18(\xb0\xdc\x9e\x9d/\x87m\
\x90=/\x00\x00\x08\xf0\x9e\x04\xb8\x7f\xd1\xfb-\xaa(\x1c\xe59\xf1p\xa4\x82\
\x8d$\xb4zh&\xc9\xa8\x08\x9d\xb6\x18\r\xab\rXk\x8c\x04\xc8\x17\x03\xa0=\xbc\
\xf3p! /S\xc9\xce\x19Q]\xe5\x14\xd1@H[\xef\n\xa11\x9c\x92nC8T$U_s=d\xf8\x82$\
\x08\x8b\x80\x00Pl\xe4qs\x1c\x9e7u\x8e\x08\xf0\x11\x91p=\xd191\xf0\xa3\x85\
\xd1\xe8d\x8a"\x1f\x8c\x11o\x0c\xbb\x85\x18^i2\x13\xf58$\xcd\x14\x81iP\x16(\
\xbc\xa32\x08\x8a\xf9\x1al\x15<\xd5\xd8Q\x1d\xcb\xbb\xbc\xf2[&\xff\xcbxc\xa0\
@,\r-e\x87D\xd3H\xa8(\x08~\x91\xa4\xca5\x87\x82\x94\x88\x16\x02%\x16#\x02\
\xde\x9f\x1e\xfd\xffk\x9f\x17\x0c\xf0,\x88\xb3L\x08\x0f\xec\x1f\x0c^\xed\xb5\
\xf65\x11\x95\xdeKK\x04qUI\x94e\xe3\xc2Kc<\x18\xd8*\xcf1*r\xa9A\xa8s\x0f\x92\
\x1a\xb7\xcf\x9d\xe1\x1f\xf9\xcez\xbe\xeb\x9d\xbf\xd6^\x86\xac\xc8Q\xd2s\nz\
\xc4\xc1h\r\xc9\x89|O\xc4\x0f \x10\xa55(\x8b0o-\xde\xd1\xbdPv\xfe6\x7fG\x04x\
\x16\xc4\x99\\U\x0f\xee[^>\xb1b\x0eE]#w\x8e\xb3\xf1\x18Q\x92\x80\x88\xaa\xba\
(\xc3h\xd0\x8fG\xa3\x01\xd5E\x0e\x97\x17(MS~\x9a\xcc\x11\xca\xa0~\xd1\xdbr\
\xc7\x99\xd3?y\xfb\x98\x1d\x82\xaa\xbd\x19\xf4\x95\xb2Z\x88+\x81\xd4Fk\x96\
\xd8BR\x8b\x9fQ\x89\x8b\'~OFG\xf2\x06\xbc\x88\xde\xe8?\x13\xd9}\xc0\xf7\x06\
\xd6\x9e\x9df\x19gI"i\x92H\xa3\xd9\x84V\nRUR-\xf71\xea\x0fm\xed\x9c\xa1\xe0i\
\xdf)g\xe1\xd6\x99\xf3\x16\x9f\x18\xaf\xbeB\xee\xfb\xc0\xbf\xec\xfc\x1a\xddq\
`\x80?\xa8\x03X\x1b\x04\xad\xc0\xc6@\xe2\x08\xdc\x88\xc1\r\x8b\xaf\xce\xbeY>\
pD\xd3/\xa7\xb9{\x13\xd1[v\x037\xe4q|T\x1aE\x1c\x19#\x06\x00\xbc\x97P\x96\
\xf0\xce\xc1\x10)\x89\xbb\xe5M\x1f\xfcq\x9b\xe2\xd6\x9f=\xfe\xe9\xb9\xeb\x01\
\xe0\x13\x9f\xf8\x84z\xdd\xcc?~u\xb1/o\x1b\xc8Q\xf6\xcc\xd5\xff\xc9\xd6"D\
\x11~\x13Y|r\xf5\xc5\xf2\x95#\x1a8\x04\xe0\x88)t\xa8.\x17\xb9\x13\xc0\x9d\
\x9f%\xba\xee\x89\xaa\xfap\x00"\x03\x80\x00Q\xc6@G\x11:\xcc\xa3\x1b&\xce\xbc\
!\xfc\xe0\xbaS\xf7\xe5\xed\x1a\x9f\xfe\x0c\x00`aa\xe1\xcdw?q`\xe1\xb4\xd3\
\x92Rdz\xec=\xaem%\xb8g\xdd\xdb\xe59;\xec\x0b\xd5K\xfa\x7f\xe0\x19}\x99hr\
\x00\xfc\xed\x008w\xdch\xac\x9e\xfd\xe3\xf7\xa5\xf1\x0f\xbe\xbf\xdd\xff\xd1\
\x87\xbe\xf6\xcb\xed\xdb\xbf\xe2\xbd\x7f\xfd\xcd7\xdf\xfc\xc5g\xc6\xdfv\xdbm\
\x97\xdcv\xdb;\xefl\xd7\x9d[\xaf\xfe\xe0\xeaj\xe3\x1b\x1e\xb9\xf4%\x99>bk\
\xf1\x05\xea\xfd"K\x7f*\xf2\'\x7f%\xf2\xaa\x99\x04\x9f>\xeb\x8e[\xe8\xf2A\
\xaf}\xe9\xf0\xc9\xebO8\xe1\x84w\xb6\xdbm\xfa\xe8G?\xdazf\xfc1\xc7\x1c\xd3\
\xbf\xf5V\t2\xf5\xb6\x9b_\xaa\xf9C\xf5\xb2\x00\x9e\xad_\xf7\xca\x1b\xbe\x9e\
\xd3\x9a\xcb\xcf{\xd3\x95K\xef\xfbH\xbce\xcb\x96\xe5,\xcb\x9e\xcc\xb2\xec\
\xf8g\xc6\xdcu\xd7]\xf7]u\xd5Ug6\x9bM\xb7RqW\x0c\xe0F\x91\xfeg\x06\x83\xbd\
\xadn\xb7s\xdf}\xf7\xcd^x\xe1\x857\x9er\xca)\x9b\xa2(\xea<3\xe6\x9ak\xae\xa9\
\x9b\xcd\xe6\t\xadV\xeb?V*\xee\x8a\x01<#\x11\x99\xca\xb2\xec\x91+\xaf\xbcrM\
\xbf\xdf\xbf\xb9\xd5jM\x02\xc0{\xdf\xfb\xde\xf6\xcf\x7f\xfe\xf3\xd7\x8eF\xa3\
\xd9k\xaf\xbdv\xb8R\xf1V\x1c M\xd3\xa7fff\xdeZ\xd7u\xb8\xe2\x8a+\xca4M-\x00\
\x1cw\xdcq\xed{\xef\xbd\xf7\'\xabW\xaf\xde\xb1\x92\xf1^\xf42z$\xb5\xdb\xed\
\x1f?\xf8\xe0\x83\x93\xddnwx\xcf=\xf7\\h\x8c\x89\x00`\xcb\x96-\xd3\xfb\xf7\
\xef?Vk\xfd\x93\x95\x8c\xb7\xe2o I\x92\xc7\xa3(:a\xeb\xd6\xad\xeb/\xb8\xe0\
\x82{\xfa\xfd\xfeZ\x00\xd8\xb4i\xd3\xfc\xfc\xfc\xfc\xb6\xcb.\xbbl\xe7J\xc6{Y\
\xfb\xc0\xe1t\xf5\xd5W_\xbf~\xfd\xfa\x8f\xed\xd9\xb3\xe7\xeb\'\x9f|\xf2\x8f\
\x16\x16\x16z\xbbv\xed\xfa\xd6I\'\x9d\xf4\x87\x97^z\xe9\xdf\xbd\xdc\xf9Wl\
\x1f8\x9c\xb6n\xdd\xfa\xd0\xee\xdd\xbb\xcf\xd5Z\xff\xf5\xf4\xf4t\xb6q\xe3\
\xc6\xa7\x92$\xb9nnn\xee\x87+\x1d\xeb\x15\x01X\xb7n\xdd\xb1\x00\xd6---}(I\
\x92\x9d\xb7\xdcrK\xb4m\xdb\xb6]\xcdfsE\xf3\x1fx\x85\x00\xca\xb2\xbcMk}\xec\
\xd9g\x9f\xfd\x97\xedv\xfb\xc0\x97\xbe\xf4\xa5\x7fo4\x1a\xbb\xcf8\xe3\x8c\
\xdfz8y)Z\xf1U\x08\x00\xce?\xff\xfc\x87\xdb\xed\xf6\xa9\xa7\x9f~\xfap\xfb\
\xf6\xed\x8b\xdb\xb7o\xdfb\xad}\xdeC\xf9\xcb\xd5+\xf2\x06\x00 MS\xc2\xc1\xf6\
\xee<\x80K\x00|\xef\x95\x88\xf3\x8a\x01(\xa5\x9eI\x97y\x00\xb4y\xf3\xe6\xf1+\
\x11\xe7\x7f\x00\xba\x9e\x19[4+\xbc\x11\x00\x00\x00\x00IEND\xaeB`\x82\x05\
\xb2\xb7\xee'
