# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/

# Embedded icon is designed by Igor Kekeljevic (http://www.admiror-ns.co.yu).

from core import models
from core.translation import _t

#--- PIL function
def init():
    #lazy import
    global Image, ImageChops
    import Image, ImageChops
        
def invert(image,amount=100):
    inverted = ImageChops.invert(image)
    if amount < 100:
        inverted  = Image.blend(image, inverted, amount/100.0)
    if image.mode == 'RGBA':
        inverted.putalpha(image.split()[-1])
    return inverted
            
#--- Phatch Action
class Action(models.Action):
    label       = _t('Invert')
    author      = 'Stani'
    email       = 'spe.stani.be@gmail.com'
    init        = staticmethod(init)
    pil         = staticmethod(invert)
    version     = '0.1'
    tags        = [_t('colours')]
    __doc__     = _t('Invert the colors of an image')
    
    def interface(self,fields):
        fields[_t('Amount')] = self.SliderField(100,1,100)
    
    icon = \
'x\xda\x01\x91\nn\xf5\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\
\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\x08\
\x08|\x08d\x88\x00\x00\nHIDATh\x81\xd5Y]l\x13W\x16\xfe\xee\\\x8f\xed\xb1\x9d\
\x14\xe2\x84>\xc4)46P\xdc\x14\tE\xd9(\x82\xc6\xa8\x08D\xa9\xaa\xaaJa\xa9T\
\x14\xa2\xb2BJA\xa2E\xca\xb6U\xd5\xaa\xa2R\x05/\xedC\xa9\xd4\xcdC\xa8h\xbb\
\x94>\xf4\xa1\x08-\xdd\xb0M(\xb0@\x14\x81\x9a\xc5\xd1\xc6&\xc4@\xd2$v\x80`;\
\xe3\x9f\x99;\xfb\x10\xdf\xe9\xc4\x19\'N`\xb5\xdb+]\xcd\xf8\xdc;\xe7~\xdf9\
\xe7\x9e\xfbc\xa2i\x1a~\xcfE\xf8_\x03x\xd8\xf2\xbb\'`\xf9/\xe8$\xf3\xb4?\xd2\
\x98}\x14\x04\x88\xe1\x99_\x8dE3\xa9\xc0C\x12z\x18\x02:\xd0`0H\xfd~\xbf\xd0\
\xda\xda\xdap\xfb\xf6\xed]\xb2,?!\xcb\xf2\xe3\xc9d\xb2\x0c\x00\x9cN\xe7]I\
\x92\xc6$I\xbaUUUu\xfc\xf3\xcf?\xffg0\x18d~\xbf_5!\xb40\x10\x0b\xcdB\x84\x10\
\xa2i\x1a\xe9\xea\xea\x12<\x1e\x0f=r\xe4\xc8s7n\xdc\xf8\xf3\x8d\x1b7\xfe\x10\
\x89D$\x9b\xcd\x06\x9f\xcf\x87\x95+W\xc2\xeb\xf5brr\x12\xa1P\x08\xa1P\x08###\
\x00\x80\xe5\xcb\x97\xcb^\xaf\xf7\x8a\xd7\xeb=\xdc\xd6\xd6\xf6\x8f;w\xee\xa8\
\x1b7nd\xd3\xaa\x17\x06h\xa1\x04\x08\xa6\'>=p\xe0@\xed\xe5\xcb\x97;zzzV?\xf5\
\xd4Shmm\xc53\xcf<\x83\xaa\xaa*\x08\xc2tn\xc8\xd7\x9dL&\x11\n\x85p\xe6\xcc\
\x19ttt \x9b\xcd\xa2\xae\xae\xee\xdf\xf5\xf5\xf5-\x9f~\xfai/\x00\x15\x00\xc3\
\x02\xbc\xb1\x10\x02\xa4\xab\xab\x8b\xaeZ\xb5\xca\xbak\xd7\xae\xd3\x17.\\\
\x08,[\xb6\x0c\x07\x0e\x1c\xc0\xb6m\xdb@\xc8\xcc\x90\x9fK\xaf\xa6i\x18\x1f\
\x1f\xc7\xd1\xa3G\xf1\xfd\xf7\xdf\x83R\x8a\xf5\xeb\xd7w\x1f?~|\xdb\xc0\xc0@f\
\xe3\xc6\x8d<\xb4\x1e\x19\x01\x02\x80~\xfc\xf1\xc7\x95\'N\x9c\xb8\xdc\xdf\
\xdf\xff\xf8\xc1\x83\x07\xd1\xd4\xd4\x04\x8b\xa5\xf8id6V$\x12\xc1\xe1\xc3\
\x87q\xe9\xd2%\xac]\xbbvl\xe7\xce\x9d\xf5\xef\xbc\xf3\xce0\xa6\xbd1/\xb8b\
\x08\x10\x00\xf4\x8d7\xdeX\xff\xc3\x0f?\xfc\xed\xf6\xed\xdb\xf6\x0f?\xfc\x10\
[\xb6l)\x1a\xe4|\xf2L&\x83\xfd\xfb\xf7\xe3\xfa\xf5\xeb\xa8\xaa\xaaJ\xbd\xf8\
\xe2\x8b[\x8f\x1e=z\xa1\x18\x12\xf3\x11 \x00\x84\xf7\xde{o\xf9\xb1c\xc7\x82\
\xc3\xc3\xc3\xb6\xe6\xe6f477?2\xf0\xbc\xdc\xbbw\x0f\xfb\xf7\xef\xc7\xd8\xd8\
\x18*++\xd3\xbbw\xef\xf6\x7f\xf4\xd1G\x11\xcc3\'\xe6$\xf0\xddw\xdf\xd1\x8a\
\x8a\ni\xdf\xbe}7\xaf_\xbf^\x1e\x08\x04\xd0\xd6\xd6V4\xc0b\xc1\xf3\x12\x89D\
\xd0\xd6\xd6\x06Y\x96\xf1\xf4\xd3O\xc7>\xfb\xec\xb3\'\xa3\xd1\xa8\xbc}\xfbvu\
1\x04\x08\x001\x10\x08\x9c;w\xee\\\xbd\xc3\xe1@{{;l6\xdb\xa2\x01\x16\xf3\xcd\
\xa9S\xa7\xf0\xd5W_\x01\x00\x1a\x1b\x1b/www7\x02\xc8\xa2\x80\x17\n\xed\x85\
\x08\x00a\xef\xde\xbd\xcf]\xbcx\xb1\x1e\x00\x1a\x1a\x1a\xc0\x18\x83,\xcbz\
\x9d\x9a\x9a\x9a\xf1{>\xf9|m\xa9T\n\xf5\xf5\xf5zb\xb8x\xf1b\xfd\xde\xbd{\x9f\
\xcb\xe14\xdd\xa2\x14J!$\x1c\x0e[zzz\xda\x15E\x01\x00\xd4\xd4\xd4@\x96\xe5\
\xa2\xac\xb8\x98\xc2\xbf\xb3X,\xa8\xae\xae\xc6\xc0\xc0\x00\x14EAOOO{8\x1c\
\xf6\xf9|>S/\x14$p\xe8\xd0\xa1W\xaf]\xbb\xe6\xe1\x02\xa7\xd3Y\x14\x81b@\xce\
\'_\xbat\xa9\xfe~\xed\xda5\xcf\xa1C\x87^\xfd\xf2\xcb/\x8f\x9b}kF\x80\x04\x83\
A\x1a\x0e\x87\xdf2*\x16\x04a\x06\x81\x85\x00\x9c\xab\xcdLn\x9cg\x9a\xa6!\x1c\
\x0e\xbf\x15\x0c\x06\xbf\xf1\xfb\xfd\xb32\x92)\x01\xbf\xdf/\x84B\xa15Fa,\x16\
\x83\xc5by\xa8TYl\xdb\xdd\xbbwg\xfc\x0e\x85Bk\xfc~?\x9f\x07\xf3\x13hii\xd9\
\x1e\x8dFg\xb4\x8d\x8e\x8e\xa2\xb4\xb4tA@\x16\xeb\x91X,6C\x16\x8dF----\xdb;:\
:\xbe\xc9\xefoJ`dddg\xbe\xb0\xaf\xaf\x0fUUU\x0b\x02R\xac\xdc\xe1p\xc0\xe5rar\
r\x12ccc\x18\x1d\x1d\x9d\xd5\'\x87\xe9\xaf\xf9\xf2|\x02\x04\x00I$\x12\xb3\
\x90\xde\xbcy\x13\xd1h\x14.\x97kN\x80\xc5\x80w\xb9\\X\xb7n\x1djkkQYY\t\x87\
\xc3\xa1\xf7\x99\x9c\x9cDkk+\x06\x06\x06p\xf2\xe4ItvvBQ\x14\xe40\xf13\x88>\
\x80\xa9\x07\x92\xc9\xa4;_\xc8\x18\xc3\x993g\xb0e\xcb\x16PJ\x0b\x82\x9f\x8bT\
EE\x05^z\xe9%\xd4\xd7\xd7\xeb:\x8cdUU\x05?OTVV\xa2\xae\xae\x0e\x91H\x04G\x8e\
\x1c\xc1\xe4\xe4\xa4\x1b&k\xc1,\x02\xe1p\x98\xc4\xe3q\xd3`\xbfw\xef\x1e\xba\
\xbb\xbb\xd1\xd0\xd0\xb0\xa0\xedsYY\x19^~\xf9e\x04\x02\x81Y\xc0\x8dOU\x9d\
\xde1\x10B@\x08\x81 \x08\xa8\xa8\xa8\xc0\x07\x1f|\x80\x8e\x8e\x0e5\x1c\x0e\
\x13\x9f\xcf77\x01\x00H\xa5R\x05\xf7\xc8\xa3\xa3\xa3\xb8z\xf5*\xd6\xacY3\xab\
\xcd,\x9f755a\xf3\xe6\xcd\x10E\xd1T\x1f!\x04\x8c1\x1d|\xa1>;v\xec\xb8o\xd66\
\x0b\xa8\xcf\xe7\xd3\xf6\xec\xd9\xd3\xf7\xc9\'\x9f\xd4\xc5\xe3qS\x85CCCH$\
\x12\xa8\xae\xae\xd6\xe3\xd7\x08\xden\xb7\xe3\x95W^ASS\x93\x9e\xd3\x0by\x881\
\x06\xc6\x98\x0e4\xbf/\x7f\xb7\xdb\xed#>\x9f\xaf\xb8\x95x\xc3\x86\r}^\xaf\
\xb7\xee\xddw\xdf\xc5\xf0\xf0\xb0\xe9\xc0\xb1X\x0c\x13\x13\x13(//\x87\xc7\
\xe3\x81(\x8a\x10\x04\x01/\xbc\xf0\x02v\xef\xde\x8d\xb2\xb22\xd3\xef\x8c\xc0\
\x18c\xb3\xc0\xf2\xca\x89\x19\xdaM\x81\x98m\xe64J\xe9pee%\xda\xdb\xdb\xb1c\
\xc7\x0eH\x92T\x10D4\x1aE__\x1f\xbc^/\xbe\xf8\xe2\x0b\xbc\xf9\xe6\x9bX\xbat\
\xe9\x0c0f\xc0\xb8\xd5\xf3\xf5\x19\xfb\xa9\xaa\xaa\xf7\xa5\x94\x0e\xa3\x88\
\xbd\x90\x86\xe9\x03\xc4%\xc6\x18JJJ\xf0\xf6\xdbo\xe3\xe0\xc1\x838u\xea\x14\
\xfa\xfb\xfb144\x84\xc1\xc1A\x00\xc0\xea\xd5\xab\xf1\xec\xb3\xcf\xa2\xb9\xb9\
Y_#\xcc\x80\x15[\x8c\x04\x8d\xe0s\x04.\xc1\xe4pcv\x1e\x10&&&\x9c\xbd\xbd\xbd\
\xb7\xacV\xeb\x12\xbe\xc88\x9dN\xd8\xedv\x88\xa2\x08J\xa9\x1e\xaf\xf9\xd9h1\
\xa0\xf9SUUd\xb3Y\xa4R)$\x93I$\x12\tLMM!\x93\xc9\xdc\xaf\xad\xad}\xc2\xedv\'\
s$~\x03k\xa6\xd3\xedv\xa7\t!?rKd\xb3Y(\x8a\xa2[\xc5l\x92=\x0cx\xfe\xce\xc7S\
\x14\x05\xd9lV\x1f\x8f\x10\xf2\xa3\xdb\xedN\xc3$\x84L\t\x00`\x94\xd2o\x8d\
\xca2\x99\x8cN\xa4P\x0c/\xb6p}fc\xa9\xaa\nJ\xe9\xb7(p6.t"c\xd5\xd5\xd5\xa75M\
\xeb1*\xcdd23<\xc1I<\xcc\xd9\xc0\x18\xf3\x8a\xa2\xe8\xe3p\x02\x9a\xa6\xf5TWW\
\x9fF^\xe8\xccG@[\xb1b\x85b\xb5Z\xdf\xe7J\xd3\xe9\xb4^3\x99\x0cTU\xd5\xdd\
\xce\x01\x15C\xc4\xd8\x8f\x87\xa3\xaa\xaa\xa6c(\x8a\x02\xab\xd5\xfa\xfe\x8a\
\x15+\x14,\xf0L\xac\x01`\x1e\x8f\xe7\'B\xc8i#\t\xa3\x85\xb2\xd9\xec\xacU\xb4\
P\xfa\xcc\'\xc8\xbd\xc8\xf5p\x9d\x8c1\x1d<!\xe4\xb4\xc7\xe3\xf9\ts\\\xad\xcc\
u\xad\xa6\xf9|>%\x91H\xec\x19\x1f\x1f?\x9f\xc9d\xaa\x8dw\x9e\x8c1}\x95\xe5r\
\x00\xfa\x1e\xc6\xac\x18\x13\x00\'\xc0\r\x03\x00\x92$\xc1n\xb7#\x16\x8bAU\
\xd5\xc1e\xcb\x96\xed\xf1\xf9|\x05\xad\x0f\x14w\xb1E\xcf\x9f?_#\xcbr7\xa5\
\xb4\xd4f\xb3\xc1n\xb7\xc3f\xb3\xe9\x95\xa7VA\x10fl\xc4\xcc\xc0\x1b\xb3\r\
\xb7<\xa5\x14\xa2(\xc2f\xb3app\x10\x0f\x1e<x IR`\xc3\x86\r\xff\xc2<\xb7s\xc5\
\\-\n\x00hww\xf7\xe6t:}B\x14\xc5\x12Q\x14a\xb5Zg\x10\xb0X,\xb0X,\xfan3\x7f\
\xcb\xcd\xc3\x8cOV\x9e\x1c\xb8\x0eJ)FFF\x10\x8dF\xe36\x9bmg \x10\xf8;~\xbb\
\xad.l\xe1"3\x88\x00\x80\x9e={v\x9d\xaa\xaa\')\xa5\xcbEQ\x04\'\xc2\xdf9\x89\
\xb9<`\x04/\x08\x02\xdcn7R\xa9\x14~\xfd\xf5W\xc4\xe3\xf1[\x8a\xa2\xfc\x91Rzu\
\xeb\xd6\xad\xd9\xf9\xc0\x17M\x80\x10"<\xff\xfc\xf3b*\x95\x926m\xda\xe4Y\xbb\
v\xed_$Ij\x10\x04a\x06xJ),\x16\xcb\x8cP\x020#tx\x1a6.V\x8a\xa2 \x99L^\xe9\
\xec\xec\xdcw\xf6\xec\xd9;\x8a\xa2$C\xa1P\n\x802\xfd\xf9\x1c\xd7\x87s\x11 \
\x84\x089\xeb[\x01\xd8$Ir:\x1c\x0eWiii\xe9\xeb\xaf\xbf\xbe\xb5\xa6\xa6\xe6ON\
\xa7\xd3\xc3\xe3\x9fR\xaao3\xccB\x88\xa7L>\x81UUE"\x91\x18\xe9\xed\xed=\xd6\
\xd1\xd1\xd1\x99H$\x1e\xa4R\xa9D:\x9dN\x00\x90\x01\xa4\x00d\x000M\xd3L\xbdQ\
\x90\x00\x996\x1f\x05`\x03`\x07\xe0\x04\xe0\x14E\xb1\x84R\xea\xb4\xdb\xed\
\x8f9\x9d\xce\xc7^{\xed\xb5M555\r\xe5\xe5\xe5OZ,\x16\xca\xad/\x08\x82\x9eq\
\xf8\xa1\xc5\xe0\x056>>>\xf4\xcb/\xbf\\\xf9\xfa\xeb\xaf\xbbdY\xbe\x9fJ\xa5\
\xe2\xaa\xaa&\x14E\x89\x03H\x00\x98\x02\x90\xcc\x91\xc8j\x9afz\xe2\x99\x8b\
\x80\x00@\xcc\x11p\x00p\x19j\t\xa5\xb4D\x10\x84\x12\x8b\xc5\xe2\x12E\xb1\xa4\
\xbc\xbc\xbc\xa2\xb1\xb1\xd1\xbfj\xd5\xaa\'\x96,YR\xe2r\xb9\x9c%%%\x12\x00\
\xc4\xe3q9\x1e\x8f\xcb\xf7\xef\xdf\x8f\x0f\x0c\x0c\xdc\xfa\xf9\xe7\x9f\xfbc\
\xb1\xd8D6\x9b\x8d+\x8a\x12g\x8c\xc5UU\xe5\xc0\x8d\xcf)\xee\x85\xc5\x100z@2\
\x827<\x9d\x82 \xb8x%\x848\x04A\x90\x04A\x90\x00\xd8\x08!\x14\x00r\x83\xa7\
\x19ci\xc6XR\xd3\xb4)\xc6X\x821\x96d\x8c%L\x80\x1b\xbd\xc0Cha\x0bY\xee\x03\
\x85\x10\xc20=\x99\xb2&\x95\x83\x9a\x02\x10\xe7\xc0\x05A\xb0\xe6\xc8\x0b\xf8\
\xed/T\x851\x96\x06\x90\xc9\xf5\xe75\x99\x03\x9b\x00\xf0 \x0f\xb8Z(\xf6uC\
\x17\xbb\x11\xcb\x85\x14\xc9\x91\xb6b\xda+<\xb4\x1c\x98\x9e#\xf6\\\x9b\x98#\
\xc0\xefp\xb8\x112\x98\x0e\t9\x07\x92\x83\xe5\x80\xb3\xc8-\\se\x9eE\x11\xc8#\
\x93\xff\x8f\xbc`\xf24\xdeer\x12\xbc\x1ae\xdaB\x00?\x12\x02\xffO\xe5?\x93\
\xfd\xf42\x9f\xb7t\x01\x00\x00\x00\x00IEND\xaeB`\x82\xf2\xe0\x11j'
