# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/

# Embedded icon is designed by Igor Kekeljevic (http://www.admiror-ns.co.yu).

from core import models
from core.translation import _t

class Action(models.Action):
    label       = _t('Convert Mode')
    author      = 'Stani'
    email       = 'spe.stani.be@gmail.com'
    version     = '0.1'
    tags        = [_t('colours')]
    __doc__     = _t('Convert the color mode of an image')
    
    def interface(self,fields):
        fields[_t('Mode')]  = self.ImageModeField(
                                    _(self.IMAGE_MODES[3]))
        
    def apply(self,photo,setting,cache):
        #get info
        info        = photo.get_info()
        #get file values
        mode        = self.get_field('Mode',info)
        photo.convert(mode)
        return photo
    
    def apply_pil(self,image):
        return image.convert(self.get_field('Mode',{}))
    
    icon = \
'x\xda\x01B\x0c\xbd\xf3\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\
\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\x08\
\x08|\x08d\x88\x00\x00\x0b\xf9IDATh\x81\xd5\x99{l\\\xd5\x9d\xc7?\xe7>\xe7\
\xce\xcbv\xfc\x92_\xe4Eh\t4\x8e\xb4\r}@\xa4\xb6\xbc\xdaD\x80X*\x93\x90\xd2\
\x86\x92*\xa0\xd5\xb6]\x95\x95\xd0\xaa\xe0E-\xd2\xf6\x91\xddn\x11\xa5\x82 \
\xa5\x08-\x81t[\x9cW\x97\xb0\x90&[\'M\x1c7\x1bC&\xb6\x89\x13O2\x9e\xf1\xd83~\
\xcc\xd8\x1e{\x1e\xf7\xee\x1f\xf7\x8e=v\x1cb;F\xab\xfe\xa4\x9f\xceHs\xcf9\
\xdf\xef\xef\xf7=\xbfs\xce\xbd\xc2\xb2,\xfe\x9aM\xfa\xff\x06p\xbd\xf6WO@\xf9\
$\x07\xaf\xda\xb5\xfbK9h\x94\xc8}\xb7w\xeb\x96\x0f>\x899\xc4\'\xb1\x06\xc4s\
\xcfI\xcbW\xde\xf2l\xda4\x7f\x981M\x19\x18\x17\xf0\xdd\xde\xad\x9b^Y\xf4\xb9\
\x16\x9b@\xe5\xce7*k\x8b<{\x12\x99\xcc\xfaD:3c6\xde0s\xee\xed\xfd\xdf\xbe?\
\xb9X\xf3-\xea\x1a\xa8y\xed\xcd\xbb\xd6U\x97\x9f\x9d0\xcd+\xc1\x03Xl\x96\xa4\
\xb1\xd6\x8a]\xff\xb1v\xb1\xe6\\\x94\x0c\x88={\xe4Oe\xe4\x1f\xddYW\xfdts$*"c\
\xa9ku\x99\xc0\x12\xff\x10}\xec\xe1\x97\xae{\xee\xeb%P\xfe\xfa\xebU7{K\x7f\
\xff\xb5\x1bj>\xf7VW7\xe1\xd1\xb1\xb9O\x0e{2jn[|\xcb\x96\xc4B\xe7\xbf.\x02\
\x95\xbfy\xf3\x9e{j\xab\xde\xfc\\ey\xf1\xce@\'s\x88\xfcl\xd6e\n\xf3\xe1\xfeo\
=\xd2\xba\x90\xce\x0b" \xf6\xec\x91\xabS\xd6\x8f\xb6~\xea\xc6\xa7+\x0c\x97x\
\xe5\\\'\xfd\xa9\xf1y\x8d\xa1J\x12\xb2\x10\xe4,\x8b\xaci\xa6M\xac\xa7\xfa\
\xb6n~a\xbeX\xe6\xbf\x88\x05\xb5_8\x96\xfd\xd9*\xbf\xf7)C\x91\xc5\x8b\x1f\
\xb6\xcf\x19\xbc*I\xf85\x95\n\xc3E\xa5\xdb\xa0\xda\xe3f\x99\xcfK\x95\xc7\xad\
\x91\xcb\xfd\xc4\xff\xfc\xbf<\xd6\xd0\xd0 \xcf\x0b\xce\xbc2 \xd8\x80\xcakcd\
\xdc\r\x9b~g\xfc\xf9\x8e\x14\xb2\xe6\xbaf7\xb7\xa28.\xe3Rd\\\xb2<\x99\x81\
\x9e\xd11.\xf4G1C\xdd\xdc\xd1\xd9\x11R\xd2\xe9\x0bB\x88\xcdMMM\xe1\xc5# P\
\xf0\xf3S4\xbeO\x0c\x01`\t\xf8\xf9\x17\x8f\xf1\xfcCg\xd0KJf\xed\xe6Q\x15<\
\x8a\x82WU\'\t\x18\x8a\x82&K\xe4L\x8b\xd3\xf18\x97\xc2\x97)\xed\xee\xe2\x8b\
\x83\x83\xa4\x86\x87\xf3]\xfbM\xd3|t\xff\xfe\xfd\xef\\?\x01\xc1\r\xdc\xc8\
\xef\xc8\xf17\\\xbc\xf2\xef\xe3u!\x1e\xddr\x90\xe1U\x1e$\xc9\xce\xbe.\xcb\
\xf8T\x15\xaf\xaaL\xb6\x1eU\xc5\xa3(\x18\x8aL\x7fj\x9c#\xa1\x10\xf1p\x90[.t\
\xb1NU\t\x87\xaf\x08\xb8\x05\xfc$\x99L>s\xf8\xf0\xe1\xec\xc2\x08(\xdc\xcf\
\x9d\xbcN\x0f>\xce^\xfd\xb1\x01#\xc5c\x7f\xbb\x8f\xa3w\x8cP\xe2\xf3S\xa4i\
\x93\xe0}\xaa\x8aO\xb3[\x8f\xa2p:6@s\xf0"\xd6\xe5\x8b|\xb9/\xca\xa7\xcb\xcb\
\t\x04\x02W\x1f\x1c\x9a\xb3\xd9\xec\xa6\x83\x07\x0f\x86\xe6N@\xa0R\xca\x0e\
\x1e\xe1\xef9\x02\xb4}\xdc\xf8S\xf6\xaf_8\xce\x8f\x1f:\xcd\ru5\xd4y=x\'\xa3\
\xaf\x903-\x8e\x84{9\x1f\xea\xa6\xac\xbb\x8b\x87\\.\x96\xf8\xfd\xb4\xb4\xb4\
\xcce\xe8\xb8\x10\xe2[MMM\x07\xaeM@\xb0\x8c\xd5\xbc\xcdw\xa8g\x17pfn\xe0\xf3\
v\xb2\xa6\x87o|\xe3\x00\xca\x9aR\xea\xcb\xcbp+\n\xf1\xf1qNFz\x19\xe8\xe9\xe6\
\xd6\xee\x0b<\xfe\xd9\xcf\x92H$hnn\x9e\xcf\xd0\x96\x10\xe2\xe7\x89D\xe2\x9f\
\n%5\x9d\x80\xe0A\xee\xe55\xbe\x8e\x97\x7f\x07>\x9c\x1fxg\x0c\x86\xf4q\x1e\
\x7fp\x1f\xc7\xbf\x92\xa2\xb2\xa8\x98\x0b}\xbd\x88P7w\x84{\xf8\xfe\xa3\x8f\
\xd2\xda\xda:_\xf0\x85v\x1c\xd8\xb4w\xef\xdeK\xd3\x08\x0c\x8a\xc1\x9d%_/y\
\x9c\xf5\xc0\x8b@\xe7<\x86\xd4\x01\xc3iu\x9b\x04\txa\xd9\x9f\xf8A\xc31\xaaB\
\x97\xb8+\x93a\xdb\xd6\xad\xbc\xff\xfe\xfb\x9c8qb^\x88\x85\x10H\x92\xbdeY\
\x96\x85i\x9a\x83B\x88\xadMMM{\'7\xb2\xdd\xec~8~ \x0e?\x9e#x\x19\xf0\x03\xd5\
@\x9d\xe3\xb5@\x15\xe0\x86\xd8H\x0c\xa5\xeb$\xdf\xbc\xe1\x10\x9e?\x1e`\xcd\
\xea\xd5\xbc\xf3\xce;s\x06/\x84@Q\x14\\.\x17\x86a\xe0v\xbb\xf1z\xbd\xf8|>\
\x80\x92\xd6\xd6\xd6\x97\xc0\xc9\x80\x10B4\xd28\xa8\xa1\x15md#\xf5\xd4_}d\
\x15\xf09\xee\x05<\x8e\xeb\xd8\xf7\xbbN8\xf3\xd1\x19\xfe\xf4\xe9\x9d\xdc\xf6\
\x8b\x83\x18\xd5A.]\x82\xc6F\x03\x9fo\x1d^\xaf\xf7c\x81K\x92\x84\xa2(\x93.\
\xcb2\xb2,#I\x12\xd9l\x96`0\xc8\x89\x13\'H\xa5R=@]\x9e\x80\xdcHc\\ \x8a\x00\
\xd6\xb2\x96\rl@E-\x18\x19(r\xa2\xee\x9fA\xc2\rd!\xf3\xc7\x0c\x07#\x07In\xda\
\xc9\xba\x1f^$c\xb5OvO\xa7a\xc7\x0e8wn\r\xb5\xb5\xb5W\x05\xae\xaa\xea\xb46\
\x0f~tt\x94S\xa7N\x11\x08\x04pd\xdf\x0b\xd4\x08\x07\x9a\xd2Hc\xbf@\xf8\xf3\
\x03\x96SN\x03\r\x94Qf\x03,\x9a\xc5\xf3D"\x10\xdf\x17\xe7\xb7\xd2.V<\xbf\x9b\
U\xf7/ad\xe4\xbdY#|\xe8\x90\xc5\xcb/W\xb1re=\xb2,#\x84\x98\x06z&\x01!\x04\
\xe1p\x98\xa3G\x8f\x12\x8dF\x91e\x19M\xd3\x90$)6::Z#\x9c\xc4\xbb\x1ai\x0c\
\x0b\x84o\xbaZT6\xb2\x91z\x7f=,\x05\x8a\x1d\xd0y\x02\x1e\xe0\xcfp\xa6\xf9\
\x0c\xcd\xab_\xe1\xf6\x97Z)[q\x0b\x83\x83\xbb>V&\xa1\x10<\xfb\xac\x0b\xaf\
\xf76\xca\xca\xca&\xc1j\x9a6IBUUr\xb9\x1cmmm\x1c;v\x8cL&\x83a\x18\x93\xcfX\
\x965\xd4\xd7\xd7W+\x03\x1a\xe0^\xcf\xfaG$\xa4i\x87\x1a\x13\x93v\xda\x19\x9e\
\x18fej%r\x8dl\x93p\x01)\xc8\xec\xcd\xb0?\xb0\x9f\xd0\x96\x9fr\xcf\xab.\xfc\
\x15730p\xedK\x96\xdf\x0f\x1b6d\t\x04\x82tthTTT\xa0\xeb\xfa$\x11EQH$\x12\x1c\
9r\x84\x96\x96\x164M\xc3\xe7\xf3\xe1\xf5z\xf1z\xbd\x18\x86\x81,\xcb\xe3CCC/\
\xca\xd8\xcb\xcf\x1b"t|)KW\xbbpU\xcf\x9c\xb0\x97^\xda\xd3\xed,\xebY\x86\xc7\
\xf0\xc00\xc4\xfe;\xc6\x1b\xb9\x97\xa9\xdc\xf1\x02_z\xfaI\x10c\xc4b?\xbb&\
\xf8\xbc\xc92\xdc~;\xf8\xfd\xbd\xec\xdd\x1b\xa3\xb4\xb4\x1a\xc30\xb0,\x8bp8\
\xcc\xa1C\x87\x08\x85B\xf8|>\xfc~\xff$\x01\xb7\xdb\x8d\xaa\xaa\xb1d2\xf9T2\
\x99\x0c\nlQ,\xc1.\x84\xcb\x1f\xe0\x81\xcd\xf5\xd4\xdf#!]qW\xc8K\n\x01\xc7n}\
\x99\xcf\xbfp\x98\xd5\x9f\x7f\x9b\xc1\xc1W\x89\xc5v\xcc\x19\xfc\x94\t\x00\
\xc2a\x8bg\x9e\xd1))YO*\x95\xe2\xe4\xc9\x93X\x965\x19q\x8f\xc7\x83a\x18\xe8\
\xbaN*\x95\xea\xec\xe8\xe8\xd8166\xf6!\xd0SH\xa0\x06X\x06,\xbd\x99\x9b\xd7\
\xdc\xc7}\x1b\xdd\xb8g\xadyKn\x0fp\xe7\xaf\xff\x87\x95\xab\xde\'\x1e\xff\x15\
\x03\x03\xbf\x9a;d\xa1 \x84\x1bI2\x10\xc2\x85\x10*\x96\x95a|<\xcc\xf7\xbe\
\x97\xe6\xe8Q\x0b\x97\xcb5Y\xf3\x0bdcF"\x91\xe3\x81@`?\x10\x04.\x02a\x05\xc8\
\x01i`\x14\x18\x06\x06\xcfq\xae3D(\xd9@\xc3\xddu\xd4-\x9d\t"\xe3Jp\xeel/&\
\xf7\x02=s\x02.I\xde\x027\x10BG\x08\r0\x19\x19\xe9\xe0|\xfb\x04^\xb7\x85\xae\
\xbb\xf0\xf9|\xd3\\\xd3\xb4\xd1@ \xf0_\x91H\xe4C`\xd0\xc19\x06\xa4e\xec2*\n\
\x1c\x804\xe9\xdciN\x07ut\xb3\x86\x9a\x1a\x81\x98\xfcO_\x11B\xba\xf1<\xfd\
\xd1a\xdc\x1e\x81\xee\x12\\\xcd$\xc9\x8f\xa2\x94\xa3(\x15N[\x86\xa2\x94!\xcb\
K\xb0\xac\x0c}\xd1S\x9cm\x1bfl\x0c\x82A\x9dp\xefT\xd4\xbd^/\xd9l\xf6RKK\xcbo\
\x87\x86\x86\xce\x03Q \xe2\xb4\x03\xc0h\xfe\xfei9\x99\xc8\x01\xd9\x82\xdfV\
\x17]\xb1^z#+XQ\xa7\xa1\xe9y\x02\xc6-\xe71s0\x10\xb3@\x08\xbc\xbeB\x8av\xc4\
\xa7@W\xa0(\x15\xa8j%\x8aR\x8e,\x9721\xf1\x11\x9d\xed\xcd\\8?\x81i\x82,+D"\
\x1e.\xf7x\xf0x<\xb8\xdd\xee\\,\x16;\xde\xd6\xd6\xf6\x87l6\x1bq\x80\x87\xb17\
\xb0\x18\x90\x04RW#\x90q\xda,`\xc5\x89\xa7>\xe0\x83\x0bu\xd4\x95\x16QT\x92\'\
\x90\xb7\xe4\xb0E2\tE%\xc2)\x83\xa5\xc8r>\xday\x02\x95(J%\x92\xe4a`\xe0\x00\
\xff\xfb\x973\x0c\r\x98\xc82H2\xa8\xaaAo\xd4Cw\xd0@Q\x94D0\x18l\n\x87\xc3\
\xad@\x9f\x03\xbc\xa7\x00|\x02H\x01\x19\xc5\xb2,K\x08\x91sH\xe4\x89d\xb0\xd7\
\xc5x\xde\x93$\xd3\xaf\xf2j\xd3\xdd\xdc}\xdbg\\\xddKK\xecE?\x8d\xc4\xd939V\
\xde$QZ\xe6qdR\x8c,\x17#I\xc5\xc8\xb2\x9fl6\xca\xa5\xe0[\\8\x9f\xc4\xb2\xc0e\
\x80\x90\xf2\xba\x1d\xc7\xf0\xf8\xc6\xd2\xe9t\xa4\xbb\xbb\xfb\x0f\xb9\\.\n\
\xf4;r\xe9\x03\xe2\x8e\xf6G\x1dlY\xc0T\x00\x1c\x12\xa6\x03\xdc\x02L\xe7\x814\
0Q\xe8\xef\xf2\xee\xb1\xa1(\xb1\x9b\xd2ThZ\xe1a\t2i\xe88\x9b\xa1\xba\xb6\x9b\
\xa5+\x14T\xb5\x06!t\xc0bd\xe40\x1f\xb5\x9f$\x1e\xcf\xa1(\xa0\xaa\xa0\xa8 I`\
Y\x90\xcd\xe4\xcc`w\xf4\xe4\xe5\xcb\xd6I\x07l\xd4\xf1~G\xefI\'\xea\xe9\xbc\
\xbc-\xcb\xb2\xae\xb8\x91\t!$\xec\x85\xadb\xef\xb9>\xa0\x04(\x03*\x80J\xa0l\
\xf92\xea\x9e\xd8\xc6\x86\xf2r\xca\x98\xc5\xfcE\x82\x9bVW\xe2\xf3\xd5\x93H\
\xb4\xd1y\xae\x97t\xdaB\xd7Aw\x81\xcbe\x93\x10\x02\x86\x86\x18\xdf\xf1o\x1c<\
z\x94s\x05Q\x8f:r\x19\x04F\x1c%d\x81\x9cU\x00z\xd6;\xb1\x10b\xf2\x90\x87\xbd\
S{\xb0O?\xa5\x05$\xcau\x9d\xd2\xed\xdb\xf8\xf2\xda5\xac\x99\x8d\x84\xac@U\
\x8dD\xb4\xd7\xd6\xba\xee\x02\xb7\x1b<^0\\\xa0\xeb\xd0\xd1At\xfb\x13\xfc\xe7\
\xc0\xe0\xa4T\n\xc1\'\x98!\x19k\x06\xe0\xab\xbe\x95pH\x08\xec\xab\x8b\x86}&\
\xf5aozy\x12\x15@\xf1W\xef\xe5\xd6\x07\xef\xe3nUE\xcf\xf7\xb7,[\x8b\x92\x0c\
\x9afG\xdc\xe3\x05\xaf\x0f\x8a\x8b\xc10\xb0\x9a\xde\xe6\xf4\x0f\xfe\x91w\x81\
!\x07|\xaf\xd3\x0e0\xb5P\xa7I\xe6\n\x9c\xd7z/4\x8b\xa4\xbc\xd8\x92*/ \xb1d\
\xf9r\xaa\x9e\xfc\x0e\xf7\x95\x95R\x99\'\x80\xb0e\xa2\xbb\xc0p\xdb\xe0K\x8aA\
\x92H\xff\xf3s\xec\xfb\xfd\xdb\x04\xb0%\x92\x8f|^\xef#\x0e\xf8+$3o\x02\x0e\
\x89\xd9$U\xcc\xd4\xba\xa8\x00Ju\x9d\x92\'\xb6\xf1\x955\x9fam>\xfa\xaa\n\x86\
\x01\x1e\x0fx\xfd\x10\t\x13\xde\xfe${\x06\x07\x89c/\xd6>\xc7\xfb\xb1\xab\xcc\
\x08v\xc1\x98U2\x0b"P@b\xa6\xa4\x8a\xb0%\x95\xcfF\x19P\xbc\xe1k\xd4\xdf\xbf\
\x91\xbb\\.4\xd5\x91\x8f\xa6\x93{\xef=N\xfc\xe2\x97\x1cq\x80\xc6\x98\x8az\
\x1c[2cL\xe9}V\xc9,\x98@\x01\x91BI\x19\\)\xa9r`\xc9\xaaU\xd4\xfd\xddv\x1e(\
\xaf\xa0d|\x9c\xe4K\xbff\xdf\xa9\xbf\xd0\xc5\x94d\xf2Q\x1f\xc4.\x91\xe3\xd8e\
<gY\x969g<\x0b\xfa>0]R.\xa6\xaaT\xa1\xa4\x96\x18\x06%\x9b\x1ff\xdd\xee\xb7h\
\x19\x1bc\x88)\xc9\xf4cg`\x08\xbb\xcaL8\xe0\xaf)\x99E!P@"\x7f%\xd5\xb0\xb3Q\
\xc4T6\xca\xb0\x8f\xea\x1a\xb6,\x12\x0e\xe8\x18SUf\xde\x92\x99i\x0b\xfe\xd0\
\xedLf\t!\xb2\xd8;w\xfe,\x95?\x82$\xb1\xcb\xae\x8a\x1d\xdd\x11\xa6\x8e\xc2\
\xf9\x8d)\x8d\x1d\xf59Kf\xd1\x08\xe4\xcd\xb2,S\x08\x91?G\xe5\x8f \x13\xd8\
\xd20\xb0\x17}\x0e\xbb,\x8e2U\xdb\x17$\x99\x99\xb6h\x1f\xbagT)\xb5\xc0%lb\
\x99\x02\xbf\xea\xc64\xefy\x17\xfbK}\xc1\x02\xcf\xbb`*;&\x8b\x10\xf5B\xfb?S\
\x84\x089\xa2\x01e\xfc\x00\x00\x00\x00IEND\xaeB`\x82\xc2\xb0\xfc\xcf'
