/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-2000 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    bhor0533@lehr.chem.TU-Berlin.DE
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifndef PFTP_DEFINES_H
#define PFTP_DEFINES_H
#define VERSION               "1.1.6"
#define VERSION_LENGTH        5
#define MAXCLIENTHOSTS        255 /* maximum number of accepted clients (for `-c') */
#define MAXCLIENTS            255 /* maximum number of simultanously connected clients */
#define HUNAME                32768
#define LONAME                1024 /* LONAME must be smaller than HUNAME! */
#define SONAME                256 /* SONAME must be smaller than LONAME! */
#define BUFSIZE               32768
#define BIG_BUFSIZE           65536
#define PFTP_MAX_PFM_ENTRY    32767
#define DEFAULT_GIGABIT_STRSZ 65000
#define DEFAULT_GIGABIT_NETSZ 128000
#define DEFAULT_STRING_SIZE   32768
#define DEFAULT_STDIN_BUFSIZ  4096
#define DEFAULT_STDOUT_BUFSIZ 32768
#define DIRNAMELEN            512
#define DIR_NAME_VEC_LEN      65536
#ifdef HAVE_INET6
#define DEFAULT_UDP_SIZE      1024 /* maximum size to avoid fragmentation */
#else
#define DEFAULT_UDP_SIZE      1472 /* maximum size to avoid fragmentation */
#endif
#define DEFAULT_BANDWIDTH_INC 64
#define DEFAULT_BANDWIDTH_DEC 64
#define DEFAULT_THROW_AWAY    256
#define PFTP_DEFAULT_PRIORITY 4
#define _PFTP_TIMEOUT         27
#define MAXIMUM_UPLOAD_LIMIT  4096
#define PFTP_NEW_DATA_MSG     "You have new data.\n"
#define IPv4_BIN_ADDR_LENGTH  4
#define IPv6_BIN_ADDR_LENGTH  16

#if defined HAVE_STRERROR
#define _PFTP_ERROR_ARRAY_     strerror(errno)
#define _PFTP_ERROR_ARRAY_PID_ strerror(pid)
#else
#define _PFTP_ERROR_ARRAY_     "error"
#define _PFTP_ERROR_ARRAY_PID_ "error"
#endif
#if defined Linux
#define HAVE_FASYNC
#endif
#if defined __CYGWIN__
#define __RH_CYGLINT__       /* Building the cygwin version of pftp */
#define __HOMEDIR_ENV__      "USERPROFILE"
#define _WINROWS_            25
#define _WINCOLS_            79
#else
#define __HOMEDIR_ENV__      "HOME"
#endif

#if defined ULTRIX
#define ssize_t int
#endif

#define INETD_PORT           662 /* pftp's officially assigned system port number */
#define BIT_ONE              0x1
#define BIT_TWO              0x2
#define PFTPRESOURCE         "/.pftprc" /* user's pftp resource file */
#define PFTPSYSTEMRC         "/etc/pftp.conf"
#define DEFAULT_MENU_UPDATE  2 /* update pfm's main menu every 2 seconds */
#define PFTP_SPECIAL_SIGN    '@'
#define PFTP_LOCK_FILE       "._pftp_lock_file"

/* some signal handling parameters */
#define SET_SIG_SERVER       0x1
#define SET_SIG_CLIENT       0x2
#define SET_SIG_SIGIO        0x4
#define SET_SIG_ALARM        0x8
#define SET_SIGNALS          0x10
#define SET_CLIENT_HANDLER   0x20
#define SET_SERVER_HANDLER   0x40
#define DFL_SIGNAL           0x80
#define IGN_SIGNAL           0x100

/* link script definitions */
#define PFTPMAKELINKS        "PFTP_MAKE_LINKS"
#define PFTPLINKSCRIPTINIT   "#!/bin/sh\n"
#define PFTPSCRIPTINITLEN    10
#define PFTPLINKPROG         "ln -s %s %s\n"

/* definitions for the pfm */
#define DATECOLUMN      4
#define USERCOLUMN      15
#define DATESTRING(num) ((*(pmain+num))+DATECOLUMN)
#define USERSTRING(num) ((*(pmain+num))+USERCOLUMN)
#define PFTP_INFO_FILE  "._pftp_info_file"

/* definitions for option errors */
#define PFTP_OPT_UNKNOWN_OPT   -1    /* unknown option */
#define PFTP_OPT_USELESS        0    /* option is useless within the context */
#define PFTP_OPT_LIST           1    /* `-l' is incompatible with stdin */
#define PFTP_OPT_RECURS_STDIN   2    /* `-r' is incompatible with stdin */
#define PFTP_OPT_NO_HOST        3    /* no host name specified */
#define PFTP_OPT_STDIN_FILES    4    /* send either files or data from stdin */
#define PFTP_OPT_RENAME         5    /* `-R' can only be used with `-T' or server */
#define PFTP_OPT_DAEMON_UDP     6    /* the daemon accepts no udp datagrams */
#define PFTP_OPT_OVERWRT_SKIP   7    /* either overwrite or skip existing files */
#define PFTP_OPT_PFTPCLIENTS    8    /* `PFTPCLIENTS' is unset or empty */
#define PFTP_OPT_NO_FILES       9    /* no files specified on command line */
#define PFTP_OPT_LIST_OR_NUM   10    /* either use `-l' or `-NUM' */
#define PFTP_OPT_GIGA_UDP      11    /* `-G' is incompatible with `-u' */
#define PFTP_OPT_FILTER_UDP    12    /* cannot use filters for UDP */
#define PFTP_OPT_NO_DIR        13    /* no directory name given with `-D' */
#define PFTP_OPT_PRIORITY      14    /* Probably Linux only priority setting */

/* 53 definitions of return statuses */
#define PFTP_NO_ERR          0x00 /* no error occured */
#define PFTP_ALLOCATION_ERR  0x01 /* memory allocation error */
#define PFTP_IOCTL_TTY_ERR   0x02 /* cannot get or set tty modes */
#define PFTP_OPEN_RC_ERR     0x03 /* cannot open pftp resource file */
#define PFTP_FGET_STDIN_ERR  0x04 /* cannot get characters from stdin */
#define PFTP_PRINTLIST_ERR   0x05 /* no host list found in variable */
#define PFTP_MCLOPTION_ERR   0x06 /* misused command line option */
#define PFTP_UUSER_ERR       0x07 /* cannot resolve user name */
#define PFTP_CHDIR_ERR       0x08 /* cannot change directory */
#define PFTP_FILE_OPEN_ERR   0x09 /* unable to open the file */
#define PFTP_WRITETODISK_ERR 0x0a /* cannot write to disk */
#define PFTP_FILTER_ERR      0x0b /* filter variable is not set */
#define PFTP_NETBUF_ERR      0x0c /* netbuf variable is not set */
#define PFTP_BANDWIDTH_ERR   0x0d /* bandwidth variable is not set */
#define PFTP_HOSTNAME_ERR    0x0e /* no host name specified */
#define PFTP_PORT_ERR        0x0f /* missing or illegal a port number */
#define PFTP_FORK_ERR        0x10 /* cannot create a new child process */
#define PFTP_NO_ROOT         0x11 /* missing root privileges */
#define PFTP_INVHOST_ERR     0x12 /* invalid host name specified */
#define PFTP_CONNECTION_ERR  0x13 /* connection was refused by remote host */
#define PFTP_NO_DAEMON_ERR   0x14 /* no daemon is running on remote host */
#define PFTP_NO_SERVER_ERR   0x15 /* no server is running on remote host */
#define PFTP_WRITETONET_ERR  0x16 /* cannot write to net */
#define PFTP_NO_ANSWER_ERR   0x17 /* missing COME ON from remote host */
#define PFTP_REMOTE_ERR      0x18 /* remote host broke connection */
#define PFTP_FILE_SEEK_ERR   0x19 /* error seeking position in file */
#define PFTP_SETSOCKOPT_ERR  0x1a /* setsockopt error occured */
#define PFTP_OPEN_LOG_ERR    0x1b /* cannot open log file */
#define PFTP_LISTEN_ERR      0x1c /* a listen error occured */
#define PFTP_ACCEPT_ERR      0x1d /* an accept error occured */
#define PFTP_INPUT_ERR       0x1e /* wrong input from stdin */
#define PFTP_PROG_ERR        0x1f /* cannot execute external program */
#define PFTP_PIPE_ERR        0x20 /* cannot open pipe to program */
#define PFTP_ENVIRON_ERR     0x21 /* insufficient space in the environment */
#define PFTP_NO_TTY_ERR      0x22 /* cannot write to tty */
#define PFTP_SIGNALMASK_ERR  0x23 /* error setting the signal mask */
#define PFTP_SIGACTION_ERR   0x24 /* error performing signal action */
#define PFTP_RES_HOST_ERR    0x25 /* error resolving remote host name */
#define PFTP_UHOST_ERR       0x26 /* unknown host name */
#define PFTP_SOCKET_ERR      0x27 /* cannot create socket */
#define PFTP_MULTICAST_ERR   0x28 /* cannot join multicast group */
#define PFTP_INTERFACE_ERR   0x29 /* cannot use interface */
#define PFTP_BIND_ERR        0x2a /* cannot bind name to socket */
#define PFTP_RECEIVE_ERR     0x2b /* error receiving data */
#define PFTP_OUTPUT_ERR      0x2c /* cannot write to stdout */
#define PFTP_READ_DISK_ERR   0x2d /* cannot read open file */
#define PFTP_DIR_OPEN_ERR    0x2e /* unable to open the directory */
#define PFTP_UPLOADDIR_ERR   0x2f /* upload directory variable is not set */
#define PFTP_PFM_ERR         0x30 /* there's another pfm running */
#define PFTP_NEW_DATA        0x31 /* there's new data in the upload directory */
#define PFTP_RESPONSE_ERR    0x32 /* the server doesn't respond after sending */
#define PFTP_TIMEOUT_ERR     0x33 /* connection timed out */

/* OOB message texts and text length */
#define PFTP_ROOT_DENIED      "ERRO ** root access denied\n"
#define PFTP_ROOT_DENIED_LEN  27
#define PFTP_LOGIN_ERR        "ERRO ** Login incorrect\n"
#define PFTP_LOGIN_ERR_LEN    24
#define PFTP_DATA_DENIED      "ERRO ** User accepts no files\n"
#define PFTP_DATA_DENIED_LEN  30
#define PFTP_USER_DENIED      "ERRO ** User access denied\n"
#define PFTP_USER_DENIED_LEN  27
#define PFTP_NOSPACELEFT      "ERRO ** No space left\n"
#define PFTP_NOSPACELEFT_LEN  22
#define PFTP_WRONG_FILTER     "ERRO ** Filter not found in list\n"
#define PFTP_WRONG_FILTER_LEN 33
#define PFTP_WRONG_PROT       "ERRO ** Wrong protocol\n"
#define PFTP_WRONG_PROT_LEN   23
#define PFTP_SENDING_ERR       "ERRO ** Sending failed\n"
#define PFTP_SENDING_ERR_LEN   23

extern const char *pftp_alloc_error_str;
#define MEM_CHECK(ALLOC_MEM) \
        if (!ALLOC_MEM) { \
           fprintf(stderr, pftp_alloc_error_str); \
           exit(PFTP_ALLOCATION_ERR); \
        }
#endif
