#include <string.h>

#include "mex_utils.h"
#include "array2d.h"


mxArray *mxCreateLogicalScalar( bool val )
{
  mxArray *array = mxCreateNumericMatrix( 1, 1, mxDOUBLE_CLASS, mxREAL );
  double *df_ptr = (double*)mxGetData( array );
  *df_ptr = val;
  return array;
}


mxArray *create_mex_double( double val )
{
  mxArray *array = mxCreateNumericMatrix( 1, 1, mxDOUBLE_CLASS, mxREAL );
  double *df_ptr = (double*)mxGetData( array );
  *df_ptr = val;
  return array;
}

mxArray *create_mex_string( const char *str )
{
	char *buf = (char*)mxCalloc( strlen( str )+1, sizeof(char) );
	strcpy( buf, str );
	return mxCreateString( buf );
}

char *get_mex_string( const mxArray *arg )
{ 
  /* Input must be a string. */
  if (mxIsChar(arg) != 1)
    mexErrMsgTxt("Input must be a string.");

  /* Input must be a row vector. */
  if (mxGetM(arg) != 1)
    mexErrMsgTxt("Input must be a row vector.");
    
  /* Get the length of the input string. */
  int buflen = (mxGetM(arg) * mxGetN(arg)) + 1;

  /* Allocate memory for input and output strings. */
  char *str = (char*)mxCalloc(buflen, sizeof(char));
  
  /* Copy the string data from prhs[0] into a C string 
   * input_buf. */
  int status = mxGetString(arg, str, buflen);

  if (status != 0) 
	mexWarnMsgTxt("Not enough space. String is truncated.");
 
  return str;
}

double get_mex_double( const mxArray *arg )
{
	double *data = mxGetPr( arg );   
	return data[0];
}

float get_mex_float( const mxArray *arg )
{
	float* data = (float*)mxGetPr( arg );   
	return data[0];
}


int set_mex_field( mxArray *arg, const char *field_name, mxArray *value )
{ 
	int fnum = mxGetFieldNumber( arg, field_name );
	if( fnum == -1 ) {
		fnum = mxAddField( arg, field_name );
	}
	mxSetFieldByNumber( arg, 0, fnum, value );

	return fnum;
}

bool is_mex_scalar( const mxArray *arg )
{
  if( arg == NULL ) return false;
  return mxIsNumeric( arg ) && mxGetN( arg ) == 1 && mxGetM( arg ) == 1;
}

bool is_mex_fid( const mxArray *arg )
{
  if( arg == NULL ) return false;
  return mxIsNumeric( arg ) && (mxGetN( arg ) == 1 || mxGetN( arg ) == 2) && mxGetM( arg ) == 1;
}

void copy_mex_to_pfsarray( const mxArray *arg, pfs::Array2D *array )
{
	assert( array->getCols() == mxGetN( arg ) && array->getRows() == mxGetM( arg ) );
	const double *data = mxGetPr( arg );
	for( int c = 0; c < array->getCols(); c++ ) 
		for( int r = 0; r < array->getRows(); r++ ) {
			(*array)(c,r) = (float)*(data++);
        }		
}

void copy_mex_to_pfsarray( const mxArray *arg, pfs::Array2D *d1, pfs::Array2D *d2, pfs::Array2D *d3 )
{
	assert( d1->getCols() == mxGetN( arg ) && d1->getRows() == mxGetM( arg ) );
	double *o1 = mxGetPr( arg );
	const long sdsize = d1->getCols()*d1->getRows();
	double *o2 = o1 + sdsize;
	double *o3 = o2 + sdsize;
	for( int c = 0; c < d1->getCols(); c++ ) 
		for( int r = 0; r < d1->getRows(); r++ ) {
			(*d1)(c,r) = (float)*(o1++);
			(*d2)(c,r) = (float)*(o2++);
			(*d3)(c,r) = (float)*(o3++);
        }		
}

void copy_pfsarray_to_mex( const pfs::Array2D *array, mxArray *arg )
{
	assert( array->getCols() == mxGetN( arg ) && array->getRows() == mxGetM( arg ) );
	double *data = mxGetPr( arg );
	for( int c = 0; c < array->getCols(); c++ ) 
		for( int r = 0; r < array->getRows(); r++ ) {
			*(data++) = (*array)(c,r);
        }		
}

void copy_pfsarray_to_mex( const pfs::Array2D *d1, const pfs::Array2D *d2, const pfs::Array2D *d3, mxArray *arg )
{
	assert( d1->getCols() == mxGetN( arg ) && d1->getRows() == mxGetM( arg ) );
	double *o1 = mxGetPr( arg );
	const long sdsize = d1->getCols()*d1->getRows();
	double *o2 = o1 + sdsize;
	double *o3 = o2 + sdsize;
	for( int c = 0; c < d1->getCols(); c++ ) 
		for( int r = 0; r < d1->getRows(); r++ ) {
			*(o1++) = (*d1)(c,r);
			*(o2++) = (*d2)(c,r);
			*(o3++) = (*d3)(c,r);
        }		
}
