/**
 * @brief 
 * 
 * This file is a part of PFSTOOLS package.
 * ---------------------------------------------------------------------- 
 * Copyright (C) 2003,2004 Rafal Mantiuk and Grzegorz Krawczyk
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ---------------------------------------------------------------------- 
 * 
 * @author Rafal Mantiuk, <mantiuk@mpi-sb.mpg.de>
 *
 * $Id: ppmio.h,v 1.2 2007/01/23 13:02:18 gkrawczyk Exp $
 */

#ifndef PPMIO_H
#define PPMIO_H

#include <stdio.h>
#include <array2d.h>

struct PPMData;

class PPMReader 
{
    FILE *fh;
    int width, height;
    PPMData *data;
public:
    PPMReader( FILE *fh );    
    ~PPMReader();

    int getWidth() const 
        {
            return width;
        }
    int getHeight() const
        {
            return height;
        }

    void readImage( pfs::Array2D *X, pfs::Array2D *Y, pfs::Array2D *Z );

    bool is8bitdata();
    
};

class PPMWriter
{
    FILE *fh;
public:
    PPMWriter( FILE *fh ) : fh(fh)
        {
        }
    
    void writeImage( pfs::Array2D *X, pfs::Array2D *Y, pfs::Array2D *Z );
    
};



#endif
