
use strict;
use xm::o;
use xm::sub;
use pfe::exportlist;

my $filehash = &xm::o::argv_filehash($pfe::exportlist::DESC);
my $list = &pfe::exportlist::from_filehash($filehash,$o{ext});

my $n;
my @notunique;
for $n (sort keys %$list)
{
    push @notunique, $n if $n =~ m/,/;

    print "<ITEMEXPORT>\n",
    "  <FILENAME>",$$list{$n}{"file"},"</FILENAME>\n",
    "  <CSTRWORDREF>",$$list{$n}{"CSTRWORDREF"},"</CSTRWORDREF>\n",
    "  <LINKWORDREF>",$$list{$n}{"LINKWORDREF"},"</LINKWORDREF>\n",
    "  <NAMEEXPORT>",$n,"</NAMEEXPORT>\n",
    "</ITEMEXPORT>\n";
} 

for $n (@notunique)
{
    print "not-unique:\t",$n,"\n";
}

