/* $Id: meshimpl.h,v 1.12 2000/10/17 13:48:54 knepley Exp $ */
/*
  This file includes the definition of structures used in PETSc for 
  meshes. This should not be included in users' code.
*/

#ifndef __MESH_MOVEMENT_IMPL_H
#define __MESH_MOVEMENT_IMPL_H

#include "petscsles.h"
#include "gvec.h"

struct _MeshMoverOps {
      /* Generic Operations */
  int (*setup)(MeshMover),
      (*setfromoptions)(MeshMover),
      (*destroy)(MeshMover),
      /* Mesh-Specific Operations */
      (*movemesh)(MeshMover, double),
      (*updatenodevalues)(MeshMover, Vec, Vec, Vec),
      (*reform)(Mesh, PetscTruth, PointFunction, PetscTruth, Mesh *);
};

struct _MeshMover {
  PETSCHEADER(struct _MeshMoverOps)
  Mesh            mesh;                            /*          The Mesh */
  MeshSolveMethod meshVelocityMethod;              /*          Method used to solve for mesh velocities */
  Grid            meshVelocityGrid;                /*          Representation of the mesh velocity */
  Vec             nodeVelocities;                  /* [dN]:    The velocities of each node */
  Vec             nodeVelocitiesGhost;             /* [dN]:    The velocities of each interior and ghost node (for coarsening) */
  GMat            meshVelocityMat;                 /* [dNxdN]: The matrix which determines the new node velocities */
  GVec            meshVelocityRhs;                 /* [dN]:    The rhs which determines the new node velocities */
  GVec            meshVelocitySol;                 /* [dN]:    The solution which determines the new node velocities */
  SLES            meshVelocitySles;                /*          Solver for the mesh velocity */
  MeshSolveMethod meshAccelerationMethod;          /*          Method used to solve for mesh accelerations */
  Grid            meshAccelerationGrid;            /*          Representation of the mesh acceleration */
  Vec             nodeAccelerations;               /* [dN]:    The accelerations of each node */
  Vec             nodeAccelerationsGhost;          /* [dN]:    The accelerations of each interior and ghost node (for coarsening) */
  GMat            meshAccelerationMat;             /* [dNxdN]: The matrix which determines the new node accelerations */
  GVec            meshAccelerationRhs;             /* [dN]:    The rhs which determines the new node accelerations */
  GVec            meshAccelerationSol;             /* [dN]:    The solution which determines the new node accelerations */
  SLES            meshAccelerationSles;            /*          Solver for the mesh acceleration */
  VecScatter      meshVelocityScatter;             /*          The map from nodeVels/Acc to the ghost vector */
  PetscViewer     movingMeshViewer;                /*          Viewer for visualizing mesh changes */
  char           *movingMeshViewerCaption;         /*          Caption for moving mesh viewer (helps get time step in there) */
  PetscObject     movingMeshCtx;                   /*          User context for mesh movement */
};

#endif /* __MESH_MOVEMENT_IMPL_H */
