/* gvec.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void *);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void *);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "petscfix.h"
#include "gvec.h"
#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecviewfromoptions_ PGVECVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecviewfromoptions_ pgvecviewfromoptions
#else
#define gvecviewfromoptions_ pgvecviewfromoptions_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecviewfromoptions_ GVECVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecviewfromoptions_ gvecviewfromoptions
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecview_ PGVECVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecview_ pgvecview
#else
#define gvecview_ pgvecview_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecview_ GVECVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecview_ gvecview
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecserialize_ PGVECSERIALIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecserialize_ pgvecserialize
#else
#define gvecserialize_ pgvecserialize_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecserialize_ GVECSERIALIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecserialize_ gvecserialize
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecgetgrid_ PGVECGETGRID
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecgetgrid_ pgvecgetgrid
#else
#define gvecgetgrid_ pgvecgetgrid_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecgetgrid_ GVECGETGRID
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecgetgrid_ gvecgetgrid
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecgetorder_ PGVECGETORDER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecgetorder_ pgvecgetorder
#else
#define gvecgetorder_ pgvecgetorder_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecgetorder_ GVECGETORDER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecgetorder_ gvecgetorder
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecgetlocalworkgvec_ PGVECGETLOCALWORKGVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecgetlocalworkgvec_ pgvecgetlocalworkgvec
#else
#define gvecgetlocalworkgvec_ pgvecgetlocalworkgvec_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecgetlocalworkgvec_ GVECGETLOCALWORKGVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecgetlocalworkgvec_ gvecgetlocalworkgvec
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecrestorelocalworkgvec_ PGVECRESTORELOCALWORKGVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecrestorelocalworkgvec_ pgvecrestorelocalworkgvec
#else
#define gvecrestorelocalworkgvec_ pgvecrestorelocalworkgvec_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecrestorelocalworkgvec_ GVECRESTORELOCALWORKGVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecrestorelocalworkgvec_ gvecrestorelocalworkgvec
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecgetworkgvec_ PGVECGETWORKGVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecgetworkgvec_ pgvecgetworkgvec
#else
#define gvecgetworkgvec_ pgvecgetworkgvec_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecgetworkgvec_ GVECGETWORKGVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecgetworkgvec_ gvecgetworkgvec
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecrestoreworkgvec_ PGVECRESTOREWORKGVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecrestoreworkgvec_ pgvecrestoreworkgvec
#else
#define gvecrestoreworkgvec_ pgvecrestoreworkgvec_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecrestoreworkgvec_ GVECRESTOREWORKGVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecrestoreworkgvec_ gvecrestoreworkgvec
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecglobaltolocal_ PGVECGLOBALTOLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecglobaltolocal_ pgvecglobaltolocal
#else
#define gvecglobaltolocal_ pgvecglobaltolocal_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecglobaltolocal_ GVECGLOBALTOLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecglobaltolocal_ gvecglobaltolocal
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gveclocaltoglobal_ PGVECLOCALTOGLOBAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gveclocaltoglobal_ pgveclocaltoglobal
#else
#define gveclocaltoglobal_ pgveclocaltoglobal_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gveclocaltoglobal_ GVECLOCALTOGLOBAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gveclocaltoglobal_ gveclocaltoglobal
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecevaluatefunction_ PGVECEVALUATEFUNCTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecevaluatefunction_ pgvecevaluatefunction
#else
#define gvecevaluatefunction_ pgvecevaluatefunction_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecevaluatefunction_ GVECEVALUATEFUNCTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecevaluatefunction_ gvecevaluatefunction
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecevaluatefunctioncollective_ PGVECEVALUATEFUNCTIONCOLLECTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecevaluatefunctioncollective_ pgvecevaluatefunctioncollective
#else
#define gvecevaluatefunctioncollective_ pgvecevaluatefunctioncollective_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecevaluatefunctioncollective_ GVECEVALUATEFUNCTIONCOLLECTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecevaluatefunctioncollective_ gvecevaluatefunctioncollective
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecevaluatefunctionrectangular_ PGVECEVALUATEFUNCTIONRECTANGULAR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecevaluatefunctionrectangular_ pgvecevaluatefunctionrectangular
#else
#define gvecevaluatefunctionrectangular_ pgvecevaluatefunctionrectangular_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecevaluatefunctionrectangular_ GVECEVALUATEFUNCTIONRECTANGULAR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecevaluatefunctionrectangular_ gvecevaluatefunctionrectangular
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecevaluatefunctiongalerkin_ PGVECEVALUATEFUNCTIONGALERKIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecevaluatefunctiongalerkin_ pgvecevaluatefunctiongalerkin
#else
#define gvecevaluatefunctiongalerkin_ pgvecevaluatefunctiongalerkin_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecevaluatefunctiongalerkin_ GVECEVALUATEFUNCTIONGALERKIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecevaluatefunctiongalerkin_ gvecevaluatefunctiongalerkin
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecevaluatefunctiongalerkincollective_ PGVECEVALUATEFUNCTIONGALERKINCOLLECTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecevaluatefunctiongalerkincollective_ pgvecevaluatefunctiongalerkincollective
#else
#define gvecevaluatefunctiongalerkincollective_ pgvecevaluatefunctiongalerkincollective_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecevaluatefunctiongalerkincollective_ GVECEVALUATEFUNCTIONGALERKINCOLLECTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecevaluatefunctiongalerkincollective_ gvecevaluatefunctiongalerkincollective
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecevaluateboundaryfunctiongalerkin_ PGVECEVALUATEBOUNDARYFUNCTIONGALERKIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecevaluateboundaryfunctiongalerkin_ pgvecevaluateboundaryfunctiongalerkin
#else
#define gvecevaluateboundaryfunctiongalerkin_ pgvecevaluateboundaryfunctiongalerkin_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecevaluateboundaryfunctiongalerkin_ GVECEVALUATEBOUNDARYFUNCTIONGALERKIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecevaluateboundaryfunctiongalerkin_ gvecevaluateboundaryfunctiongalerkin
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecevaluateboundaryfunctiongalerkincollective_ PGVECEVALUATEBOUNDARYFUNCTIONGALERKINCOLLECTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecevaluateboundaryfunctiongalerkincollective_ pgvecevaluateboundaryfunctiongalerkincollective
#else
#define gvecevaluateboundaryfunctiongalerkincollective_ pgvecevaluateboundaryfunctiongalerkincollective_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecevaluateboundaryfunctiongalerkincollective_ GVECEVALUATEBOUNDARYFUNCTIONGALERKINCOLLECTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecevaluateboundaryfunctiongalerkincollective_ gvecevaluateboundaryfunctiongalerkincollective
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecevaluatenonlinearoperatorgalerkin_ PGVECEVALUATENONLINEAROPERATORGALERKIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecevaluatenonlinearoperatorgalerkin_ pgvecevaluatenonlinearoperatorgalerkin
#else
#define gvecevaluatenonlinearoperatorgalerkin_ pgvecevaluatenonlinearoperatorgalerkin_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecevaluatenonlinearoperatorgalerkin_ GVECEVALUATENONLINEAROPERATORGALERKIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecevaluatenonlinearoperatorgalerkin_ gvecevaluatenonlinearoperatorgalerkin
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecevaluateoperatorgalerkin_ PGVECEVALUATEOPERATORGALERKIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecevaluateoperatorgalerkin_ pgvecevaluateoperatorgalerkin
#else
#define gvecevaluateoperatorgalerkin_ pgvecevaluateoperatorgalerkin_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecevaluateoperatorgalerkin_ GVECEVALUATEOPERATORGALERKIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecevaluateoperatorgalerkin_ gvecevaluateoperatorgalerkin
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecevaluateoperatorgalerkinrectangular_ PGVECEVALUATEOPERATORGALERKINRECTANGULAR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecevaluateoperatorgalerkinrectangular_ pgvecevaluateoperatorgalerkinrectangular
#else
#define gvecevaluateoperatorgalerkinrectangular_ pgvecevaluateoperatorgalerkinrectangular_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecevaluateoperatorgalerkinrectangular_ GVECEVALUATEOPERATORGALERKINRECTANGULAR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecevaluateoperatorgalerkinrectangular_ gvecevaluateoperatorgalerkinrectangular
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecevaluatejacobian_ PGVECEVALUATEJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecevaluatejacobian_ pgvecevaluatejacobian
#else
#define gvecevaluatejacobian_ pgvecevaluatejacobian_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecevaluatejacobian_ GVECEVALUATEJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecevaluatejacobian_ gvecevaluatejacobian
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecevaluatejacobiandiagonal_ PGVECEVALUATEJACOBIANDIAGONAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecevaluatejacobiandiagonal_ pgvecevaluatejacobiandiagonal
#else
#define gvecevaluatejacobiandiagonal_ pgvecevaluatejacobiandiagonal_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecevaluatejacobiandiagonal_ GVECEVALUATEJACOBIANDIAGONAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecevaluatejacobiandiagonal_ gvecevaluatejacobiandiagonal
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecevaluatejacobianconstrained_ PGVECEVALUATEJACOBIANCONSTRAINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecevaluatejacobianconstrained_ pgvecevaluatejacobianconstrained
#else
#define gvecevaluatejacobianconstrained_ pgvecevaluatejacobianconstrained_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecevaluatejacobianconstrained_ GVECEVALUATEJACOBIANCONSTRAINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecevaluatejacobianconstrained_ gvecevaluatejacobianconstrained
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecsolvejacobianconstrained_ PGVECSOLVEJACOBIANCONSTRAINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecsolvejacobianconstrained_ pgvecsolvejacobianconstrained
#else
#define gvecsolvejacobianconstrained_ pgvecsolvejacobianconstrained_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecsolvejacobianconstrained_ GVECSOLVEJACOBIANCONSTRAINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecsolvejacobianconstrained_ gvecsolvejacobianconstrained
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecsetboundary_ PGVECSETBOUNDARY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecsetboundary_ pgvecsetboundary
#else
#define gvecsetboundary_ pgvecsetboundary_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecsetboundary_ GVECSETBOUNDARY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecsetboundary_ gvecsetboundary
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecsetboundaryzero_ PGVECSETBOUNDARYZERO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecsetboundaryzero_ pgvecsetboundaryzero
#else
#define gvecsetboundaryzero_ pgvecsetboundaryzero_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecsetboundaryzero_ GVECSETBOUNDARYZERO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecsetboundaryzero_ gvecsetboundaryzero
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecsetboundarydifference_ PGVECSETBOUNDARYDIFFERENCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecsetboundarydifference_ pgvecsetboundarydifference
#else
#define gvecsetboundarydifference_ pgvecsetboundarydifference_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecsetboundarydifference_ GVECSETBOUNDARYDIFFERENCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecsetboundarydifference_ gvecsetboundarydifference
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecinterpolatefield_ PGVECINTERPOLATEFIELD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecinterpolatefield_ pgvecinterpolatefield
#else
#define gvecinterpolatefield_ pgvecinterpolatefield_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gvecinterpolatefield_ GVECINTERPOLATEFIELD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gvecinterpolatefield_ gvecinterpolatefield
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gveccreate_ PGVECCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gveccreate_ pgveccreate
#else
#define gveccreate_ pgveccreate_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gveccreate_ GVECCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gveccreate_ gveccreate
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gveccreateghost_ PGVECCREATEGHOST
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gveccreateghost_ pgveccreateghost
#else
#define gveccreateghost_ pgveccreateghost_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gveccreateghost_ GVECCREATEGHOST
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gveccreateghost_ gveccreateghost
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gveccreaterectangular_ PGVECCREATERECTANGULAR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gveccreaterectangular_ pgveccreaterectangular
#else
#define gveccreaterectangular_ pgveccreaterectangular_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gveccreaterectangular_ GVECCREATERECTANGULAR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gveccreaterectangular_ gveccreaterectangular
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gveccreaterectangularghost_ PGVECCREATERECTANGULARGHOST
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gveccreaterectangularghost_ pgveccreaterectangularghost
#else
#define gveccreaterectangularghost_ pgveccreaterectangularghost_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gveccreaterectangularghost_ GVECCREATERECTANGULARGHOST
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gveccreaterectangularghost_ gveccreaterectangularghost
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gveccreateconstrained_ PGVECCREATECONSTRAINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gveccreateconstrained_ pgveccreateconstrained
#else
#define gveccreateconstrained_ pgveccreateconstrained_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gveccreateconstrained_ GVECCREATECONSTRAINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gveccreateconstrained_ gveccreateconstrained
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gveccreateboundaryrestriction_ PGVECCREATEBOUNDARYRESTRICTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gveccreateboundaryrestriction_ pgveccreateboundaryrestriction
#else
#define gveccreateboundaryrestriction_ pgveccreateboundaryrestriction_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gveccreateboundaryrestriction_ GVECCREATEBOUNDARYRESTRICTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gveccreateboundaryrestriction_ gveccreateboundaryrestriction
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pointfunctioninterpolatefield_ PPOINTFUNCTIONINTERPOLATEFIELD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pointfunctioninterpolatefield_ ppointfunctioninterpolatefield
#else
#define pointfunctioninterpolatefield_ ppointfunctioninterpolatefield_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pointfunctioninterpolatefield_ POINTFUNCTIONINTERPOLATEFIELD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pointfunctioninterpolatefield_ pointfunctioninterpolatefield
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pointfunctioninterpolatefieldbatch_ PPOINTFUNCTIONINTERPOLATEFIELDBATCH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pointfunctioninterpolatefieldbatch_ ppointfunctioninterpolatefieldbatch
#else
#define pointfunctioninterpolatefieldbatch_ ppointfunctioninterpolatefieldbatch_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pointfunctioninterpolatefieldbatch_ POINTFUNCTIONINTERPOLATEFIELDBATCH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pointfunctioninterpolatefieldbatch_ pointfunctioninterpolatefieldbatch
#endif
#endif



/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL gvecviewfromoptions_(GVec gvec,char *title, int *ierr ){
*ierr = GVecViewFromOptions(
	(GVec)PetscToPointer( (gvec) ),title);
}
void PETSC_STDCALL gvecview_(GVec v,PetscViewer *viewer, int *ierr ){
*ierr = GVecView(
	(GVec)PetscToPointer( (v) ),*viewer);
}
void PETSC_STDCALL gvecserialize_(Grid grid,GVec *v,PetscViewer *viewer,PetscTruth *store, int *ierr ){
*ierr = GVecSerialize(
	(Grid)PetscToPointer( (grid) ),v,*viewer,*store);
}
void PETSC_STDCALL gvecgetgrid_(GVec v,Grid *grid, int *ierr ){
*ierr = GVecGetGrid(
	(GVec)PetscToPointer( (v) ),grid);
}
void PETSC_STDCALL gvecgetorder_(GVec v,VarOrdering *order, int *ierr ){
*ierr = GVecGetOrder(
	(GVec)PetscToPointer( (v) ),order);
}
void PETSC_STDCALL gvecgetlocalworkgvec_(GVec v,GVec *lv, int *ierr ){
*ierr = GVecGetLocalWorkGVec(
	(GVec)PetscToPointer( (v) ),lv);
}
void PETSC_STDCALL gvecrestorelocalworkgvec_(GVec v,GVec *lv, int *ierr ){
*ierr = GVecRestoreLocalWorkGVec(
	(GVec)PetscToPointer( (v) ),lv);
}
void PETSC_STDCALL gvecgetworkgvec_(GVec v,GVec *wv, int *ierr ){
*ierr = GVecGetWorkGVec(
	(GVec)PetscToPointer( (v) ),wv);
}
void PETSC_STDCALL gvecrestoreworkgvec_(GVec v,GVec *wv, int *ierr ){
*ierr = GVecRestoreWorkGVec(
	(GVec)PetscToPointer( (v) ),wv);
}
void PETSC_STDCALL gvecglobaltolocal_(GVec v,InsertMode *mode,GVec lv, int *ierr ){
*ierr = GVecGlobalToLocal(
	(GVec)PetscToPointer( (v) ),*mode,
	(GVec)PetscToPointer( (lv) ));
}
void PETSC_STDCALL gveclocaltoglobal_(GVec v,InsertMode *mode,GVec lv, int *ierr ){
*ierr = GVecLocalToGlobal(
	(GVec)PetscToPointer( (v) ),*mode,
	(GVec)PetscToPointer( (lv) ));
}
void PETSC_STDCALL gvecevaluatefunction_(GVec v,int *numFields,int *fields,PointFunction *f,PetscScalar *alpha,void*ctx, int *ierr ){
*ierr = GVecEvaluateFunction(
	(GVec)PetscToPointer( (v) ),*numFields,fields,*f,*alpha,ctx);
}
void PETSC_STDCALL gvecevaluatefunctioncollective_(GVec v,int *numFields,int *fields,PointFunction *f,PetscScalar *alpha,void*ctx, int *ierr ){
*ierr = GVecEvaluateFunctionCollective(
	(GVec)PetscToPointer( (v) ),*numFields,fields,*f,*alpha,ctx);
}
void PETSC_STDCALL gvecevaluatefunctionrectangular_(GVec v,VarOrdering order,PointFunction *f,PetscScalar *alpha,void*ctx, int *ierr ){
*ierr = GVecEvaluateFunctionRectangular(
	(GVec)PetscToPointer( (v) ),
	(VarOrdering)PetscToPointer( (order) ),*f,*alpha,ctx);
}
void PETSC_STDCALL gvecevaluatefunctiongalerkin_(GVec v,int *numFields,int *fields,PointFunction *f,PetscScalar *alpha,void*ctx, int *ierr ){
*ierr = GVecEvaluateFunctionGalerkin(
	(GVec)PetscToPointer( (v) ),*numFields,fields,*f,*alpha,ctx);
}
void PETSC_STDCALL gvecevaluatefunctiongalerkincollective_(GVec v,int *numFields,int *fields,PointFunction *f,PetscScalar *alpha,void*ctx, int *ierr ){
*ierr = GVecEvaluateFunctionGalerkinCollective(
	(GVec)PetscToPointer( (v) ),*numFields,fields,*f,*alpha,ctx);
}
void PETSC_STDCALL gvecevaluateboundaryfunctiongalerkin_(GVec v,int *numFields,int *fields,PointFunction *f,PetscScalar *alpha,void*ctx, int *ierr ){
*ierr = GVecEvaluateBoundaryFunctionGalerkin(
	(GVec)PetscToPointer( (v) ),*numFields,fields,*f,*alpha,ctx);
}
void PETSC_STDCALL gvecevaluateboundaryfunctiongalerkincollective_(GVec v,int *numFields,int *fields,PointFunction *f,PetscScalar *alpha,void*ctx, int *ierr ){
*ierr = GVecEvaluateBoundaryFunctionGalerkinCollective(
	(GVec)PetscToPointer( (v) ),*numFields,fields,*f,*alpha,ctx);
}
void PETSC_STDCALL gvecevaluatenonlinearoperatorgalerkin_(GVec v,int *n,GVec vecs[],int *numFields,int *fields,NonlinearOperator *op,
                                          PetscScalar *alpha,PetscTruth *isALE,void*ctx, int *ierr ){
*ierr = GVecEvaluateNonlinearOperatorGalerkin(
	(GVec)PetscToPointer( (v) ),*n,vecs,*numFields,fields,*op,*alpha,*isALE,ctx);
}
void PETSC_STDCALL gvecevaluateoperatorgalerkin_(GVec v,GVec x,GVec y,int *sField,int *tField,int *op,PetscScalar *alpha,void*ctx, int *ierr ){
*ierr = GVecEvaluateOperatorGalerkin(
	(GVec)PetscToPointer( (v) ),
	(GVec)PetscToPointer( (x) ),
	(GVec)PetscToPointer( (y) ),*sField,*tField,*op,*alpha,ctx);
}
void PETSC_STDCALL gvecevaluateoperatorgalerkinrectangular_(GVec v,GVec x,VarOrdering sOrder,LocalVarOrdering *sLocOrder,
                                            VarOrdering tOrder,LocalVarOrdering *tLocOrder,int *op,PetscScalar *alpha,
                                            void*ctx, int *ierr ){
*ierr = GVecEvaluateOperatorGalerkinRectangular(
	(GVec)PetscToPointer( (v) ),
	(GVec)PetscToPointer( (x) ),
	(VarOrdering)PetscToPointer( (sOrder) ),*sLocOrder,
	(VarOrdering)PetscToPointer( (tOrder) ),*tLocOrder,*op,*alpha,ctx);
}
void PETSC_STDCALL gvecevaluatejacobian_(GVec v,GVec x,GVec y,void*ctx, int *ierr ){
*ierr = GVecEvaluateJacobian(
	(GVec)PetscToPointer( (v) ),
	(GVec)PetscToPointer( (x) ),
	(GVec)PetscToPointer( (y) ),ctx);
}
void PETSC_STDCALL gvecevaluatejacobiandiagonal_(GVec d,GVec x,void*ctx, int *ierr ){
*ierr = GVecEvaluateJacobianDiagonal(
	(GVec)PetscToPointer( (d) ),
	(GVec)PetscToPointer( (x) ),ctx);
}
void PETSC_STDCALL gvecevaluatejacobianconstrained_(GVec v,GVec x, int *ierr ){
*ierr = GVecEvaluateJacobianConstrained(
	(GVec)PetscToPointer( (v) ),
	(GVec)PetscToPointer( (x) ));
}
void PETSC_STDCALL gvecsolvejacobianconstrained_(GVec v,GVec x, int *ierr ){
*ierr = GVecSolveJacobianConstrained(
	(GVec)PetscToPointer( (v) ),
	(GVec)PetscToPointer( (x) ));
}
void PETSC_STDCALL gvecsetboundary_(GVec v,void*ctx, int *ierr ){
*ierr = GVecSetBoundary(
	(GVec)PetscToPointer( (v) ),ctx);
}
void PETSC_STDCALL gvecsetboundaryzero_(GVec v,void*ctx, int *ierr ){
*ierr = GVecSetBoundaryZero(
	(GVec)PetscToPointer( (v) ),ctx);
}
void PETSC_STDCALL gvecsetboundarydifference_(GVec v,GVec u,void*ctx, int *ierr ){
*ierr = GVecSetBoundaryDifference(
	(GVec)PetscToPointer( (v) ),
	(GVec)PetscToPointer( (u) ),ctx);
}
void PETSC_STDCALL gvecinterpolatefield_(GVec v,int *field,double *x,double *y,double *z,PetscScalar *values,InterpolationContext *ctx, int *ierr ){
*ierr = GVecInterpolateField(
	(GVec)PetscToPointer( (v) ),*field,*x,*y,*z,values,
	(InterpolationContext* )PetscToPointer( (ctx) ));
}
void PETSC_STDCALL gveccreate_(Grid grid,GVec *gvec, int *ierr ){
*ierr = GVecCreate(
	(Grid)PetscToPointer( (grid) ),gvec);
}
void PETSC_STDCALL gveccreateghost_(Grid grid,GVec *gvec, int *ierr ){
*ierr = GVecCreateGhost(
	(Grid)PetscToPointer( (grid) ),gvec);
}
void PETSC_STDCALL gveccreaterectangular_(Grid grid,VarOrdering order,GVec *gvec, int *ierr ){
*ierr = GVecCreateRectangular(
	(Grid)PetscToPointer( (grid) ),
	(VarOrdering)PetscToPointer( (order) ),gvec);
}
void PETSC_STDCALL gveccreaterectangularghost_(Grid grid,VarOrdering order,GVec *gvec, int *ierr ){
*ierr = GVecCreateRectangularGhost(
	(Grid)PetscToPointer( (grid) ),
	(VarOrdering)PetscToPointer( (order) ),gvec);
}
void PETSC_STDCALL gveccreateconstrained_(Grid grid,GVec *gvec, int *ierr ){
*ierr = GVecCreateConstrained(
	(Grid)PetscToPointer( (grid) ),gvec);
}
void PETSC_STDCALL gveccreateboundaryrestriction_(Grid grid,GVec *gvec, int *ierr ){
*ierr = GVecCreateBoundaryRestriction(
	(Grid)PetscToPointer( (grid) ),gvec);
}
void PETSC_STDCALL pointfunctioninterpolatefield_(int *n,int *comp,double *x,double *y,double *z,PetscScalar *values,void*ctx, int *ierr ){
*ierr = PointFunctionInterpolateField(*n,*comp,x,y,z,values,ctx);
}
void PETSC_STDCALL pointfunctioninterpolatefieldbatch_(int *n,int *comp,double *x,double *y,double *z,PetscScalar *values,void*ctx, int *ierr ){
*ierr = PointFunctionInterpolateFieldBatch(*n,*comp,x,y,z,values,ctx);
}
#if defined(__cplusplus)
}
#endif
