/* grid.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void *);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void *);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "petscfix.h"
#include "grid.h"
#include "petscfix.h"
#include "gvec.h"
#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define griddestroy_ PGRIDDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define griddestroy_ pgriddestroy
#else
#define griddestroy_ pgriddestroy_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define griddestroy_ GRIDDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define griddestroy_ griddestroy
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridview_ PGRIDVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridview_ pgridview
#else
#define gridview_ pgridview_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridview_ GRIDVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridview_ gridview
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridsetup_ PGRIDSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridsetup_ pgridsetup
#else
#define gridsetup_ pgridsetup_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridsetup_ GRIDSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridsetup_ gridsetup
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridsetupghostscatter_ PGRIDSETUPGHOSTSCATTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridsetupghostscatter_ pgridsetupghostscatter
#else
#define gridsetupghostscatter_ pgridsetupghostscatter_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridsetupghostscatter_ GRIDSETUPGHOSTSCATTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridsetupghostscatter_ gridsetupghostscatter
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridsetupboundary_ PGRIDSETUPBOUNDARY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridsetupboundary_ pgridsetupboundary
#else
#define gridsetupboundary_ pgridsetupboundary_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridsetupboundary_ GRIDSETUPBOUNDARY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridsetupboundary_ gridsetupboundary
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridgetmesh_ PGRIDGETMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridgetmesh_ pgridgetmesh
#else
#define gridgetmesh_ pgridgetmesh_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridgetmesh_ GRIDGETMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridgetmesh_ gridgetmesh
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridgetclassmap_ PGRIDGETCLASSMAP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridgetclassmap_ pgridgetclassmap
#else
#define gridgetclassmap_ pgridgetclassmap_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridgetclassmap_ GRIDGETCLASSMAP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridgetclassmap_ gridgetclassmap
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridgetorder_ PGRIDGETORDER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridgetorder_ pgridgetorder
#else
#define gridgetorder_ pgridgetorder_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridgetorder_ GRIDGETORDER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridgetorder_ gridgetorder
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridgetlocalorder_ PGRIDGETLOCALORDER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridgetlocalorder_ pgridgetlocalorder
#else
#define gridgetlocalorder_ pgridgetlocalorder_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridgetlocalorder_ GRIDGETLOCALORDER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridgetlocalorder_ gridgetlocalorder
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridgetdiscretization_ PGRIDGETDISCRETIZATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridgetdiscretization_ pgridgetdiscretization
#else
#define gridgetdiscretization_ pgridgetdiscretization_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridgetdiscretization_ GRIDGETDISCRETIZATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridgetdiscretization_ gridgetdiscretization
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridsetfromoptions_ PGRIDSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridsetfromoptions_ pgridsetfromoptions
#else
#define gridsetfromoptions_ pgridsetfromoptions_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridsetfromoptions_ GRIDSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridsetfromoptions_ gridsetfromoptions
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridviewfromoptions_ PGRIDVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridviewfromoptions_ pgridviewfromoptions
#else
#define gridviewfromoptions_ pgridviewfromoptions_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridviewfromoptions_ GRIDVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridviewfromoptions_ gridviewfromoptions
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridprinthelp_ PGRIDPRINTHELP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridprinthelp_ pgridprinthelp
#else
#define gridprinthelp_ pgridprinthelp_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridprinthelp_ GRIDPRINTHELP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridprinthelp_ gridprinthelp
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridgetoptionsprefix_ PGRIDGETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridgetoptionsprefix_ pgridgetoptionsprefix
#else
#define gridgetoptionsprefix_ pgridgetoptionsprefix_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridgetoptionsprefix_ GRIDGETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridgetoptionsprefix_ gridgetoptionsprefix
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridgetnearestnode_ PGRIDGETNEARESTNODE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridgetnearestnode_ pgridgetnearestnode
#else
#define gridgetnearestnode_ pgridgetnearestnode_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridgetnearestnode_ GRIDGETNEARESTNODE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridgetnearestnode_ gridgetnearestnode
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridgetnearestbdnode_ PGRIDGETNEARESTBDNODE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridgetnearestbdnode_ pgridgetnearestbdnode
#else
#define gridgetnearestbdnode_ pgridgetnearestbdnode_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridgetnearestbdnode_ GRIDGETNEARESTBDNODE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridgetnearestbdnode_ gridgetnearestbdnode
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridgetboundarysize_ PGRIDGETBOUNDARYSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridgetboundarysize_ pgridgetboundarysize
#else
#define gridgetboundarysize_ pgridgetboundarysize_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridgetboundarysize_ GRIDGETBOUNDARYSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridgetboundarysize_ gridgetboundarysize
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridgetboundarystart_ PGRIDGETBOUNDARYSTART
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridgetboundarystart_ pgridgetboundarystart
#else
#define gridgetboundarystart_ pgridgetboundarystart_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridgetboundarystart_ GRIDGETBOUNDARYSTART
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridgetboundarystart_ gridgetboundarystart
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridgetboundarynext_ PGRIDGETBOUNDARYNEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridgetboundarynext_ pgridgetboundarynext
#else
#define gridgetboundarynext_ pgridgetboundarynext_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridgetboundarynext_ GRIDGETBOUNDARYNEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridgetboundarynext_ gridgetboundarynext
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridrefinemesh_ PGRIDREFINEMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridrefinemesh_ pgridrefinemesh
#else
#define gridrefinemesh_ pgridrefinemesh_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridrefinemesh_ GRIDREFINEMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridrefinemesh_ gridrefinemesh
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridglobaltolocalgeneral_ PGRIDGLOBALTOLOCALGENERAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridglobaltolocalgeneral_ pgridglobaltolocalgeneral
#else
#define gridglobaltolocalgeneral_ pgridglobaltolocalgeneral_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridglobaltolocalgeneral_ GRIDGLOBALTOLOCALGENERAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridglobaltolocalgeneral_ gridglobaltolocalgeneral
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridglobaltolocal_ PGRIDGLOBALTOLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridglobaltolocal_ pgridglobaltolocal
#else
#define gridglobaltolocal_ pgridglobaltolocal_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridglobaltolocal_ GRIDGLOBALTOLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridglobaltolocal_ gridglobaltolocal
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridlocaltoglobal_ PGRIDLOCALTOGLOBAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridlocaltoglobal_ pgridlocaltoglobal
#else
#define gridlocaltoglobal_ pgridlocaltoglobal_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridlocaltoglobal_ GRIDLOCALTOGLOBAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridlocaltoglobal_ gridlocaltoglobal
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridinterpolateelementvec_ PGRIDINTERPOLATEELEMENTVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridinterpolateelementvec_ pgridinterpolateelementvec
#else
#define gridinterpolateelementvec_ pgridinterpolateelementvec_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridinterpolateelementvec_ GRIDINTERPOLATEELEMENTVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridinterpolateelementvec_ gridinterpolateelementvec
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridcreaterestriction_ PGRIDCREATERESTRICTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridcreaterestriction_ pgridcreaterestriction
#else
#define gridcreaterestriction_ pgridcreaterestriction_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridcreaterestriction_ GRIDCREATERESTRICTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridcreaterestriction_ gridcreaterestriction
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridlocaltoelementgeneral_ PGRIDLOCALTOELEMENTGENERAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridlocaltoelementgeneral_ pgridlocaltoelementgeneral
#else
#define gridlocaltoelementgeneral_ pgridlocaltoelementgeneral_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridlocaltoelementgeneral_ GRIDLOCALTOELEMENTGENERAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridlocaltoelementgeneral_ gridlocaltoelementgeneral
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridlocaltoelement_ PGRIDLOCALTOELEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridlocaltoelement_ pgridlocaltoelement
#else
#define gridlocaltoelement_ pgridlocaltoelement_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridlocaltoelement_ GRIDLOCALTOELEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridlocaltoelement_ gridlocaltoelement
#endif
#endif



/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL griddestroy_(Grid grid, int *ierr ){
*ierr = GridDestroy(
	(Grid)PetscToPointer( (grid) ));
}
void PETSC_STDCALL gridview_(Grid grid,PetscViewer *viewer, int *ierr ){
*ierr = GridView(
	(Grid)PetscToPointer( (grid) ),*viewer);
}
void PETSC_STDCALL gridsetup_(Grid grid, int *ierr ){
*ierr = GridSetUp(
	(Grid)PetscToPointer( (grid) ));
}
void PETSC_STDCALL gridsetupghostscatter_(Grid grid, int *ierr ){
*ierr = GridSetupGhostScatter(
	(Grid)PetscToPointer( (grid) ));
}
void PETSC_STDCALL gridsetupboundary_(Grid grid, int *ierr ){
*ierr = GridSetupBoundary(
	(Grid)PetscToPointer( (grid) ));
}
void PETSC_STDCALL gridgetmesh_(Grid grid,Mesh *mesh, int *ierr ){
*ierr = GridGetMesh(
	(Grid)PetscToPointer( (grid) ),mesh);
}
void PETSC_STDCALL gridgetclassmap_(Grid grid,FieldClassMap *map, int *ierr ){
*ierr = GridGetClassMap(
	(Grid)PetscToPointer( (grid) ),map);
}
void PETSC_STDCALL gridgetorder_(Grid grid,VarOrdering *order, int *ierr ){
*ierr = GridGetOrder(
	(Grid)PetscToPointer( (grid) ),order);
}
void PETSC_STDCALL gridgetlocalorder_(Grid grid,LocalVarOrdering *order, int *ierr ){
*ierr = GridGetLocalOrder(
	(Grid)PetscToPointer( (grid) ),
	(LocalVarOrdering* )PetscToPointer( (order) ));
}
void PETSC_STDCALL gridgetdiscretization_(Grid grid,int *field,Discretization *disc, int *ierr ){
*ierr = GridGetDiscretization(
	(Grid)PetscToPointer( (grid) ),*field,disc);
}
void PETSC_STDCALL gridsetfromoptions_(Grid grid, int *ierr ){
*ierr = GridSetFromOptions(
	(Grid)PetscToPointer( (grid) ));
}
void PETSC_STDCALL gridviewfromoptions_(Grid grid,char *title, int *ierr ){
*ierr = GridViewFromOptions(
	(Grid)PetscToPointer( (grid) ),title);
}
void PETSC_STDCALL gridprinthelp_(Grid grid, int *ierr ){
*ierr = GridPrintHelp(
	(Grid)PetscToPointer( (grid) ));
}
void PETSC_STDCALL gridgetoptionsprefix_(Grid grid,char **prefix, int *ierr ){
*ierr = GridGetOptionsPrefix(
	(Grid)PetscToPointer( (grid) ),prefix);
}
void PETSC_STDCALL gridgetnearestnode_(Grid grid,int *field,double *x,double *y,double *z,int *node, int *ierr ){
*ierr = GridGetNearestNode(
	(Grid)PetscToPointer( (grid) ),*field,*x,*y,*z,node);
}
void PETSC_STDCALL gridgetnearestbdnode_(Grid grid,int *field,double *x,double *y,double *z,int *node, int *ierr ){
*ierr = GridGetNearestBdNode(
	(Grid)PetscToPointer( (grid) ),*field,*x,*y,*z,node);
}
void PETSC_STDCALL gridgetboundarysize_(Grid grid,int *bd,int *field,int *size, int *ierr ){
*ierr = GridGetBoundarySize(
	(Grid)PetscToPointer( (grid) ),*bd,*field,size);
}
void PETSC_STDCALL gridgetboundarystart_(Grid grid,int *bd,int *field,PetscTruth *ghost,int *node,int *nclass, int *ierr ){
*ierr = GridGetBoundaryStart(
	(Grid)PetscToPointer( (grid) ),*bd,*field,*ghost,node,nclass);
}
void PETSC_STDCALL gridgetboundarynext_(Grid grid,int *bd,int *field,PetscTruth *ghost,int *node,int *nclass, int *ierr ){
*ierr = GridGetBoundaryNext(
	(Grid)PetscToPointer( (grid) ),*bd,*field,*ghost,node,nclass);
}
void PETSC_STDCALL gridrefinemesh_(Grid grid,PointFunction *area,Grid *newgrid, int *ierr ){
*ierr = GridRefineMesh(
	(Grid)PetscToPointer( (grid) ),*area,newgrid);
}
void PETSC_STDCALL gridglobaltolocalgeneral_(Grid grid,GVec vec,Vec ghostVec,InsertMode *mode,VecScatter scatter, int *ierr ){
*ierr = GridGlobalToLocalGeneral(
	(Grid)PetscToPointer( (grid) ),
	(GVec)PetscToPointer( (vec) ),
	(Vec)PetscToPointer( (ghostVec) ),*mode,
	(VecScatter)PetscToPointer( (scatter) ));
}
void PETSC_STDCALL gridglobaltolocal_(Grid grid,InsertMode *mode,GVec vec, int *ierr ){
*ierr = GridGlobalToLocal(
	(Grid)PetscToPointer( (grid) ),*mode,
	(GVec)PetscToPointer( (vec) ));
}
void PETSC_STDCALL gridlocaltoglobal_(Grid grid,InsertMode *mode,GVec vec, int *ierr ){
*ierr = GridLocalToGlobal(
	(Grid)PetscToPointer( (grid) ),*mode,
	(GVec)PetscToPointer( (vec) ));
}
void PETSC_STDCALL gridinterpolateelementvec_(Grid grid,int *field,ElementVec vec,Grid newGrid,int *newField,ElementVec newVec, int *ierr ){
*ierr = GridInterpolateElementVec(
	(Grid)PetscToPointer( (grid) ),*field,
	(ElementVec)PetscToPointer( (vec) ),
	(Grid)PetscToPointer( (newGrid) ),*newField,
	(ElementVec)PetscToPointer( (newVec) ));
}
void PETSC_STDCALL gridcreaterestriction_(Grid vf,Grid vc,GMat *gmat, int *ierr ){
*ierr = GridCreateRestriction(
	(Grid)PetscToPointer( (vf) ),
	(Grid)PetscToPointer( (vc) ),gmat);
}
void PETSC_STDCALL gridlocaltoelementgeneral_(Grid grid,Vec ghostVec,Vec reduceVec,PetscTruth *reduceSystem,PetscTruth *reduceElement,ElementVec vec, int *ierr ){
*ierr = GridLocalToElementGeneral(
	(Grid)PetscToPointer( (grid) ),
	(Vec)PetscToPointer( (ghostVec) ),
	(Vec)PetscToPointer( (reduceVec) ),*reduceSystem,*reduceElement,
	(ElementVec)PetscToPointer( (vec) ));
}
void PETSC_STDCALL gridlocaltoelement_(Grid grid,ElementVec vec, int *ierr ){
*ierr = GridLocalToElement(
	(Grid)PetscToPointer( (grid) ),
	(ElementVec)PetscToPointer( (vec) ));
}
#if defined(__cplusplus)
}
#endif
