#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <getopt.h>
#include <signal.h>

#include "npnews.h"

int stop = 0;

void SIGTERM_handler( int signo )
{
   stop = 1;
   return;
}

int main( int argc, char **argv )
{
   signal( SIGTERM, SIGTERM_handler );
   signal( SIGQUIT, SIGTERM_handler );

   NP_News news;

   struct option long_options[] =
   {
      { "type", 1, NULL, 't' },
      { "quantity", 1, NULL, 'q' },
      { 0, 0, NULL, 0 }
   };

   np_news_t transfer_type = NP_HEADERS;
   int quantity = 0;

   for( int i = 0; i < 2; ++i )
   {
      int c = getopt_long( argc, argv, "t:q:", long_options, NULL );
      if ( c < 0 || c == '?' )
      {
         fprintf( stderr, "usage: nptransfer (-t|--type) TYPE)"
                  "((-q|--quantity) QUANTITY\n\n"
                  "TYPE is one of: headers, articles, or requests.\n"
                  "a negative QUANTITY causes all unseen articles to be "
                  "marked as seen.\n"
                  "A QUANTITY of zero corresponds to all unseen messages.\n" );
         return 1;
      }

      if ( c == 't' )
         switch( *optarg )
         {
         case 'h':
            transfer_type = NP_HEADERS;
            break;

         case 'a':
            transfer_type = NP_ARTICLES;
            break;

         case 'r':
            transfer_type = NP_REQUESTS;
            break;

         default:
            fprintf( stderr, "nptransfer: unknown type argument: %s", optarg );
            return 1;
            break;
         }

      if ( c == 'q' )
         quantity = atoi( optarg );
   }

   char old_server[ 1024 ];
   *old_server = '\0';

   for( ; ; )
   {
      char buffer[ 1024 ];

      if ( fgets( buffer, sizeof buffer, stdin ) == NULL )
         break;

      char *server = strtok( buffer, ":" );
      char *group = strtok( NULL, "\n" );

      if ( server == NULL )
      {
         fprintf( stderr, "nptransfer: NULL server passed.\n" );
         printf( "0\n" );
         continue;
      }

      if ( group == NULL )
      {
         fprintf( stderr, "nptransfer: NULL group passed.\n" );
         printf( "0\n" );
         continue;
      }

      if ( !strcasecmp( group, "POSTED" ) ||
           !strcasecmp( group, "SENT-MAIL" ))
         printf( "0\n" );
      else
      {
         if ( strcmp( server, old_server ))
         {
            news.disconnect();
            strcpy( old_server, server );
         }

         if ( news.transfer( server, group, transfer_type, quantity ))
            fprintf( stderr, "nptransfer: %s\n", news.get_error() );

         printf( "%d\n", news.get_transferred() );
      }

      fflush( stderr );
      fflush( stdout );
   }

   news.disconnect();

   return 0;
}
