#include "npconfig.h"

void NP_Config::init_general( GtkWidget *frame )
{
   int result;
   if (( result = general.load() ) == 1 )
      general.print_error();

   // email entry

   GtkWidget *vbox = gtk_vbox_new( FALSE, 10 );
   gtk_widget_show( vbox );
   gtk_container_border_width( GTK_CONTAINER( vbox ), 10 );
   gtk_container_add( GTK_CONTAINER( frame ), vbox );

   GtkWidget *label = gtk_label_new( "Your Email Address:" );
   gtk_widget_show( label );
   gtk_box_pack_start( GTK_BOX( vbox ), label, TRUE, TRUE, 0 );

   GtkWidget *entry = gtk_entry_new_with_max_length( 100 );

   const char *pointer;
   if ( !result )
      if (( pointer = general.get_email() ) == NULL )
         general.print_error();
      else 
         gtk_entry_set_text( GTK_ENTRY( entry ), pointer );
   
   gtk_widget_show( entry );
   gtk_box_pack_start( GTK_BOX( vbox ), entry, TRUE, TRUE, 0 );
   gtk_signal_connect( GTK_OBJECT( entry ), "changed",
                       GTK_SIGNAL_FUNC( email_entry_callback ), this );

   // editor entry

   label = gtk_label_new( "Command to launch external editor:" );
   gtk_widget_show( label );
   gtk_box_pack_start( GTK_BOX( vbox ), label, TRUE, TRUE, 0 );

   entry = gtk_entry_new_with_max_length( 100 );

   if ( !result )
      if (( pointer = general.get_editor() ) == NULL )
         general.print_error();
      else
         gtk_entry_set_text( GTK_ENTRY( entry ), pointer );

   gtk_widget_show( entry );
   gtk_box_pack_start( GTK_BOX( vbox ), entry, TRUE, TRUE, 0 );
   gtk_signal_connect( GTK_OBJECT( entry ), "changed",
                       GTK_SIGNAL_FUNC( editor_entry_callback ), this );

   // browser entry

   label = gtk_label_new( "executable name of your web browser:" );
   gtk_widget_show( label );
   gtk_box_pack_start( GTK_BOX( vbox ), label, TRUE, TRUE, 0 );

   entry = gtk_entry_new_with_max_length( 100 );

   if ( !result )
      if (( pointer = general.get_browser() ) == NULL )
         general.print_error();
      else
         gtk_entry_set_text( GTK_ENTRY( entry ), pointer );

   gtk_widget_show( entry );
   gtk_box_pack_start( GTK_BOX( vbox ), entry, TRUE, TRUE, 0 );
   gtk_signal_connect( GTK_OBJECT( entry ), "changed",
                       GTK_SIGNAL_FUNC( browser_entry_callback ), this );
   
   // expiry scale

   label = gtk_label_new( "Days after which messages expire:" );
   gtk_widget_show( label );
   gtk_box_pack_start( GTK_BOX( vbox ), label, TRUE, TRUE, 0 );

   int i = 0;
   if ( !result )
      if (( i = general.get_expiry() ) < 0 )
         general.print_error();

   GtkAdjustment *adjustment =
      ( GtkAdjustment *)gtk_adjustment_new( ( float )i, 0.0, 28.0, 1.0,
                                            0.0, 0.0 );
   gtk_signal_connect( GTK_OBJECT( adjustment ), "value_changed",
                       GTK_SIGNAL_FUNC( adjustment_callback ), this );

   GtkWidget *scale = gtk_hscale_new( GTK_ADJUSTMENT( adjustment ));
   gtk_widget_show( scale );
   gtk_scale_set_digits( GTK_SCALE( scale ), 0 );
   gtk_range_set_update_policy( GTK_RANGE( scale ), GTK_UPDATE_DELAYED );
   gtk_box_pack_start( GTK_BOX( vbox ), scale, TRUE, TRUE, 0 );

   return;
}
