#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <ctype.h>
#include <errno.h>

#include "npcompose.h"

void NP_Compose::write_message( NP_File& file, int header )
{
   char *buffer2, *pointer, buffer[ 1024 ];
   int len, idx;

   if ( header )
   {
      len = gtk_text_get_length( GTK_TEXT( header_widget ));
      if (( buffer2 = ( char *)malloc( len + 1 )) == NULL )
      {
         perror( "malloc" );
         exit( 1 );
      }

      strcpy( buffer2,
              gtk_editable_get_chars( GTK_EDITABLE( header_widget ),
                                      0, len ));

      char *l = strlen( buffer2 ) + buffer2;

      for( pointer = buffer2; pointer < l; pointer += ++idx )
      {
         while( *pointer == '\n' )
         {
            if ( file.put_string( "\r\n" ))
            {
               show_message( file.get_error() );
               return;
            }

            ++pointer;
         }

         strncpy( buffer, pointer, idx = strcspn( pointer, "\n" ));
         buffer[ idx ] = '\r';
         buffer[ idx + 1 ] = '\n';
         buffer[ idx + 2 ] = '\0';

         if ( file.put_string( buffer ))
         {
            show_message( file.get_error() );
            return;
         }
      }

      free( buffer2 );

      if ( file.put_string( "\r\n" ))
      {
         show_message( file.get_error() );
         return;
      }
   }

   len = gtk_text_get_length( GTK_TEXT( text_widget ));
   if (( buffer2 = ( char *)malloc( len + 1 )) == NULL )
   {
      perror( "malloc" );
      exit( 1 );
   }

   strcpy( buffer2,
           gtk_editable_get_chars( GTK_EDITABLE( text_widget ),
                                   0, len ));

   char *l = buffer2 + strlen( buffer2 );

   for( pointer = buffer2; pointer < l; pointer += idx + 1 )
   {
      while( *pointer == '\n' )
      {
         if ( header )
         {
            if ( file.put_string( "\r\n" ))
            {
               show_message( file.get_error() );
               return;
            }
         }
         else
            if ( file.put_string( "\n" ))
            {
               show_message( file.get_error());
               return;
            }

         ++pointer;
      }

      idx = strcspn( pointer, "\n" );

      if ( idx )
      {
         strncpy( buffer, pointer, idx );

         if ( header )
         {
            buffer[ idx ] = '\r';
            buffer[ idx + 1 ] = '\n';
            buffer[ idx + 2 ] = '\0';
         }
         else
         {
            buffer[ idx ] = '\n';
            buffer[ idx + 1 ] = '\0';
         }
      }
      else
         strcpy( buffer, pointer );

      if ( file.put_string( buffer ))
      {
         show_message( file.get_error() );
         return;
      }
   }

   free( buffer2 );

   if ( header && file.put_string( ".\r\n" ))
      show_message( file.get_error() );
      
   return;
}

void NP_Compose::replace_message()
{
   NP_File spool;
   char spool_path[ 1024 ];
   snprintf( spool_path, sizeof spool_path, "%s/.peruser_spool/%s-%s",
             home, server, group );
   if ( spool.openr( spool_path ))
   {
      show_message( spool.get_error() );
      return;
   }

   NP_File temp;
   char temp_path[ 1024 ];
   snprintf( temp_path, sizeof temp_path, "%s:tmp", spool_path );
   if ( temp.openw( temp_path ))
   {
      show_message( temp.get_error() );
      return;
   }

   if ( spool.seek( offset, SEEK_SET ))
   {
      show_message( spool.get_error() );
      return;
   }

   char *pointer;

   if ( offset )
   {
      do
         if (( pointer = spool.get_string()) == NULL )
            break;
      while( strncmp( pointer, ".\r\n", 3 ));

      while(( pointer = spool.get_string()) != NULL )
         if ( temp.put_string( pointer ))
         {
            show_message( temp.get_error() );
            return;
         }
   }
   
   spool.close();
   truncate( spool_path, offset );

   if ( spool.opena( spool_path ))
   {
      show_message( spool.get_error() );
      return;
   }

   write_message( spool, 1 );

   temp.close();
   if ( temp.openr( temp_path ))
   {
      show_message( temp.get_error() );
      return;
   }

   while(( pointer = temp.get_string()) != NULL )
      if ( spool.put_string( pointer ))
      {
         show_message( spool.get_error() );
         return;
      }

   spool.close();
   temp.close();

   remove( temp_path );

   return;
}

void send_signal( NP_Compose *compose )
{
   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.npcollections:pid",
             compose->home );

   FILE *file;
   if (( file = fopen( buffer, "r" )) != NULL )
   {
      if ( fgets( buffer, sizeof buffer, file ) == NULL )
      {
         fclose( file );
         return;
      }

      fclose( file );

      pid_t pid = atoi( buffer );
      if ( pid )
         if ( kill( pid, SIGUSR1 ))
            perror( "kill" );
   }

   return;
}

void close_button_callback( GtkWidget *widget, gpointer data )
{
   NP_Compose *compose = ( NP_Compose *)data;

   NP_File spool, outbox;

   if ( *compose->type == 'e' )
   {
      compose->replace_message();
      send_signal( compose );
      gtk_main_quit();
      return;
   }

   char spool_path[ 1024 ], outbox_path[ 1024 ];

   snprintf( spool_path, sizeof spool_path, "%s/.peruser_spool/%s-FOLLOW-UPS",
             compose->home, compose->server );
   snprintf( outbox_path, sizeof outbox_path, "%s/.peruser_spool/%s-OUTBOX",
             compose->home, compose->server );
   
   switch( *compose->type )
   {
   case 'b':
   case 'j':
   case 'r':
      if ( outbox.opena( outbox_path ))
      {
         compose->show_message( outbox.get_error());
         return;
      }

   case 'c':
   case 'f':
   case 'o':
   case 's':
      if ( spool.opena( spool_path ))
      {
         compose->show_message( spool.get_error());
         return;
      }
      break;
   }

   switch( *compose->type )
   {
   case 'r':
   case 'j':
      compose->write_message( outbox, 1 );

      if ( *compose->type == 'j' )
      {
         char buffer[ 1024 ];
         char *pointer = compose->server;
         while( *pointer )
            *pointer++ = toupper( *pointer );
         
         snprintf( buffer, sizeof buffer,
                   "The mail message to Jimmy has been\n"
                   "saved in the OUTBOX group of the\n"
                   "%s server tree.\n", compose->server );
         compose->show_message( buffer );

         while( compose->message_window != NULL )
            while( gtk_events_pending() )
               gtk_main_iteration();
      }
      
      break;

   case 'b':
      compose->write_message( outbox, 1 );

   case 'c':
   case 'f':
   case 'o':
   case 's':
      compose->write_message( spool, 1 );
      break;
   }
   
   outbox.close();
   spool.close();

   send_signal( compose );
   gtk_main_quit();

   return;
}
