#include <stdlib.h>
#include <stdio.h>

#include <gtk/gtk.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"
#include "npcollections.h"

void search_button_callback( GtkWidget *widget, gpointer data )
{
   NP_Collections *collections = ( NP_Collections *)data;

   if ( collections->callbacks_disabled )
      return;

   if ( collections->search_shown )
   {
      gdk_window_raise( collections->search_window->window );
      return;
   }

   collections->search_window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
   gtk_window_set_title( GTK_WINDOW( collections->search_window ),
                         "Regular Expression Search" );
   gtk_widget_set_usize( collections->search_window, 500, 400 );

   GtkWidget *frame = gtk_frame_new( NULL );
   gtk_widget_show( frame );
   gtk_container_border_width( GTK_CONTAINER( frame ), 10 );
   gtk_container_add( GTK_CONTAINER( collections->search_window ), frame );

   GtkWidget *table = gtk_table_new( 1, 25, FALSE );
   gtk_widget_show( table );
   gtk_table_set_row_spacings( GTK_TABLE( table ), 10 );
   gtk_container_add( GTK_CONTAINER( frame ), table );
   gtk_container_border_width( GTK_CONTAINER( table ), 10 );

   GtkWidget *label = gtk_label_new( "Regular Expression:" );
   gtk_widget_show( label );
   gtk_table_attach_defaults( GTK_TABLE( table ), label, 0, 1, 0, 1 );

   GtkWidget *hbox = gtk_hbox_new( FALSE, 0 );
   gtk_widget_show( hbox );
   gtk_table_attach_defaults( GTK_TABLE( table ), hbox, 0, 1, 1, 2 );

   GtkWidget *entry = gtk_entry_new_with_max_length( 100 );
   gtk_widget_show( entry );
   gtk_entry_set_text( GTK_ENTRY( entry ), collections->search_text );
   gtk_box_pack_start( GTK_BOX( hbox ), entry, TRUE, TRUE, 0 );
   gtk_signal_connect( GTK_OBJECT( entry ), "changed",
                       GTK_SIGNAL_FUNC( regexp_entry_callback ), data );
   gtk_signal_connect( GTK_OBJECT( entry ), "activate",
                       GTK_SIGNAL_FUNC( execute_search_button_callback ),
                       data );
      
   GtkWidget *button = gtk_button_new_with_label( " Search " );
   gtk_widget_show( button );
   GTK_WIDGET_SET_FLAGS( button, GTK_CAN_DEFAULT );
   gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 10 );
   gtk_signal_connect( GTK_OBJECT( button ), "clicked",
                       GTK_SIGNAL_FUNC( execute_search_button_callback ),
                       data );

   GtkWidget *search_scroll = gtk_scrolled_window_new( NULL, NULL );
   gtk_widget_show( search_scroll );

   static char *titles[] = { "Server", "Newsgroup", "Spool Position",
                             "Line Number", "Matching Text" };
   collections->search_clist = gtk_clist_new_with_titles( 5, titles );
   gtk_widget_show( collections->search_clist );
   gtk_container_add( GTK_CONTAINER( search_scroll ),
                      collections->search_clist );
   gtk_table_attach_defaults( GTK_TABLE( table ), search_scroll,
                              0, 1, 2, 24 );

   gtk_clist_set_column_width( GTK_CLIST( collections->search_clist ),
                               0, 150 );
   gtk_clist_set_column_width( GTK_CLIST( collections->search_clist ),
                               1, 65 );
   gtk_clist_set_column_width( GTK_CLIST( collections->search_clist ),
                               2, 85 );
   gtk_clist_set_column_width( GTK_CLIST( collections->search_clist ),
                               3, 75 );
   gtk_clist_set_column_width( GTK_CLIST( collections->search_clist ),
                               4, 500 );
   gtk_signal_connect( GTK_OBJECT( collections->search_clist ), "select_row",
                       GTK_SIGNAL_FUNC( search_clist_callback ), data );
   hbox = gtk_hbox_new( FALSE, 0 );
   gtk_widget_show( hbox );
   gtk_table_attach_defaults( GTK_TABLE( table ), hbox, 0, 1, 24, 25 );

   collections->search_label = gtk_label_new( "Matches: 0" );
   gtk_widget_show( collections->search_label );
   gtk_box_pack_start( GTK_BOX( hbox ), collections->search_label,
                       FALSE, FALSE, 0 );
   
   button = gtk_button_new_with_label( " Close Window " );
   gtk_widget_show( button );
   GTK_WIDGET_SET_FLAGS( button, GTK_CAN_DEFAULT );
   gtk_box_pack_end( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
   gtk_signal_connect( GTK_OBJECT( button ), "clicked",
                       GTK_SIGNAL_FUNC( close_search_button_callback ), data );

   gtk_widget_show( collections->search_window );
   collections->search_shown = 1;

   return;
}
