#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include "npfile.h"
#include "npgroup.h"

int NP_Group::update()
{
   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.peruser_spool/%s-%s", home, server,
             name );
   if ( file.openr( buffer ))
   {
      if ( errno != ENOENT )
      {
         file.print_error();
         return 1;
      }

      return 0;
   }

   char *line;
   while(( line = file.get_string() ) != NULL )
   {
      if ( *line == '@' )
         ++headers;

      do
         if (( line = file.get_string() ) == NULL )
         {
            file.print_error();
            return 1;
         }
      while( strncmp( line, ".\r\n", 3 ));

      ++total;
   }

   file.close();
   
   char second_buffer[ 1024 ];
   snprintf( second_buffer, sizeof second_buffer, "%s:read", buffer );
   if ( file.openr( second_buffer ))
   {
      if ( errno != ENOENT )
      {
         file.print_error();
         return 1;
      }
   }
   else
   {
      while(( line = file.get_string()) != NULL )
         if ( *line == 'u' )
            ++unseen;

      file.close();
   }
   
   snprintf( second_buffer, sizeof second_buffer, "%s:requests", buffer );
   if ( file.openr( second_buffer ))
   {
      if ( errno != ENOENT )
      {
         file.print_error();
         return 1;
      }
   }
   else
   {
      while(( line = file.get_string()) != NULL )
         ++requested;

      file.close();
   }
   
   return 0;
}
