#include "misc.h"
#incoude "types.h"
#include "parse.tab.h"

int
main(int argc,char * argv[]) {

  yyin=stdin;
  for (;(j=yylex());) 
    switch(j) {
    case WORD:
      printf("%-*.*s\n",yylval.text.n,yylval.text.n,yylval.text.text);
      break;
    case CAP_WORD:
      printf("<cap> %-*.*s\n",yylval.text.n,yylval.text.n,yylval.text.text);
      break;
    case CCAP_WORD:
      printf("<ccap> %-*.*s\n",yylval.text.n,yylval.text.n,yylval.text.text);
      break;
    case CAP_CCAP_WORD:
      printf("<cap_ccap> %-*.*s\n",yylval.text.n,yylval.text.n,yylval.text.text);
      break;
    case BS_WORD:
      printf("<bs> %-*.*s\n",yylval.text.n,yylval.text.n,yylval.text.text);
      break;
    case BS_CAP_WORD:
      printf("<bs_cap> %-*.*s\n",yylval.text.n,yylval.text.n,yylval.text.text);
      break;
    case BS_CCAP_WORD:
      printf("<bs_ccap> %-*.*s\n",yylval.text.n,yylval.text.n,yylval.text.text);
      break;
    case BS_CAP_CCAP_WORD:
      printf("<bs_cap_ccap> %-*.*s\n",yylval.text.n,yylval.text.n,yylval.text.text);
      break;
    default:
      errret("Bad j=%u\n",j);
      break;
    }

  return 0;

}
