/* penguineyes.h - structures/prototypes used in the program */
/*
 *  Penguineyes
 *  Copyright (C) 1998/1999 Neil Howie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_GNOME
#include <gnome.h>
#include <applet-widget.h>
#endif

#define FILE_EXISTS(file) (close(open(file, O_RDONLY)) == 0)

#ifndef PACKAGE
#define PACKAGE "Penguineyes"
#endif
#ifndef VERSION
#define VERSION "0.10"
#endif
#ifndef DATADIR
#define DATADIR "/usr/share/penguineyes"
#endif

typedef struct eyeBall eyeball;

struct coord {
    gint x;
    gint y;
};

struct size {
    gint w;
    gint h;
};

struct defaults {
    struct theme *theme;
    struct coord pos;
    struct size dim;
    guint fps : 6;
    gboolean fhor:1;
    gboolean fver:1;
};

/* eyeball information */
struct eye_temp {
    struct coord rnorm;
    struct coord screen;
    struct size rball;
    struct size rsocket;
    struct coord pos;
    GdkPixmap *pixmap;
    GdkBitmap *mask;
    GdkGC *gc;
};

struct eyeBall {
    struct coord norm;
    struct size socket;
    struct size ball;

    gchar *pfile;

    struct eye_temp *ins;
};

struct hand_settings {
    GdkColor colour;
    double width[2];
    double length;
};

struct clock_settings {
    struct coord pos;
    struct size dim;

    struct coord rpos;
    struct size rdim;

    gboolean smooth;

    struct hand_settings hands[3];
};

enum {
    T_FLAG_EXISTS	= 1 << 0,
    T_FLAG_FLIP_HOR	= 1 << 1,
    T_FLAG_FLIP_VER	= 1 << 2
};

/* the 'theme' */
struct theme {
    gchar *title;
    gchar *filename;
    gchar *say;
    gchar *dir;
    gchar *launch;
    gchar *mask;
    GSList *balls;
    gchar flags;
    gchar ins_flags;
    GdkColor *colour;
    gint width;
    gint height;
    struct clock_settings *clock;
};

extern GSList *theme_list; /* list of themes */

extern struct theme *default_theme;
extern GSList *themeBalls;

extern gchar *defaultLaunch;

extern GdkPixmap *sourcePenguin;
extern GtkWidget *mainWindow;
extern GdkGC *penguineyes_gc;
extern GdkGC *mask_gc;

extern const char *default_config_file;

extern int screen_width;
extern int screen_height;

extern gchar fps;

extern gboolean guilty;

#ifdef HAVE_GNOME
extern gboolean is_gnome_applet;
extern GtkWidget *appletWidget;
#else
gboolean gnome_parse_geometry (const gchar *, gint *, gint *, gint *, gint *);
gchar * gnome_geometry_string (GdkWindow * window);
#endif

void set_theme_auto(struct theme *th);
void set_theme_size(struct theme *th, int w, int h);

void penguin_set_size(int width, int height);

void create_right_click_menu(void);

void update_clock(gboolean force);
void draw_clock(void);

struct theme *get_theme_by_name(gchar *name);

struct defaults read_defaults(void);
void write_defaults(void);

gint draw_eyes(void);
void draw_area(int x, int y, int w, int h);

void getrc(void);

void setColour(GdkGC *gc, int red, int blue, int green);
