/*******************************************
 PDF Chain
 
 Copyright: 2009 Martin Singer
 <http://sourceforge.net/projects/pdfchain/>
 
 Author: Martin Singer
 <m_power3@users.sourceforge.net>
 
 License: GPL version 3+
 <http://www.gnu.org/licenses/>
 
 Tools
 src/dump_data.hh
 *******************************************/

#ifndef PDF_CHAIN__TOOLS_DUMP_DATA
#define PDF_CHAIN__TOOLS_DUMP_DATA

#include "definings.hh"
#include "dialogs.hh"
#include "filechoosers.hh"

/*** Class ***/
class class_window_tools_dump_data : public Gtk::Window{
	
	public:
		class_window_tools_dump_data();
		virtual ~class_window_tools_dump_data(){}; // Destruktor (inline)
		
		// Routines
		void set_dialogs(class_dialogs*);
		void clear();
		
	protected:
		
		// Windows
		class_dialogs *pt_dialogs;
		
		// Widgets
		Gtk::VBox
			vbox_window;
		
		Gtk::HBox
			hbox_sourcefile,
		hbox_save;
		
		Gtk::Frame
			frame_sourcefile;
		
		Gtk::Entry
			entry_sourcefile;
		
		Gtk::Button
			button_sourcefile,
		button_save;
		
		Gtk::Alignment
			alignment_save;
		
		// Signal Handlers
		virtual void on_button_sourcefile();
		virtual void on_button_save();
};

#endif
