/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     NUMBER = 258,
     CHAR_CONST = 259,
     FLOAT = 260,
     STRING = 261,
     T_PCB = 262,
     T_LAYER = 263,
     T_VIA = 264,
     T_RAT = 265,
     T_LINE = 266,
     T_ARC = 267,
     T_RECTANGLE = 268,
     T_TEXT = 269,
     T_ELEMENTLINE = 270,
     T_ELEMENT = 271,
     T_PIN = 272,
     T_PAD = 273,
     T_GRID = 274,
     T_FLAGS = 275,
     T_SYMBOL = 276,
     T_SYMBOLLINE = 277,
     T_CURSOR = 278,
     T_ELEMENTARC = 279,
     T_MARK = 280,
     T_GROUPS = 281,
     T_STYLES = 282,
     T_POLYGON = 283,
     T_NETLIST = 284,
     T_NET = 285,
     T_CONN = 286,
     T_THERMAL = 287,
     T_DRC = 288
   };
#endif
#define NUMBER 258
#define CHAR_CONST 259
#define FLOAT 260
#define STRING 261
#define T_PCB 262
#define T_LAYER 263
#define T_VIA 264
#define T_RAT 265
#define T_LINE 266
#define T_ARC 267
#define T_RECTANGLE 268
#define T_TEXT 269
#define T_ELEMENTLINE 270
#define T_ELEMENT 271
#define T_PIN 272
#define T_PAD 273
#define T_GRID 274
#define T_FLAGS 275
#define T_SYMBOL 276
#define T_SYMBOLLINE 277
#define T_CURSOR 278
#define T_ELEMENTARC 279
#define T_MARK 280
#define T_GROUPS 281
#define T_STYLES 282
#define T_POLYGON 283
#define T_NETLIST 284
#define T_NET 285
#define T_CONN 286
#define T_THERMAL 287
#define T_DRC 288




/* Copy the first part of user declarations.  */
#line 3 "parse_y.y"

/*
 *                            COPYRIGHT
 *
 *  PCB, interactive printed circuit board design
 *  Copyright (C) 1994,1995,1996 Thomas Nau
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Contact addresses for paper mail and Email:
 *  Thomas Nau, Schlehenweg 15, 88471 Baustetten, Germany
 *  Thomas.Nau@rz.uni-ulm.de
 *
 */

/* grammar to parse ASCII input of PCB description
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define GRIDFIT(x,g) (int)(0.5 + (int)(((x)+(g)/2.)/(g))*(g))
#include "global.h"
#include "create.h"
#include "data.h"
#include "error.h"
#include "mymem.h"
#include "misc.h"
#include "parse_l.h"
#include "remove.h"
#include "rtree.h"
#include "strflags.h"

#ifdef HAVE_LIBDMALLOC
# include <dmalloc.h> /* see http://dmalloc.com */
#endif

RCSID("$Id: parse_y.y,v 1.27 2006/08/02 15:55:18 djdelorie Exp $");

static	LayerTypePtr	Layer;
static	PolygonTypePtr	Polygon;
static	SymbolTypePtr	Symbol;
static	int		pin_num;
static	LibraryMenuTypePtr	Menu;
static	Boolean			LayerFlag[MAX_LAYER + 2];

extern	char			*yytext;		/* defined by LEX */
extern	PCBTypePtr		yyPCB;
extern	DataTypePtr		yyData;
extern	ElementTypePtr	yyElement;
extern	FontTypePtr		yyFont;
extern	int				yylineno;		/* linenumber */
extern	char			*yyfilename;	/* in this file */

static char *layer_group_string; 

int yyerror(const char *s);
int yylex();



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 78 "parse_y.y"
typedef union YYSTYPE {
	int		number;
	float		floating;
	char		*string;
	FlagType	flagtype;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 222 "parse_y.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 234 "parse_y.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  9
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   593

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  38
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  95
/* YYNRULES -- Number of rules. */
#define YYNRULES  176
/* YYNRULES -- Number of states. */
#define YYNSTATES  578

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   288

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      34,    35,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    36,     2,    37,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     7,     9,    11,    12,    25,    26,
      29,    31,    32,    33,    36,    41,    48,    55,    57,    59,
      61,    63,    70,    78,    86,    94,   101,   108,   115,   116,
     117,   122,   123,   125,   127,   129,   136,   144,   154,   159,
     160,   165,   166,   171,   176,   177,   179,   180,   182,   185,
     187,   189,   191,   192,   195,   197,   199,   201,   203,   205,
     207,   219,   231,   242,   252,   261,   272,   283,   284,   294,
     296,   297,   299,   302,   304,   306,   308,   310,   312,   314,
     323,   325,   327,   329,   330,   339,   350,   361,   371,   384,
     397,   409,   418,   428,   438,   440,   443,   448,   453,   454,
     456,   458,   460,   462,   464,   465,   478,   479,   495,   496,
     513,   514,   533,   534,   553,   555,   558,   560,   562,   564,
     566,   568,   577,   586,   597,   608,   614,   620,   622,   625,
     627,   629,   631,   633,   642,   651,   662,   673,   686,   699,
     710,   720,   729,   743,   757,   769,   780,   782,   784,   786,
     789,   790,   800,   801,   811,   813,   815,   817,   820,   822,
     824,   825,   834,   843,   845,   846,   853,   855,   856,   858,
     861,   862,   872,   874,   875,   877,   880
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
      39,     0,    -1,    40,    -1,    42,    -1,    45,    -1,     1,
      -1,    -1,    41,    47,    48,    53,    54,    55,    59,    60,
      61,    44,    62,   124,    -1,    -1,    43,    62,    -1,    45,
      -1,    -1,    -1,    46,   115,    -1,     7,    34,     6,    35,
      -1,     7,    34,     6,     3,     3,    35,    -1,     7,    36,
       6,     3,     3,    37,    -1,    49,    -1,    50,    -1,    51,
      -1,    52,    -1,    19,    34,     3,     3,     3,    35,    -1,
      19,    34,     3,     3,     3,     3,    35,    -1,    19,    34,
       5,     3,     3,     3,    35,    -1,    19,    36,     5,     3,
       3,     3,    37,    -1,    23,    34,     3,     3,     3,    35,
      -1,    23,    36,     3,     3,     3,    37,    -1,    23,    36,
       3,     3,     5,    37,    -1,    -1,    -1,    32,    36,     5,
      37,    -1,    -1,    56,    -1,    57,    -1,    58,    -1,    33,
      36,     3,     3,     3,    37,    -1,    33,    36,     3,     3,
       3,     3,    37,    -1,    33,    36,     3,     3,     3,     3,
       3,     3,    37,    -1,    20,    34,     3,    35,    -1,    -1,
      26,    34,     6,    35,    -1,    -1,    27,    34,     6,    35,
      -1,    27,    36,     6,    37,    -1,    -1,    63,    -1,    -1,
      64,    -1,    63,    64,    -1,    66,    -1,    72,    -1,    73,
      -1,    -1,    65,    90,    -1,     1,    -1,    67,    -1,    68,
      -1,    69,    -1,    70,    -1,    71,    -1,     9,    36,     3,
       3,     3,     3,     3,     3,     6,   114,    37,    -1,     9,
      34,     3,     3,     3,     3,     3,     3,     6,     3,    35,
      -1,     9,    34,     3,     3,     3,     3,     3,     6,     3,
      35,    -1,     9,    34,     3,     3,     3,     3,     6,     3,
      35,    -1,     9,    34,     3,     3,     3,     6,     3,    35,
      -1,    10,    36,     3,     3,     3,     3,     3,     3,   114,
      37,    -1,    10,    34,     3,     3,     3,     3,     3,     3,
       3,    35,    -1,    -1,     8,    34,     3,     6,    35,    34,
      74,    75,    35,    -1,    76,    -1,    -1,    77,    -1,    76,
      77,    -1,    79,    -1,    80,    -1,    81,    -1,    82,    -1,
      83,    -1,    84,    -1,    13,    34,     3,     3,     3,     3,
       3,    35,    -1,    87,    -1,    86,    -1,    85,    -1,    -1,
      28,    34,   114,    35,    34,    78,    88,    35,    -1,    11,
      36,     3,     3,     3,     3,     3,     3,   114,    37,    -1,
      11,    34,     3,     3,     3,     3,     3,     3,     3,    35,
      -1,    11,    34,     3,     3,     3,     3,     3,     3,    35,
      -1,    12,    36,     3,     3,     3,     3,     3,     3,     3,
       3,   114,    37,    -1,    12,    34,     3,     3,     3,     3,
       3,     3,     3,     3,     3,    35,    -1,    12,    34,     3,
       3,     3,     3,     3,     3,     3,     3,    35,    -1,    14,
      34,     3,     3,     3,     6,     3,    35,    -1,    14,    34,
       3,     3,     3,     3,     6,     3,    35,    -1,    14,    36,
       3,     3,     3,     3,     6,   114,    37,    -1,    89,    -1,
      88,    89,    -1,    34,     3,     3,    35,    -1,    36,     3,
       3,    37,    -1,    -1,    91,    -1,    93,    -1,    95,    -1,
      97,    -1,    99,    -1,    -1,    16,    34,     6,     6,     3,
       3,     3,    35,    34,    92,   101,    35,    -1,    -1,    16,
      34,     3,     6,     6,     3,     3,     3,     3,     3,    35,
      34,    94,   101,    35,    -1,    -1,    16,    34,     3,     6,
       6,     6,     3,     3,     3,     3,     3,    35,    34,    96,
     101,    35,    -1,    -1,    16,    34,     3,     6,     6,     6,
       3,     3,     3,     3,     3,     3,     3,    35,    34,    98,
     103,    35,    -1,    -1,    16,    36,   114,     6,     6,     6,
       3,     3,     3,     3,     3,     3,   114,    37,    34,   100,
     103,    35,    -1,   102,    -1,   101,   102,    -1,   107,    -1,
     108,    -1,   109,    -1,   112,    -1,   113,    -1,    15,    36,
       3,     3,     3,     3,     3,    37,    -1,    15,    34,     3,
       3,     3,     3,     3,    35,    -1,    24,    36,     3,     3,
       3,     3,     3,     3,     3,    37,    -1,    24,    34,     3,
       3,     3,     3,     3,     3,     3,    35,    -1,    25,    36,
       3,     3,    37,    -1,    25,    34,     3,     3,    35,    -1,
     104,    -1,   103,   104,    -1,   106,    -1,   105,    -1,   111,
      -1,   110,    -1,    15,    36,     3,     3,     3,     3,     3,
      37,    -1,    15,    34,     3,     3,     3,     3,     3,    35,
      -1,    24,    36,     3,     3,     3,     3,     3,     3,     3,
      37,    -1,    24,    34,     3,     3,     3,     3,     3,     3,
       3,    35,    -1,    17,    36,     3,     3,     3,     3,     3,
       3,     6,     6,   114,    37,    -1,    17,    34,     3,     3,
       3,     3,     3,     3,     6,     6,     3,    35,    -1,    17,
      34,     3,     3,     3,     3,     6,     6,     3,    35,    -1,
      17,    34,     3,     3,     3,     3,     6,     3,    35,    -1,
      17,    34,     3,     3,     3,     6,     3,    35,    -1,    18,
      36,     3,     3,     3,     3,     3,     3,     3,     6,     6,
     114,    37,    -1,    18,    34,     3,     3,     3,     3,     3,
       3,     3,     6,     6,     3,    35,    -1,    18,    34,     3,
       3,     3,     3,     3,     6,     6,     3,    35,    -1,    18,
      34,     3,     3,     3,     3,     3,     6,     3,    35,    -1,
       3,    -1,     6,    -1,   116,    -1,   115,   116,    -1,    -1,
      21,    36,   119,     3,    37,    34,   117,   120,    35,    -1,
      -1,    21,    34,   119,     3,    35,    34,   118,   120,    35,
      -1,     3,    -1,     4,    -1,   121,    -1,   120,   121,    -1,
     122,    -1,   123,    -1,    -1,    22,    34,     3,     3,     3,
       3,     3,    35,    -1,    22,    36,     3,     3,     3,     3,
       3,    37,    -1,   125,    -1,    -1,    29,    34,    35,    34,
     126,    35,    -1,   127,    -1,    -1,   128,    -1,   127,   128,
      -1,    -1,    30,    34,     6,     6,    35,    34,   129,   130,
      35,    -1,   131,    -1,    -1,   132,    -1,   131,   132,    -1,
      31,    34,     6,    35,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   101,   101,   102,   103,   104,   128,   128,   170,   170,
     189,   190,   195,   195,   236,   242,   248,   277,   278,   279,
     280,   283,   291,   304,   316,   348,   354,   360,   366,   383,
     385,   416,   418,   419,   420,   424,   433,   443,   470,   474,
     502,   506,   550,   558,   566,   570,   571,   575,   576,   580,
     581,   582,   584,   584,   591,   595,   596,   597,   598,   599,
     635,   644,   655,   665,   675,   711,   716,   748,   747,   771,
     772,   776,   777,   781,   782,   783,   784,   785,   786,   788,
     793,   794,   795,   798,   797,   850,   858,   867,   915,   923,
     932,   969,   979,   997,  1032,  1033,  1038,  1042,  1046,  1103,
    1104,  1105,  1106,  1107,  1115,  1114,  1133,  1132,  1151,  1150,
    1171,  1169,  1192,  1190,  1270,  1271,  1275,  1276,  1277,  1278,
    1279,  1281,  1286,  1291,  1296,  1301,  1306,  1314,  1315,  1319,
    1320,  1321,  1322,  1324,  1330,  1337,  1342,  1387,  1399,  1411,
    1422,  1437,  1491,  1505,  1518,  1529,  1540,  1541,  1545,  1546,
    1570,  1569,  1587,  1586,  1606,  1607,  1611,  1612,  1616,  1617,
    1618,  1639,  1646,  1662,  1663,  1667,  1672,  1673,  1677,  1678,
    1701,  1700,  1710,  1711,  1715,  1716,  1735
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "NUMBER", "CHAR_CONST", "FLOAT", "STRING", 
  "T_PCB", "T_LAYER", "T_VIA", "T_RAT", "T_LINE", "T_ARC", "T_RECTANGLE", 
  "T_TEXT", "T_ELEMENTLINE", "T_ELEMENT", "T_PIN", "T_PAD", "T_GRID", 
  "T_FLAGS", "T_SYMBOL", "T_SYMBOLLINE", "T_CURSOR", "T_ELEMENTARC", 
  "T_MARK", "T_GROUPS", "T_STYLES", "T_POLYGON", "T_NETLIST", "T_NET", 
  "T_CONN", "T_THERMAL", "T_DRC", "'('", "')'", "'['", "']'", "$accept", 
  "parse", "parsepcb", "@1", "parsedata", "@2", "pcbfont", "parsefont", 
  "@3", "pcbname", "pcbgrid", "pcbgridold", "pcbgridnew", "pcb2grid", 
  "pcbhigrid", "pcbcursor", "pcbthermal", "pcbdrc", "pcbdrc1", "pcbdrc2", 
  "pcbdrc3", "pcbflags", "pcbgroups", "pcbstyles", "pcbdata", 
  "pcbdefinitions", "pcbdefinition", "@4", "via", "via_hi_format", 
  "via_2.0_format", "via_1.7_format", "via_newformat", "via_oldformat", 
  "rats", "layer", "@5", "layerdata", "layerdefinitions", 
  "layerdefinition", "@6", "line_hi_format", "line_1.7_format", 
  "line_oldformat", "arc_hi_format", "arc_1.7_format", "arc_oldformat", 
  "text_oldformat", "text_newformat", "text_hi_format", "polygonpoints", 
  "polygonpoint", "element", "element_oldformat", "@7", 
  "element_1.3.4_format", "@8", "element_newformat", "@9", 
  "element_1.7_format", "@10", "element_hi_format", "@11", 
  "elementdefinitions", "elementdefinition", "relementdefs", 
  "relementdef", "pin_hi_format", "pin_1.7_format", "pin_1.6.3_format", 
  "pin_newformat", "pin_oldformat", "pad_hi_format", "pad_1.7_format", 
  "pad_newformat", "pad", "flags", "symbols", "symbol", "@12", "@13", 
  "symbolid", "symboldata", "symboldefinitions", "symboldefinition", 
  "hiressymbol", "pcbnetlist", "pcbnetdef", "nets", "netdefs", "net", 
  "@14", "connections", "conndefs", "conn", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    40,    41,    91,    93
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    38,    39,    39,    39,    39,    41,    40,    43,    42,
      44,    44,    46,    45,    47,    47,    47,    48,    48,    48,
      48,    49,    50,    51,    52,    53,    53,    53,    53,    54,
      54,    55,    55,    55,    55,    56,    57,    58,    59,    59,
      60,    60,    61,    61,    61,    62,    62,    63,    63,    64,
      64,    64,    65,    64,    64,    66,    66,    66,    66,    66,
      67,    68,    69,    70,    71,    72,    72,    74,    73,    75,
      75,    76,    76,    77,    77,    77,    77,    77,    77,    77,
      77,    77,    77,    78,    77,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    88,    89,    89,    89,    90,
      90,    90,    90,    90,    92,    91,    94,    93,    96,    95,
      98,    97,   100,    99,   101,   101,   102,   102,   102,   102,
     102,   102,   102,   102,   102,   102,   102,   103,   103,   104,
     104,   104,   104,   104,   104,   104,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   114,   115,   115,
     117,   116,   118,   116,   119,   119,   120,   120,   121,   121,
     121,   122,   123,   124,   124,   125,   126,   126,   127,   127,
     129,   128,   130,   130,   131,   131,   132
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     1,     1,     1,     0,    12,     0,     2,
       1,     0,     0,     2,     4,     6,     6,     1,     1,     1,
       1,     6,     7,     7,     7,     6,     6,     6,     0,     0,
       4,     0,     1,     1,     1,     6,     7,     9,     4,     0,
       4,     0,     4,     4,     0,     1,     0,     1,     2,     1,
       1,     1,     0,     2,     1,     1,     1,     1,     1,     1,
      11,    11,    10,     9,     8,    10,    10,     0,     9,     1,
       0,     1,     2,     1,     1,     1,     1,     1,     1,     8,
       1,     1,     1,     0,     8,    10,    10,     9,    12,    12,
      11,     8,     9,     9,     1,     2,     4,     4,     0,     1,
       1,     1,     1,     1,     0,    12,     0,    15,     0,    16,
       0,    18,     0,    18,     1,     2,     1,     1,     1,     1,
       1,     8,     8,    10,    10,     5,     5,     1,     2,     1,
       1,     1,     1,     8,     8,    10,    10,    12,    12,    10,
       9,     8,    13,    13,    11,    10,     1,     1,     1,     2,
       0,     9,     0,     9,     1,     1,     1,     2,     1,     1,
       0,     8,     8,     1,     0,     6,     1,     0,     1,     2,
       0,     9,     1,     0,     1,     2,     4
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       0,     5,     0,     2,     0,     3,     0,     4,     0,     1,
       0,     0,    54,     0,     0,     0,     9,     0,    47,     0,
      49,    55,    56,    57,    58,    59,    50,    51,     0,    13,
     148,     0,     0,     0,    28,    17,    18,    19,    20,     0,
       0,     0,     0,     0,    48,     0,    53,    99,   100,   101,
     102,   103,     0,     0,   149,     0,     0,     0,     0,     0,
      29,     0,     0,     0,     0,     0,     0,     0,   154,   155,
       0,     0,     0,    14,     0,     0,     0,     0,     0,     0,
       0,    31,     0,     0,     0,     0,     0,     0,     0,   146,
     147,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    39,    32,    33,    34,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    15,    16,     0,
       0,     0,     0,     0,     0,     0,     0,    41,    67,     0,
       0,     0,     0,     0,     0,     0,     0,   152,   150,     0,
      21,     0,     0,     0,     0,     0,    30,     0,     0,     0,
      44,    70,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   160,   160,    22,    23,    24,    25,    26,    27,
       0,     0,     0,     0,    11,     0,     0,     0,     0,     0,
       0,    69,    71,    73,    74,    75,    76,    77,    78,    82,
      81,    80,     0,     0,     0,    64,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   156,   158,   159,     0,     0,
      38,     0,     0,     0,     0,    10,     0,     0,     0,     0,
       0,     0,     0,     0,    68,    72,     0,     0,    63,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   153,   157,
     151,     0,    35,    40,     0,     0,   164,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    62,     0,    66,    65,
       0,     0,   104,     0,     0,     0,     0,    36,    42,    43,
       0,     7,   163,     0,     0,     0,     0,     0,     0,     0,
       0,    61,    60,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    83,     0,
       0,     0,     0,     0,     0,     0,     0,   114,   116,   117,
     118,   119,   120,     0,     0,     0,    37,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    98,   106,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   105,   115,
       0,     0,     0,   167,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    94,     0,     0,   108,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   166,   168,     0,     0,     0,     0,    79,     0,
      91,     0,     0,     0,    84,    95,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   161,   162,
       0,   165,   169,     0,    87,     0,     0,     0,    92,    93,
       0,     0,   107,   110,     0,     0,     0,     0,     0,     0,
       0,   126,   125,   112,     0,    86,    85,     0,     0,    96,
      97,     0,   109,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    90,     0,     0,     0,     0,     0,     0,
     127,   130,   129,   132,   131,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    89,    88,     0,     0,     0,     0,
       0,     0,     0,     0,   111,   128,   122,   121,     0,     0,
     141,     0,     0,     0,   113,   170,     0,     0,     0,     0,
       0,     0,     0,     0,   140,     0,     0,     0,     0,     0,
     173,     0,     0,     0,     0,     0,     0,     0,     0,   139,
     145,     0,   124,   123,     0,     0,   172,   174,     0,     0,
       0,     0,     0,     0,     0,     0,   144,     0,   171,   175,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   176,   134,   133,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   136,   135,     0,     0,
       0,     0,   138,   137,     0,     0,   143,   142
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     2,     3,     4,     5,     6,   214,     7,     8,    11,
      34,    35,    36,    37,    38,    60,    81,   103,   104,   105,
     106,   127,   150,   174,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,   151,   180,   181,   182,
     326,   183,   184,   185,   186,   187,   188,   189,   190,   191,
     354,   355,    46,    47,   285,    48,   356,    49,   388,    50,
     431,    51,   440,   306,   307,   449,   450,   451,   452,   308,
     309,   310,   453,   454,   311,   312,    91,    29,    30,   163,
     162,    70,   204,   205,   206,   207,   271,   272,   371,   372,
     373,   500,   515,   516,   517
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -430
static const short yypact[] =
{
      14,  -430,    32,  -430,    -2,  -430,   104,  -430,    29,  -430,
     109,    39,  -430,    17,   110,   114,  -430,    18,  -430,    43,
    -430,  -430,  -430,  -430,  -430,  -430,  -430,  -430,   115,    29,
    -430,    57,    62,   118,    51,  -430,  -430,  -430,  -430,    76,
      77,    81,    86,   103,  -430,   121,  -430,  -430,  -430,  -430,
    -430,  -430,     9,     9,  -430,     3,   108,   153,   116,   127,
      90,   141,   156,   161,   162,   163,    72,    96,  -430,  -430,
     172,   184,   193,  -430,   194,   195,   196,   197,   198,   199,
     167,   171,   170,   203,   204,   205,   206,   207,   208,  -430,
    -430,   209,   175,   174,   177,   179,   214,   215,   216,   217,
     218,   219,   186,   211,  -430,  -430,  -430,   189,   113,   222,
     223,   224,   226,   225,   227,   200,   201,  -430,  -430,     4,
     233,   234,   235,   157,   192,   236,   210,   220,  -430,   120,
     237,   238,   239,   240,   124,   242,   241,  -430,  -430,   213,
    -430,   221,   212,   228,   229,   230,  -430,   247,   248,   231,
     232,    82,   125,   249,   243,   250,   251,   252,   254,   255,
     257,   258,   246,   246,  -430,  -430,  -430,  -430,  -430,  -430,
     259,   244,   263,   133,   253,   134,   137,   256,   138,   260,
     245,    82,  -430,  -430,  -430,  -430,  -430,  -430,  -430,  -430,
    -430,  -430,   264,   261,   262,  -430,   265,   269,    96,   270,
     272,   266,   273,   142,   -18,  -430,  -430,  -430,    -6,    -1,
    -430,   267,   271,   275,    44,  -430,   279,   280,   281,   282,
     283,   284,   285,    96,  -430,  -430,   286,   268,  -430,    96,
     274,   276,   288,   289,   277,   290,   292,   293,  -430,  -430,
    -430,     0,  -430,  -430,   287,   278,   291,   295,   296,   297,
     301,   302,   303,   304,   294,   298,  -430,   299,  -430,  -430,
     305,   307,  -430,   309,   311,   313,   314,  -430,  -430,  -430,
     300,  -430,  -430,   315,   316,   318,   320,   321,   322,   323,
     306,  -430,  -430,   308,   324,   100,   325,   327,   328,   310,
     317,   329,   332,   334,   335,   336,   126,   338,  -430,   312,
       5,   145,   319,   326,   146,   149,    31,  -430,  -430,  -430,
    -430,  -430,  -430,   339,   341,   342,  -430,   330,   345,   346,
     347,   348,   351,   349,   353,   352,   150,  -430,   354,   333,
     356,   358,   359,   360,   363,   365,   366,   367,  -430,  -430,
      96,   368,   369,   344,   372,   373,   374,   375,   350,   376,
     355,    96,   377,   378,   105,  -430,   100,   357,  -430,   379,
     380,   381,   383,   384,   385,   386,   388,   361,   362,   364,
     370,   371,   344,  -430,     6,    96,   390,   391,  -430,   382,
    -430,   387,   392,   393,  -430,  -430,    47,   389,   100,   396,
     397,   399,   400,   402,   404,   394,   395,   401,  -430,  -430,
     403,  -430,  -430,   398,  -430,   405,   407,   408,  -430,  -430,
     406,   409,  -430,  -430,    52,   410,   411,   130,   412,   413,
     415,  -430,  -430,  -430,   414,  -430,  -430,     7,    96,  -430,
    -430,    83,  -430,   416,   418,   419,   423,   424,   425,   427,
      83,   417,   420,  -430,   421,   154,   155,   158,   159,    68,
    -430,  -430,  -430,  -430,  -430,   422,   426,   131,   429,   428,
     433,   434,    73,   431,  -430,  -430,   435,   436,   437,   440,
     441,   442,   444,   445,  -430,  -430,  -430,  -430,   432,   446,
    -430,   132,   447,   448,  -430,  -430,   450,   451,   453,   456,
     457,   458,   459,   463,  -430,   438,   439,   465,   443,   449,
     452,   466,   467,   468,   469,   472,   473,   474,   476,  -430,
    -430,   454,  -430,  -430,   460,   455,   452,  -430,   477,   478,
     479,   481,   482,   484,   485,   488,  -430,   486,  -430,  -430,
     490,   492,   493,   494,   495,   496,   497,   498,   470,   471,
     475,   499,   500,   501,   504,   505,   506,  -430,  -430,  -430,
     507,   508,   512,   513,   514,   515,   516,   517,   518,   519,
     491,   483,   524,    96,   522,   523,  -430,  -430,   502,   503,
     527,    96,  -430,  -430,   509,   510,  -430,  -430
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
    -430,  -430,  -430,  -430,  -430,  -430,  -430,   337,  -430,  -430,
    -430,  -430,  -430,  -430,  -430,  -430,  -430,  -430,  -430,  -430,
    -430,  -430,  -430,  -430,   331,  -430,   521,  -430,  -430,  -430,
    -430,  -430,  -430,  -430,  -430,  -430,  -430,  -430,  -430,   340,
    -430,  -430,  -430,  -430,  -430,  -430,  -430,  -430,  -430,  -430,
    -430,    54,  -430,  -430,  -430,  -430,  -430,  -430,  -430,  -430,
    -430,  -430,  -430,  -345,  -305,   -28,  -429,  -430,  -430,  -430,
    -430,  -430,  -430,  -430,  -430,  -430,  -198,  -430,   520,  -430,
    -430,   480,   430,  -147,  -430,  -430,  -430,  -430,  -430,  -430,
      50,  -430,  -430,  -430,   -85
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -53
static const short yytable[] =
{
     231,   339,   241,   266,   203,    10,    72,   139,   328,   403,
     442,   386,    68,    69,    -8,     1,   203,   238,   -45,    12,
     475,    -6,    -8,    -8,    -8,   254,    13,    14,    15,   240,
      -8,   257,     9,   475,   -52,   -12,   242,   267,    73,   140,
     329,   404,   443,   414,   -46,    12,   301,   -45,   302,   303,
      28,    39,    13,    14,    15,   304,   305,   239,    33,    45,
     -52,   239,   301,    55,   302,   303,   338,   301,    56,   302,
     303,   304,   305,   -46,    59,    87,   304,   305,    88,    61,
      62,   339,   412,   445,    63,   446,   447,   432,   445,    64,
     446,   447,   448,   175,   176,   177,   178,   448,   445,    89,
     446,   447,    90,   474,   -46,    12,    65,   448,   484,   339,
     179,    74,    13,    14,    15,   301,   129,   302,   303,   130,
     -52,    77,    80,   152,   304,   305,   153,   158,   192,   323,
     159,   193,   324,   435,   478,   496,   436,   479,   497,   352,
     384,   353,   367,    31,    40,    32,    41,    82,    42,    52,
      43,    53,    57,   381,    58,    66,    75,    67,    76,    83,
     144,    78,   145,    79,    84,    85,    86,   212,   216,   213,
     217,   218,   221,   219,   222,    92,   236,   405,   237,   330,
     334,   331,   335,   336,   352,   337,   353,    93,   466,   468,
     467,   469,   470,   472,   471,   473,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   107,   108,   109,   110,   111,
     115,   116,   117,   112,   113,   114,   118,   119,   120,   121,
     122,   123,   125,   128,   124,   131,   132,   133,   135,   146,
     444,   126,   134,   136,   137,   138,   141,   142,   143,   147,
     154,   155,   156,   157,   148,   160,   149,   161,   164,   166,
     170,   171,   194,   196,   197,   198,   165,   199,   200,   173,
     201,   202,   209,   167,   227,   172,   168,   169,   203,   211,
     226,   229,   230,   232,   -12,   233,   235,   244,   195,   210,
     224,   245,   247,   248,   249,   250,   251,   252,   253,   255,
     220,   260,   261,   263,   223,   264,   265,   228,   273,   274,
     275,   234,   243,   256,   276,   277,   278,   279,   283,   258,
     284,   262,   286,   259,   287,   269,   288,   289,   291,   292,
     270,   293,   268,   294,   295,   296,   297,   300,   313,   280,
     314,   315,   318,   281,   290,   319,   282,   320,   321,   322,
     298,   325,   340,   299,   341,   342,   327,   316,   344,   345,
     346,   347,   317,   332,   348,   349,   350,   357,   351,   359,
     333,   360,   361,   362,   343,   569,   363,   358,   364,   365,
     366,   368,   369,   575,   370,   374,   375,   376,   377,   379,
     382,   383,   389,   390,   391,   378,   392,   393,   394,   395,
     380,   396,   387,   406,   407,   410,   411,   398,   397,   415,
     416,   399,   417,   418,   400,   419,   401,   420,   385,   424,
     427,   428,   462,   433,   434,   437,   438,   408,   439,   455,
     441,   456,   402,   413,   409,   457,   458,   459,   460,   421,
     461,   529,   422,   425,   481,   423,   482,   483,   486,   487,
     488,   429,   426,   489,   490,   491,   430,   492,   493,   495,
     498,   499,   463,   501,   502,   464,   503,   476,   465,   504,
     505,   506,   507,   477,   480,   485,   508,   494,   511,   518,
     519,   520,   521,   509,   510,   522,   523,   524,   512,   525,
     530,   531,   532,   514,   533,   534,   513,   535,   536,   526,
     528,   537,   538,   539,   527,   540,   541,   542,   543,   544,
     545,   546,   550,   551,   552,   547,   548,   553,   554,   555,
       0,   215,   549,   556,   557,   558,   559,   560,   561,     0,
     567,   225,   562,   563,   564,   565,   566,   568,   570,   571,
     574,     0,     0,    71,     0,     0,     0,   572,    44,     0,
     573,     0,     0,     0,   576,   246,     0,   577,     0,    54,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   208
};

static const short yycheck[] =
{
     198,   306,     3,     3,    22,     7,     3,     3,     3,     3,
       3,   356,     3,     4,     0,     1,    22,    35,     0,     1,
     449,     7,     8,     9,    10,   223,     8,     9,    10,    35,
      16,   229,     0,   462,    16,    21,    37,    37,    35,    35,
      35,    35,    35,   388,     0,     1,    15,    29,    17,    18,
      21,    34,     8,     9,    10,    24,    25,   204,    19,    16,
      16,   208,    15,     6,    17,    18,    35,    15,     6,    17,
      18,    24,    25,    29,    23,     3,    24,    25,     6,     3,
       3,   386,    35,    15,     3,    17,    18,    35,    15,     3,
      17,    18,    24,    11,    12,    13,    14,    24,    15,     3,
      17,    18,     6,    35,     0,     1,     3,    24,    35,   414,
      28,     3,     8,     9,    10,    15,     3,    17,    18,     6,
      16,     5,    32,     3,    24,    25,     6,     3,     3,     3,
       6,     6,     6,     3,     3,     3,     6,     6,     6,    34,
      35,    36,   340,    34,    34,    36,    36,     6,    34,    34,
      36,    36,    34,   351,    36,    34,     3,    36,     5,     3,
       3,    34,     5,    36,     3,     3,     3,    34,    34,    36,
      36,    34,    34,    36,    36,     3,    34,   375,    36,    34,
      34,    36,    36,    34,    34,    36,    36,     3,    34,    34,
      36,    36,    34,    34,    36,    36,     3,     3,     3,     3,
       3,     3,     3,    36,    33,    35,     3,     3,     3,     3,
      35,    37,    35,     6,     6,     6,    37,     3,     3,     3,
       3,     3,    36,    34,     5,     3,     3,     3,     3,    37,
     428,    20,     6,     6,    34,    34,     3,     3,     3,     3,
       3,     3,     3,     3,    34,     3,    26,     6,    35,    37,
       3,     3,     3,     3,     3,     3,    35,     3,     3,    27,
       3,     3,     3,    35,     3,    34,    37,    37,    22,     6,
       6,     6,     3,     3,    21,     3,     3,     6,    35,    35,
      35,     6,     3,     3,     3,     3,     3,     3,     3,     3,
      34,     3,     3,     3,    34,     3,     3,    35,     3,     3,
       3,    35,    35,    35,     3,     3,     3,     3,     3,    35,
       3,    34,     3,    37,     3,    37,     3,     3,     3,     3,
      29,     3,    35,     3,     3,     3,     3,     3,     3,    35,
       3,     3,     3,    35,    34,     3,    37,     3,     3,     3,
      34,     3,     3,    35,     3,     3,    34,    37,     3,     3,
       3,     3,    35,    34,     3,     6,     3,     3,     6,     3,
      34,     3,     3,     3,    34,   563,     3,    34,     3,     3,
       3,     3,     3,   571,    30,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,    35,     3,     3,     3,     3,
      35,     3,    35,     3,     3,     3,     3,    35,    37,     3,
       3,    37,     3,     3,    34,     3,    35,     3,   354,     6,
       3,     3,   440,     3,     3,     3,     3,    35,     3,     3,
       6,     3,   372,    34,    37,     6,     3,     3,     3,    35,
       3,   516,    37,    35,     6,    34,     3,     3,     3,     3,
       3,    35,    37,     3,     3,     3,    37,     3,     3,     3,
       3,     3,    35,     3,     3,    35,     3,    35,    37,     3,
       3,     3,     3,    37,    35,    34,     3,    35,     3,     3,
       3,     3,     3,    35,    35,     3,     3,     3,    35,     3,
       3,     3,     3,    31,     3,     3,    37,     3,     3,    35,
      35,     3,     6,     3,    34,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,    35,    35,     3,     3,     3,
      -1,   174,    37,     6,     6,     3,     3,     3,     3,    -1,
      37,   181,     6,     6,     6,     6,    35,     3,     6,     6,
       3,    -1,    -1,    53,    -1,    -1,    -1,    35,    17,    -1,
      37,    -1,    -1,    -1,    35,   214,    -1,    37,    -1,    29,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   163
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,     1,    39,    40,    41,    42,    43,    45,    46,     0,
       7,    47,     1,     8,     9,    10,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    21,   115,
     116,    34,    36,    19,    48,    49,    50,    51,    52,    34,
      34,    36,    34,    36,    64,    16,    90,    91,    93,    95,
      97,    99,    34,    36,   116,     6,     6,    34,    36,    23,
      53,     3,     3,     3,     3,     3,    34,    36,     3,     4,
     119,   119,     3,    35,     3,     3,     5,     5,    34,    36,
      32,    54,     6,     3,     3,     3,     3,     3,     6,     3,
       6,   114,     3,     3,     3,     3,     3,     3,     3,     3,
       3,    36,    33,    55,    56,    57,    58,    35,     3,     3,
       3,     3,     6,     6,     6,    35,    37,    35,    37,     3,
       3,     3,     3,     3,     5,    36,    20,    59,    34,     3,
       6,     3,     3,     3,     6,     3,     6,    34,    34,     3,
      35,     3,     3,     3,     3,     5,    37,     3,    34,    26,
      60,    74,     3,     6,     3,     3,     3,     3,     3,     6,
       3,     6,   118,   117,    35,    35,    37,    35,    37,    37,
       3,     3,    34,    27,    61,    11,    12,    13,    14,    28,
      75,    76,    77,    79,    80,    81,    82,    83,    84,    85,
      86,    87,     3,     6,     3,    35,     3,     3,     3,     3,
       3,     3,     3,    22,   120,   121,   122,   123,   120,     3,
      35,     6,    34,    36,    44,    45,    34,    36,    34,    36,
      34,    34,    36,    34,    35,    77,     6,     3,    35,     6,
       3,   114,     3,     3,    35,     3,    34,    36,    35,   121,
      35,     3,    37,    35,     6,     6,    62,     3,     3,     3,
       3,     3,     3,     3,   114,     3,    35,   114,    35,    37,
       3,     3,    34,     3,     3,     3,     3,    37,    35,    37,
      29,   124,   125,     3,     3,     3,     3,     3,     3,     3,
      35,    35,    37,     3,     3,    92,     3,     3,     3,     3,
      34,     3,     3,     3,     3,     3,     3,     3,    34,    35,
       3,    15,    17,    18,    24,    25,   101,   102,   107,   108,
     109,   112,   113,     3,     3,     3,    37,    35,     3,     3,
       3,     3,     3,     3,     6,     3,    78,    34,     3,    35,
      34,    36,    34,    34,    34,    36,    34,    36,    35,   102,
       3,     3,     3,    34,     3,     3,     3,     3,     3,     6,
       3,     6,    34,    36,    88,    89,    94,     3,    34,     3,
       3,     3,     3,     3,     3,     3,     3,   114,     3,     3,
      30,   126,   127,   128,     3,     3,     3,     3,    35,     3,
      35,   114,     3,     3,    35,    89,   101,    35,    96,     3,
       3,     3,     3,     3,     3,     3,     3,    37,    35,    37,
      34,    35,   128,     3,    35,   114,     3,     3,    35,    37,
       3,     3,    35,    34,   101,     3,     3,     3,     3,     3,
       3,    35,    37,    34,     6,    35,    37,     3,     3,    35,
      37,    98,    35,     3,     3,     3,     6,     3,     3,     3,
     100,     6,     3,    35,   114,    15,    17,    18,    24,   103,
     104,   105,   106,   110,   111,     3,     3,     6,     3,     3,
       3,     3,   103,    35,    35,    37,    34,    36,    34,    36,
      34,    36,    34,    36,    35,   104,    35,    37,     3,     6,
      35,     6,     3,     3,    35,    34,     3,     3,     3,     3,
       3,     3,     3,     3,    35,     3,     3,     6,     3,     3,
     129,     3,     3,     3,     3,     3,     3,     3,     3,    35,
      35,     3,    35,    37,    31,   130,   131,   132,     3,     3,
       3,     3,     3,     3,     3,     3,    35,    34,    35,   132,
       3,     3,     3,     3,     3,     3,     3,     3,     6,     3,
       3,     3,     3,     3,     3,     3,     3,    35,    35,    37,
       3,     3,     3,     3,     3,     3,     6,     6,     3,     3,
       3,     3,     6,     6,     6,     6,    35,    37,     3,   114,
       6,     6,    35,    37,     3,   114,    35,    37
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1

/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 5:
#line 104 "parse_y.y"
    { YYABORT; }
    break;

  case 6:
#line 128 "parse_y.y"
    {
					/* reset flags for 'used layers';
					 * init font and data pointers
					 */
				int	i;

				if (!yyPCB)
				{
					Message("illegal fileformat\n");
					YYABORT;
				}
				for (i = 0; i < MAX_LAYER + 2; i++)
					LayerFlag[i] = False;
				yyFont = &yyPCB->Font;
				yyData = yyPCB->Data;
				yyData->LayerN = 0;
				layer_group_string = NULL;
			}
    break;

  case 7:
#line 157 "parse_y.y"
    {
			  if (layer_group_string == NULL)
			    layer_group_string = Settings.Groups;
			  CreateNewPCBPost (yyPCB, 0);
			  if (ParseGroupString(layer_group_string, &yyPCB->LayerGroups, yyData->LayerN))
			    {
			      Message("illegal layer-group string\n");
			      YYABORT;
			    }
			}
    break;

  case 8:
#line 170 "parse_y.y"
    {
					/* reset flags for 'used layers';
					 * init font and data pointers
					 */
				int	i;

				if (!yyData || !yyFont)
				{
					Message("illegal fileformat\n");
					YYABORT;
				}
				for (i = 0; i < MAX_LAYER + 2; i++)
					LayerFlag[i] = False;
				yyData->LayerN = 0;
			}
    break;

  case 12:
#line 195 "parse_y.y"
    {
					/* mark all symbols invalid */
				int	i;

				if (!yyFont)
				{
					Message("illegal fileformat\n");
					YYABORT;
				}
				yyFont->Valid = False;
				for (i = 0; i <= MAX_FONTPOSITION; i++)
					yyFont->Symbol[i].Valid = False;
			}
    break;

  case 13:
#line 209 "parse_y.y"
    {
				yyFont->Valid = True;
		  		SetFontInfo(yyFont);
			}
    break;

  case 14:
#line 237 "parse_y.y"
    {
				yyPCB->Name = yyvsp[-1].string;
				yyPCB->MaxWidth = MAX_COORD;
				yyPCB->MaxHeight = MAX_COORD;
			}
    break;

  case 15:
#line 243 "parse_y.y"
    {
				yyPCB->Name = yyvsp[-3].string;
				yyPCB->MaxWidth = yyvsp[-2].number*100;
				yyPCB->MaxHeight = yyvsp[-1].number*100;
			}
    break;

  case 16:
#line 249 "parse_y.y"
    {
				yyPCB->Name = yyvsp[-3].string;
				yyPCB->MaxWidth = yyvsp[-2].number;
				yyPCB->MaxHeight = yyvsp[-1].number;
			}
    break;

  case 21:
#line 284 "parse_y.y"
    {
				yyPCB->Grid = yyvsp[-3].number*100;
				yyPCB->GridOffsetX = yyvsp[-2].number*100;
				yyPCB->GridOffsetY = yyvsp[-1].number*100;
			}
    break;

  case 22:
#line 292 "parse_y.y"
    {
				yyPCB->Grid = yyvsp[-4].number*100;
				yyPCB->GridOffsetX = yyvsp[-3].number*100;
				yyPCB->GridOffsetY = yyvsp[-2].number*100;
				if (yyvsp[-1].number)
					Settings.DrawGrid = True;
				else
					Settings.DrawGrid = False;
			}
    break;

  case 23:
#line 305 "parse_y.y"
    {
				yyPCB->Grid = yyvsp[-4].floating*100;
				yyPCB->GridOffsetX = yyvsp[-3].number*100;
				yyPCB->GridOffsetY = yyvsp[-2].number*100;
				if (yyvsp[-1].number)
					Settings.DrawGrid = True;
				else
					Settings.DrawGrid = False;
			}
    break;

  case 24:
#line 317 "parse_y.y"
    {
				yyPCB->Grid = yyvsp[-4].floating;
				yyPCB->GridOffsetX = yyvsp[-3].number;
				yyPCB->GridOffsetY = yyvsp[-2].number;
				if (yyvsp[-1].number)
					Settings.DrawGrid = True;
				else
					Settings.DrawGrid = False;
			}
    break;

  case 25:
#line 349 "parse_y.y"
    {
				yyPCB->CursorX = yyvsp[-3].number*100;
				yyPCB->CursorY = yyvsp[-2].number*100;
				yyPCB->Zoom = yyvsp[-1].number*2;
			}
    break;

  case 26:
#line 355 "parse_y.y"
    {
				yyPCB->CursorX = yyvsp[-3].number;
				yyPCB->CursorY = yyvsp[-2].number;
				yyPCB->Zoom = yyvsp[-1].number;
			}
    break;

  case 27:
#line 361 "parse_y.y"
    {
				yyPCB->CursorX = yyvsp[-3].number;
				yyPCB->CursorY = yyvsp[-2].number;
				yyPCB->Zoom = yyvsp[-1].floating;
			}
    break;

  case 30:
#line 386 "parse_y.y"
    {
				yyPCB->ThermScale = yyvsp[-1].floating;
			}
    break;

  case 35:
#line 425 "parse_y.y"
    {
				yyPCB->Bloat = yyvsp[-3].number;
				yyPCB->Shrink = yyvsp[-2].number;
				yyPCB->minWid = yyvsp[-1].number;
			}
    break;

  case 36:
#line 434 "parse_y.y"
    {
				yyPCB->Bloat = yyvsp[-4].number;
				yyPCB->Shrink = yyvsp[-3].number;
				yyPCB->minWid = yyvsp[-2].number;
				yyPCB->minSlk = yyvsp[-1].number;
			}
    break;

  case 37:
#line 444 "parse_y.y"
    {
				yyPCB->Bloat = yyvsp[-6].number;
				yyPCB->Shrink = yyvsp[-5].number;
				yyPCB->minWid = yyvsp[-4].number;
				yyPCB->minSlk = yyvsp[-3].number;
				yyPCB->minDrill = yyvsp[-2].number;
				yyPCB->minRing = yyvsp[-1].number;
			}
    break;

  case 38:
#line 471 "parse_y.y"
    {
				yyPCB->Flags = MakeFlags (yyvsp[-1].number & PCB_FLAGS);
			}
    break;

  case 40:
#line 503 "parse_y.y"
    {
			  layer_group_string = yyvsp[-1].string;
			}
    break;

  case 42:
#line 551 "parse_y.y"
    {
				if (ParseRouteString(yyvsp[-1].string, &yyPCB->RouteStyle[0], 100))
				{
					Message("illegal route-style string\n");
					YYABORT;
				}
			}
    break;

  case 43:
#line 559 "parse_y.y"
    {
				if (ParseRouteString(yyvsp[-1].string, &yyPCB->RouteStyle[0], 1))
				{
					Message("illegal route-style string\n");
					YYABORT;
				}
			}
    break;

  case 52:
#line 584 "parse_y.y"
    {
					/* clear pointer to force memory allocation by 
					 * the appropriate subroutine
					 */
				yyElement = NULL;
			}
    break;

  case 54:
#line 591 "parse_y.y"
    { YYABORT; }
    break;

  case 60:
#line 636 "parse_y.y"
    {
				CreateNewVia(yyData, yyvsp[-8].number, yyvsp[-7].number, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].string, yyvsp[-1].flagtype);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 61:
#line 645 "parse_y.y"
    {
				CreateNewVia(yyData, yyvsp[-8].number*100, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, yyvsp[-2].string,
					OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 62:
#line 656 "parse_y.y"
    {
				CreateNewVia(yyData, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100,
					     (yyvsp[-5].number + yyvsp[-4].number)*100, yyvsp[-3].number*100, yyvsp[-2].string, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 63:
#line 666 "parse_y.y"
    {
				CreateNewVia(yyData, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-4].number + 2*MASKFRAME)*100,  yyvsp[-3].number*100, yyvsp[-2].string, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 64:
#line 676 "parse_y.y"
    {
				BDimension	hole = (yyvsp[-3].number *DEFAULT_DRILLINGHOLE);

					/* make sure that there's enough copper left */
				if (yyvsp[-3].number -hole < MIN_PINORVIACOPPER && 
					yyvsp[-3].number > MIN_PINORVIACOPPER)
					hole = yyvsp[-3].number -MIN_PINORVIACOPPER;

				CreateNewVia(yyData, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-3].number + 2*MASKFRAME)*100, hole, yyvsp[-2].string, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 65:
#line 712 "parse_y.y"
    {
				CreateNewRat(yyData, yyvsp[-7].number, yyvsp[-6].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-5].number, yyvsp[-2].number,
					Settings.RatThickness, yyvsp[-1].flagtype);
			}
    break;

  case 66:
#line 717 "parse_y.y"
    {
				CreateNewRat(yyData, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, yyvsp[-5].number, yyvsp[-2].number,
					Settings.RatThickness, OldFlags(yyvsp[-1].number));
			}
    break;

  case 67:
#line 748 "parse_y.y"
    {
				if (yyvsp[-3].number <= 0 || yyvsp[-3].number > MAX_LAYER + 2)
				{
					yyerror("Layernumber out of range");
					YYABORT;
				}
				if (LayerFlag[yyvsp[-3].number-1])
				{
					yyerror("Layernumber used twice");
					YYABORT;
				}
				Layer = &yyData->Layer[yyvsp[-3].number-1];

					/* memory for name is already allocated */
				Layer->Name = yyvsp[-2].string;
				LayerFlag[yyvsp[-3].number-1] = True;
				if (yyData->LayerN + 2 < yyvsp[-3].number)
				  yyData->LayerN = yyvsp[-3].number - 2;
			}
    break;

  case 79:
#line 789 "parse_y.y"
    {
				CreateNewPolygonFromRectangle(Layer,
					yyvsp[-5].number*100, yyvsp[-4].number*100, (yyvsp[-5].number+yyvsp[-3].number)*100, (yyvsp[-4].number+yyvsp[-2].number)*100, OldFlags(yyvsp[-1].number));
			}
    break;

  case 83:
#line 798 "parse_y.y"
    {
				Polygon = CreateNewPolygon(Layer, yyvsp[-2].flagtype);
			}
    break;

  case 84:
#line 802 "parse_y.y"
    {
					/* ignore junk */
				if (Polygon->PointN >= 3)
				  {
				    SetPolygonBoundingBox (Polygon);
				    if (!Layer->polygon_tree)
				      Layer->polygon_tree = r_create_tree (NULL, 0, 0);
				    r_insert_entry (Layer->polygon_tree, (BoxType *) Polygon, 0);
				  }
				else
				{
					Message("WARNING parsing file '%s'\n"
						"    line:        %i\n"
						"    description: 'ignored polygon (< 3 points)'\n",
						yyfilename, yylineno);
					DestroyObject(PCB->Data, POLYGON_TYPE, Layer, Polygon, Polygon);
				}
			}
    break;

  case 85:
#line 851 "parse_y.y"
    {
				CreateNewLineOnLayer(Layer, yyvsp[-7].number, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].flagtype);
			}
    break;

  case 86:
#line 859 "parse_y.y"
    {
				CreateNewLineOnLayer(Layer, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100,
						     yyvsp[-3].number*100, yyvsp[-2].number*100, OldFlags(yyvsp[-1].number));
			}
    break;

  case 87:
#line 868 "parse_y.y"
    {
				/* eliminate old-style rat-lines */
			if ((yyvsp[-1].number & RATFLAG) == 0)
				CreateNewLineOnLayer(Layer, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, yyvsp[-2].number*100,
					200*GROUNDPLANEFRAME, OldFlags(yyvsp[-1].number));
			}
    break;

  case 88:
#line 916 "parse_y.y"
    {
				CreateNewArcOnLayer(Layer, yyvsp[-9].number, yyvsp[-8].number, yyvsp[-7].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-1].flagtype);
			}
    break;

  case 89:
#line 924 "parse_y.y"
    {
				CreateNewArcOnLayer(Layer, yyvsp[-9].number*100, yyvsp[-8].number*100, yyvsp[-7].number*100, yyvsp[-3].number, yyvsp[-2].number,
						    yyvsp[-5].number*100, yyvsp[-4].number*100, OldFlags(yyvsp[-1].number));
			}
    break;

  case 90:
#line 933 "parse_y.y"
    {
				CreateNewArcOnLayer(Layer, yyvsp[-8].number*100, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-3].number, yyvsp[-2].number,
					yyvsp[-4].number*100, 200*GROUNDPLANEFRAME, OldFlags(yyvsp[-1].number));
			}
    break;

  case 91:
#line 970 "parse_y.y"
    {
					/* use a default scale of 100% */
				CreateNewText(Layer,yyFont,yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number, 100, yyvsp[-2].string, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 92:
#line 980 "parse_y.y"
    {
				if (yyvsp[-1].number & ONSILKFLAG)
				{
					LayerTypePtr lay = &yyData->Layer[max_layer +
						((yyvsp[-1].number & ONSOLDERFLAG) ? SOLDER_LAYER : COMPONENT_LAYER)];

					CreateNewText(lay ,yyFont, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].string,
						      OldFlags(yyvsp[-1].number));
				}
				else
					CreateNewText(Layer, yyFont, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].string,
						      OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 93:
#line 998 "parse_y.y"
    {
				/* FIXME: shouldn't know about .f */
				if (yyvsp[-1].flagtype.f & ONSILKFLAG)
				{
					LayerTypePtr lay = &yyData->Layer[max_layer +
						((yyvsp[-1].flagtype.f & ONSOLDERFLAG) ? SOLDER_LAYER : COMPONENT_LAYER)];

					CreateNewText(lay, yyFont, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].string, yyvsp[-1].flagtype);
				}
				else
					CreateNewText(Layer, yyFont, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].string, yyvsp[-1].flagtype);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 96:
#line 1039 "parse_y.y"
    {
				CreateNewPointInPolygon(Polygon, yyvsp[-2].number*100, yyvsp[-1].number*100);
			}
    break;

  case 97:
#line 1043 "parse_y.y"
    {
				CreateNewPointInPolygon(Polygon, yyvsp[-2].number, yyvsp[-1].number);
			}
    break;

  case 104:
#line 1115 "parse_y.y"
    {
				yyElement = CreateNewElement(yyData, yyElement, yyFont, NoFlags(),
					yyvsp[-6].string, yyvsp[-5].string, NULL, yyvsp[-4].number*100, yyvsp[-3].number*100, yyvsp[-2].number, 100, NoFlags(), False);
				SaveFree(yyvsp[-6].string);
				SaveFree(yyvsp[-5].string);
				pin_num = 1;
			}
    break;

  case 105:
#line 1123 "parse_y.y"
    {
				SetElementBoundingBox(yyData, yyElement, yyFont);
			}
    break;

  case 106:
#line 1133 "parse_y.y"
    {
				yyElement = CreateNewElement(yyData, yyElement, yyFont, OldFlags(yyvsp[-9].number),
					yyvsp[-8].string, yyvsp[-7].string, NULL, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number, yyvsp[-3].number, OldFlags(yyvsp[-2].number), False);
				SaveFree(yyvsp[-8].string);
				SaveFree(yyvsp[-7].string);
				pin_num = 1;
			}
    break;

  case 107:
#line 1141 "parse_y.y"
    {
				SetElementBoundingBox(yyData, yyElement, yyFont);
			}
    break;

  case 108:
#line 1151 "parse_y.y"
    {
				yyElement = CreateNewElement(yyData, yyElement, yyFont, OldFlags(yyvsp[-10].number),
					yyvsp[-9].string, yyvsp[-8].string, yyvsp[-7].string, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number, yyvsp[-3].number, OldFlags(yyvsp[-2].number), False);
				SaveFree(yyvsp[-9].string);
				SaveFree(yyvsp[-8].string);
				SaveFree(yyvsp[-7].string);
				pin_num = 1;
			}
    break;

  case 109:
#line 1160 "parse_y.y"
    {
				SetElementBoundingBox(yyData, yyElement, yyFont);
			}
    break;

  case 110:
#line 1171 "parse_y.y"
    {
				yyElement = CreateNewElement(yyData, yyElement, yyFont, OldFlags(yyvsp[-12].number),
					yyvsp[-11].string, yyvsp[-10].string, yyvsp[-9].string, (yyvsp[-8].number+yyvsp[-6].number)*100, (yyvsp[-7].number+yyvsp[-5].number)*100, yyvsp[-4].number, yyvsp[-3].number, OldFlags(yyvsp[-2].number), False);
				yyElement->MarkX = yyvsp[-8].number*100;
				yyElement->MarkY = yyvsp[-7].number*100;
				SaveFree(yyvsp[-11].string);
				SaveFree(yyvsp[-10].string);
				SaveFree(yyvsp[-9].string);
			}
    break;

  case 111:
#line 1181 "parse_y.y"
    {
				SetElementBoundingBox(yyData, yyElement, yyFont);
			}
    break;

  case 112:
#line 1192 "parse_y.y"
    {
				yyElement = CreateNewElement(yyData, yyElement, yyFont, yyvsp[-12].flagtype,
					yyvsp[-11].string, yyvsp[-10].string, yyvsp[-9].string, (yyvsp[-8].number+yyvsp[-6].number), (yyvsp[-7].number+yyvsp[-5].number), yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].flagtype, False);
				yyElement->MarkX = yyvsp[-8].number;
				yyElement->MarkY = yyvsp[-7].number;
				SaveFree(yyvsp[-11].string);
				SaveFree(yyvsp[-10].string);
				SaveFree(yyvsp[-9].string);
			}
    break;

  case 113:
#line 1202 "parse_y.y"
    {
				SetElementBoundingBox(yyData, yyElement, yyFont);
			}
    break;

  case 121:
#line 1282 "parse_y.y"
    {
				CreateNewLineInElement(yyElement, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number);
			}
    break;

  case 122:
#line 1287 "parse_y.y"
    {
				CreateNewLineInElement(yyElement, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, yyvsp[-2].number*100, yyvsp[-1].number*100);
			}
    break;

  case 123:
#line 1292 "parse_y.y"
    {
				CreateNewArcInElement(yyElement, yyvsp[-7].number, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number);
			}
    break;

  case 124:
#line 1297 "parse_y.y"
    {
				CreateNewArcInElement(yyElement, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number*100);
			}
    break;

  case 125:
#line 1302 "parse_y.y"
    {
				yyElement->MarkX = yyvsp[-2].number;
				yyElement->MarkY = yyvsp[-1].number;
			}
    break;

  case 126:
#line 1307 "parse_y.y"
    {
				yyElement->MarkX = yyvsp[-2].number*100;
				yyElement->MarkY = yyvsp[-1].number*100;
			}
    break;

  case 133:
#line 1325 "parse_y.y"
    {
				CreateNewLineInElement(yyElement, yyvsp[-5].number + yyElement->MarkX,
					yyvsp[-4].number + yyElement->MarkY, yyvsp[-3].number + yyElement->MarkX,
					yyvsp[-2].number + yyElement->MarkY, yyvsp[-1].number);
			}
    break;

  case 134:
#line 1331 "parse_y.y"
    {
				CreateNewLineInElement(yyElement, yyvsp[-5].number*100 + yyElement->MarkX,
					yyvsp[-4].number*100 + yyElement->MarkY, yyvsp[-3].number*100 + yyElement->MarkX,
					yyvsp[-2].number*100 + yyElement->MarkY, yyvsp[-1].number*100);
			}
    break;

  case 135:
#line 1338 "parse_y.y"
    {
				CreateNewArcInElement(yyElement, yyvsp[-7].number + yyElement->MarkX,
					yyvsp[-6].number + yyElement->MarkY, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number);
			}
    break;

  case 136:
#line 1343 "parse_y.y"
    {
				CreateNewArcInElement(yyElement, yyvsp[-7].number*100 + yyElement->MarkX,
					yyvsp[-6].number*100 + yyElement->MarkY, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number*100);
			}
    break;

  case 137:
#line 1388 "parse_y.y"
    {
				CreateNewPin(yyElement, yyvsp[-9].number + yyElement->MarkX,
					yyvsp[-8].number + yyElement->MarkY, yyvsp[-7].number, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].string,
					yyvsp[-2].string, yyvsp[-1].flagtype);
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 138:
#line 1400 "parse_y.y"
    {
				CreateNewPin(yyElement, yyvsp[-9].number*100 + yyElement->MarkX,
					yyvsp[-8].number*100 + yyElement->MarkY, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].string,
					yyvsp[-2].string, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 139:
#line 1412 "parse_y.y"
    {
				CreateNewPin(yyElement, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-5].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-5].number + 2*MASKFRAME)*100, yyvsp[-4].number*100, yyvsp[-3].string, yyvsp[-2].string, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 140:
#line 1423 "parse_y.y"
    {
				char	p_number[8];

				sprintf(p_number, "%d", pin_num++);
				CreateNewPin(yyElement, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-4].number + 2*MASKFRAME)*100, yyvsp[-3].number*100, yyvsp[-2].string, p_number, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 141:
#line 1438 "parse_y.y"
    {
				BDimension	hole = (yyvsp[-3].number *DEFAULT_DRILLINGHOLE);
				char		p_number[8];

					/* make sure that there's enough copper left */
				if (yyvsp[-3].number -hole < MIN_PINORVIACOPPER && 
					yyvsp[-3].number > MIN_PINORVIACOPPER)
					hole = yyvsp[-3].number -MIN_PINORVIACOPPER;

				sprintf(p_number, "%d", pin_num++);
				CreateNewPin(yyElement, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-3].number + 2*MASKFRAME)*100, hole, yyvsp[-2].string, p_number, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 142:
#line 1492 "parse_y.y"
    {
				CreateNewPad(yyElement, yyvsp[-10].number + yyElement->MarkX,
					yyvsp[-9].number + yyElement->MarkY,
					yyvsp[-8].number + yyElement->MarkX,
					yyvsp[-7].number + yyElement->MarkY, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number,
					yyvsp[-3].string, yyvsp[-2].string, yyvsp[-1].flagtype);
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 143:
#line 1506 "parse_y.y"
    {
				CreateNewPad(yyElement,yyvsp[-10].number*100 + yyElement->MarkX,
					yyvsp[-9].number*100 + yyElement->MarkY, yyvsp[-8].number*100 + yyElement->MarkX,
					yyvsp[-7].number*100 + yyElement->MarkY, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100,
					yyvsp[-3].string, yyvsp[-2].string, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 144:
#line 1519 "parse_y.y"
    {
				CreateNewPad(yyElement,yyvsp[-8].number*100,yyvsp[-7].number*100,yyvsp[-6].number*100,yyvsp[-5].number*100,yyvsp[-4].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-4].number + 2*MASKFRAME)*100, yyvsp[-3].string,yyvsp[-2].string, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 145:
#line 1530 "parse_y.y"
    {
				char		p_number[8];

				sprintf(p_number, "%d", pin_num++);
				CreateNewPad(yyElement,yyvsp[-7].number*100,yyvsp[-6].number*100,yyvsp[-5].number*100,yyvsp[-4].number*100,yyvsp[-3].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-3].number + 2*MASKFRAME)*100, yyvsp[-2].string,p_number, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 146:
#line 1540 "parse_y.y"
    { yyval.flagtype = OldFlags(yyvsp[0].number); }
    break;

  case 147:
#line 1541 "parse_y.y"
    { yyval.flagtype = string_to_flags (yyvsp[0].string, yyerror); }
    break;

  case 150:
#line 1570 "parse_y.y"
    {
				if (yyvsp[-3].number <= 0 || yyvsp[-3].number > MAX_FONTPOSITION)
				{
					yyerror("fontposition out of range");
					YYABORT;
				}
				Symbol = &yyFont->Symbol[yyvsp[-3].number];
				if (Symbol->Valid)
				{
					yyerror("symbol ID used twice");
					YYABORT;
				}
				Symbol->Valid = True;
				Symbol->Delta = yyvsp[-2].number;
			}
    break;

  case 152:
#line 1587 "parse_y.y"
    {
				if (yyvsp[-3].number <= 0 || yyvsp[-3].number > MAX_FONTPOSITION)
				{
					yyerror("fontposition out of range");
					YYABORT;
				}
				Symbol = &yyFont->Symbol[yyvsp[-3].number];
				if (Symbol->Valid)
				{
					yyerror("symbol ID used twice");
					YYABORT;
				}
				Symbol->Valid = True;
				Symbol->Delta = yyvsp[-2].number*100;
			}
    break;

  case 161:
#line 1640 "parse_y.y"
    {
				CreateNewLineInSymbol(Symbol, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, yyvsp[-2].number*100, yyvsp[-1].number*100);
			}
    break;

  case 162:
#line 1647 "parse_y.y"
    {
				CreateNewLineInSymbol(Symbol, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number);
			}
    break;

  case 170:
#line 1701 "parse_y.y"
    {
				Menu = CreateNewNet(&yyPCB->NetlistLib, yyvsp[-3].string, yyvsp[-2].string);
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 176:
#line 1736 "parse_y.y"
    {
				CreateNewConnection(Menu, yyvsp[-1].string);
				SaveFree(yyvsp[-1].string);
			}
    break;


    }

/* Line 991 of yacc.c.  */
#line 2457 "parse_y.c"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("syntax error, unexpected ") + 1;
	  yysize += yystrlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (yychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (yyss < yyssp)
	    {
	      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
	      yydestruct (yystos[*yyssp], yyvsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
      yydestruct (yytoken, &yylval);
      yychar = YYEMPTY;

    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab2;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:

  /* Suppress GCC warning that yyerrlab1 is unused when no action
     invokes YYERROR.  MacOS 10.2.3's buggy "smart preprocessor"
     insists on the trailing semicolon.  */
#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
  __attribute__ ((__unused__));
#endif


  goto yyerrlab2;


/*---------------------------------------------------------------.
| yyerrlab2 -- pop states until the error token can be shifted.  |
`---------------------------------------------------------------*/
yyerrlab2:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      yyvsp--;
      yystate = *--yyssp;

      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 1741 "parse_y.y"


/* ---------------------------------------------------------------------------
 * error routine called by parser library
 */
int yyerror(s)
const char *s;
{
	Message("ERROR parsing file '%s'\n"
		"    line:        %i\n"
		"    description: '%s'\n",
		yyfilename, yylineno, s);
	return(0);
}

int yywrap()
{
  return 1;
}

