#include <string.h>

#include "version.h"
#include "PluginHandler.h"
#include "MapperPlugin.h"

extern PluginHandler * phandler;
static MapperPlugin * sample;
extern struct directions direction_table[];

#define MAJOR "1"
#define MINOR "0"

extern "C" void plugin_init(void) {
  sample = new MapperPlugin();
}

extern "C" void plugin_cleanup(void) {
  delete sample;
}

extern "C" char * plugin_query_name() {
  return "MapperPlugin";
}

extern "C" char * plugin_query_description() {
  return "Creates maps as you walk.";
}

extern "C" char * plugin_query_major() {
  return MAJOR;
}

extern "C" char * plugin_query_minor() {
  return MINOR;
}

MapperPlugin::MapperPlugin() {
  version = 0.1;
  name = strdup("MapperPlugin");
  phandler->registerPlugin(this, VERSION);
  mapperList = new List();
  mapper = new Mapper();
}

MapperPlugin::~MapperPlugin() {

}

void MapperPlugin::input(Connection * conn, char * in) {

  char cmd[1024];
  cmd[0] = '\0';

  if (!strncasecmp("mapper save", in, strlen("mapper save"))) {
    mapper->save();
    *in = '\0';
    return;
  }

  char * pc = strchr(in, ' ');

  if (pc)
    strncat(cmd, in, pc - in);
  else
    strcat(cmd, in);
  
  int i = 0;

  while (1) {
    if (!direction_table[i].full_name)
      break;
    if (!strcmp(cmd, direction_table[i].full_name) || !strcmp(cmd, direction_table[i].abbreviated_name)) { // Command match

      // Find the list element data for this connection.
      ListElement * ele = mapperList->findEntry(conn);
      if (!ele)
	ele = mapperList->newEntry(conn, NULL);
      
      struct mapper_data * data = (struct mapper_data *)ele->getData();
      if (!data) {
	data = (struct mapper_data *)malloc(sizeof(struct mapper_data));
	memset(data, 0, sizeof(struct mapper_data));
	ele->setData(data);
      }
      
      sprintf(data->cmd, "%s", cmd);

      // Surround this command with markers so that we know we need to
      // create a new room when we get the input back.
      
      sprintf(in, "mapperstart\n%s\nmapperend\n", cmd);
      return;
    }
    i++;
  }

  // No matching command.
}

/**
 * Command to take care of the output sent back from the MUD.
 */

void MapperPlugin::output(Connection * conn, char * out) {

  const char * start_str = "'mapperstart' is not a recognised verb.  Try typing 'help'.";
  const char * end_str = "'mapperend' is not a recognised verb.  Try typing 'help'.";

  // Find the list element data for this connection.
  ListElement * ele = mapperList->findEntry(conn);
  if (!ele)
    ele = mapperList->newEntry(conn, NULL);

  struct mapper_data * data = (struct mapper_data *)ele->getData();
  if (!data) {
    data = (struct mapper_data *)malloc(sizeof(struct mapper_data));
    memset(data, 0, sizeof(struct mapper_data));
    ele->setData(data);
  }

  if (!strncmp(out, start_str, strlen(start_str))) { // start string
    data->recording = true;
    data->record_buf[0] = '\0';
    out[0] = '\0';
    printf("Started recording.\n");
    return;
  }

  if (!strncmp(out, end_str, strlen(end_str))) { // end string
    data->recording = false;
    out[0] = '\0';
    mapper->newRoom(data);
    return;
  }

  if (data->recording) {
    if (strlen(data->record_buf) + strlen(out) < MAX_BUF_LEN)
      strcat(data->record_buf, out);
    else
      printf("Record buffer overflow.\n");
  }

}

