#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include <string.h>
#include <stdlib.h>

#include "papaya/system.h"

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "Prefs.h"
#include "SystemColour.h"
#include "BaseWindow.h"

#include "mudclient.h"

#include <gdk/gdkkeysyms.h>

extern BaseWindow * mainWindow;
extern Prefs * globalPreferences;

void get_main_menu(GtkWidget *, GtkWidget **);
GtkWidget * create_drawing_area(GtkWidget * parent, char * colour, Prefs *);

GtkWidget *connection_dialog_port;
GtkWidget *connection_dialog_host;

GtkWidget*
create_connection_dialog ()
{
  GtkWidget *connection_dialog;
  GtkWidget *dialog_vbox1;
  GtkWidget *table2;
  GtkWidget *table3;
  GtkWidget *label5;
  GtkWidget *label6;
  GtkWidget *label4;
  GtkWidget *dialog_action_area1;
  GtkWidget *hbuttonbox1;
  GtkWidget *connect_dialog_connect_button;
  GtkWidget *connect_dialog_cancel_button;

  connection_dialog = gtk_dialog_new ();
  g_object_set_data(G_OBJECT(connection_dialog), "connection_dialog", connection_dialog);
  gtk_window_set_title (GTK_WINDOW (connection_dialog), "Connect to a MUD");
  gtk_window_set_resizable(GTK_WINDOW(connection_dialog), false);

  dialog_vbox1 = GTK_DIALOG (connection_dialog)->vbox;
  gtk_widget_show (dialog_vbox1);

  table2 = gtk_table_new (2, 1, FALSE);
  gtk_widget_show (table2);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), table2, TRUE, TRUE, 5);

  table3 = gtk_table_new (2, 2, FALSE);
  gtk_widget_show (table3);
  gtk_table_attach (GTK_TABLE (table2), table3, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_table_set_row_spacings (GTK_TABLE (table3), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table3), 4);

  label5 = gtk_label_new (_("Host"));
  gtk_widget_show (label5);
  gtk_table_attach (GTK_TABLE (table3), label5, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label5), GTK_JUSTIFY_RIGHT);
  gtk_misc_set_alignment (GTK_MISC (label5), 7.45058e-09, 0.5);
  gtk_misc_set_padding (GTK_MISC (label5), 6, 0);

  label6 = gtk_label_new (_("Port"));
  gtk_widget_show (label6);
  gtk_table_attach (GTK_TABLE (table3), label6, 0, 1, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label6), GTK_JUSTIFY_RIGHT);
  gtk_misc_set_alignment (GTK_MISC (label6), 7.45058e-09, 0.5);

  connection_dialog_port = gtk_entry_new ();
  gtk_widget_show (connection_dialog_port);
  gtk_table_attach (GTK_TABLE (table3), connection_dialog_port, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 0);
  g_signal_connect_data(G_OBJECT(connection_dialog_port), "activate",
						GTK_SIGNAL_FUNC(on_connection_dialog_port_activate), NULL,
						NULL, (GConnectFlags)0);

  connection_dialog_host = gtk_entry_new ();
  gtk_widget_show (connection_dialog_host);
  gtk_table_attach (GTK_TABLE (table3), connection_dialog_host, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 0);

  label4 = gtk_label_new (_("Connect to which host and port?"));
  gtk_widget_show (label4);
  gtk_table_attach (GTK_TABLE (table2), label4, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 7);
  gtk_label_set_justify (GTK_LABEL (label4), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label4), 0.09, 0.5);

  dialog_action_area1 = GTK_DIALOG (connection_dialog)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_container_set_border_width (GTK_CONTAINER (dialog_action_area1), 10);

  hbuttonbox1 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox1);
  gtk_box_pack_end (GTK_BOX (dialog_action_area1), hbuttonbox1, FALSE, FALSE, 6);

  connect_dialog_cancel_button = gtk_button_new_from_stock(GTK_STOCK_CANCEL);
  g_object_set_data (G_OBJECT(connection_dialog), "connect_dialog_cancel_button", connect_dialog_cancel_button);
  gtk_widget_show (connect_dialog_cancel_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), connect_dialog_cancel_button);
  GTK_WIDGET_SET_FLAGS (connect_dialog_cancel_button, GTK_CAN_DEFAULT);

  connect_dialog_connect_button = gtk_button_new_from_stock(GTK_STOCK_OK);
  g_object_set_data(G_OBJECT(connection_dialog), "connect_dialog_connect_button", connect_dialog_connect_button);
  gtk_widget_show (connect_dialog_connect_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), connect_dialog_connect_button);
  GTK_WIDGET_SET_FLAGS (connect_dialog_connect_button, GTK_CAN_DEFAULT);

  g_signal_connect_data (G_OBJECT (connect_dialog_connect_button), "clicked",
                      GTK_SIGNAL_FUNC (on_connect_dialog_connect_button_clicked),
                      NULL, NULL, (GConnectFlags)0);
  g_signal_connect_data (G_OBJECT (connect_dialog_cancel_button), "clicked",
                      GTK_SIGNAL_FUNC (on_connect_dialog_cancel_button_clicked),
                      NULL, NULL, (GConnectFlags)0);
  g_signal_connect_data (G_OBJECT (connection_dialog), "delete_event",
					  GTK_SIGNAL_FUNC (on_connect_dialog_delete_event),
					  NULL, NULL, (GConnectFlags)0);

  return connection_dialog;
}
