#include "ConnectionPreference.h"
#include "mudclient.h"

#include <gmodule.h>

extern PreferenceHandler * preferenceHandler;
static ConnectionPreference * connectionPreference;

ConnectionPreference::ConnectionPreference() {
  xml = NULL;
  connectionPreference = this;

  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("SendKeepalive", "keepalive_checkbutton", WidgetToggle));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("SendKeepaliveText", "keepalive_entry", WidgetEntry));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("SendKeepaliveTimer", "keepalive_spinner", WidgetSpinbutton));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("ConnectionAutoReconnect", "autoreconnect_checkbutton", WidgetToggle));

}

ConnectionPreference::~ConnectionPreference() {
  connectionPreference = NULL;
  if (xml)
    g_object_unref(xml);
}

GtkWidget * ConnectionPreference::getWidget() {
  char buf[1024];
  snprintf(buf, 1024, "%s/share/papaya/connectionpreferences.glade", getPrefix());
  
  if (xml) {
    GtkWidget * vbox = glade_xml_get_widget(xml, "vbox");
    return vbox;
  }

  xml = glade_xml_new(buf, "vbox", NULL);
  glade_xml_signal_autoconnect(xml);
  GtkWidget * vbox = glade_xml_get_widget(xml, "vbox");
  gtk_widget_show(vbox);
  return vbox;
}

void ConnectionPreference::destroyWidget() {
  if (xml)
    g_object_unref(xml);
  xml = NULL;
}

Category * ConnectionPreference::getCategories() {
  return (Category *)connection_categories;
}

void ConnectionPreference::setKeepaliveState(bool state) {
  gtk_widget_set_sensitive(glade_xml_get_widget(xml, "keepalive_entry"), state);
  gtk_widget_set_sensitive(glade_xml_get_widget(xml, "keepalive_spinner"), state);
  gtk_widget_set_sensitive(glade_xml_get_widget(xml, "label2"), state);
  gtk_widget_set_sensitive(glade_xml_get_widget(xml, "label1"), state);

}

extern "C" G_MODULE_EXPORT gint on_keepalive_checkbutton_toggled(GtkWidget * widget, gpointer data) {
  connectionPreference->setKeepaliveState(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  return 1;
}
