#include "ColourPreference.h"
#include "mudclient.h"

#include <gmodule.h>

extern PreferenceHandler * preferenceHandler;
static ColourPreference * colourPreference;

ColourPreference::ColourPreference() {
  xml = NULL;
  colourPreference = this;
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("EnableColour", "enable_colour_checkbutton", WidgetToggle));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("DefaultForegroundColour", "foreground_optionmenu", WidgetOptionmenu));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("DefaultBackgroundColour", "background_optionmenu", WidgetOptionmenu));


  // All other preferences have to be handled individually.

}

ColourPreference::~ColourPreference() {
  colourPreference = NULL;
  if (xml)
    g_object_unref(xml);
}

GtkWidget * ColourPreference::getWidget() {
  char buf[1024];
  snprintf(buf, 1024, "%s/share/papaya/colourpreferences.glade", getPrefix());
  
  if (xml) {
    GtkWidget * vbox = glade_xml_get_widget(xml, "vbox");
    return vbox;
  }

  xml = glade_xml_new(buf, "vbox", NULL);
  glade_xml_signal_autoconnect(xml);
  GtkWidget * vbox = glade_xml_get_widget(xml, "vbox");
  gtk_widget_show(vbox);

  white_editor = new ColourEditor(0, 0, 0);
  red_editor = new ColourEditor(0, 0, 0);
  green_editor = new ColourEditor(0, 0, 0);
  blue_editor = new ColourEditor(0, 0, 0);
  yellow_editor = new ColourEditor(0, 0, 0);
  magenta_editor = new ColourEditor(0, 0, 0);
  cyan_editor = new ColourEditor(0, 0, 0);
  black_editor = new ColourEditor(0, 0, 0);

  white_bold_editor = new ColourEditor(0, 0, 0);
  red_bold_editor = new ColourEditor(0, 0, 0);
  green_bold_editor = new ColourEditor(0, 0, 0);
  blue_bold_editor = new ColourEditor(0, 0, 0);
  yellow_bold_editor = new ColourEditor(0, 0, 0);
  magenta_bold_editor = new ColourEditor(0, 0, 0);
  cyan_bold_editor = new ColourEditor(0, 0, 0);
  black_bold_editor = new ColourEditor(0, 0, 0);

  GtkWidget * table = glade_xml_get_widget(xml, "text_colours_table");
  gtk_table_attach(GTK_TABLE(table),white_editor->getPreview(),
		   1, 2, 1, 2,
		   (GtkAttachOptions) (GTK_FILL|GTK_EXPAND),
		   (GtkAttachOptions) 0, 0, 0);

  gtk_table_attach(GTK_TABLE(table),red_editor->getPreview(),
		   2, 3, 1, 2,
		   (GtkAttachOptions) (GTK_FILL|GTK_EXPAND),
		   (GtkAttachOptions) 0, 0, 0);

  gtk_table_attach(GTK_TABLE(table),green_editor->getPreview(),
		   3, 4, 1, 2,
		   (GtkAttachOptions) (GTK_FILL|GTK_EXPAND),
		   (GtkAttachOptions) 0, 0, 0);

  gtk_table_attach(GTK_TABLE(table),blue_editor->getPreview(),
		   4, 5, 1, 2,
		   (GtkAttachOptions) (GTK_FILL|GTK_EXPAND),
		   (GtkAttachOptions) 0, 0, 0);

  gtk_table_attach(GTK_TABLE(table),yellow_editor->getPreview(),
		   5, 6, 1, 2,
		   (GtkAttachOptions) (GTK_FILL|GTK_EXPAND),
		   (GtkAttachOptions) 0, 0, 0);

  gtk_table_attach(GTK_TABLE(table),magenta_editor->getPreview(),
		   6, 7, 1, 2,
		   (GtkAttachOptions) (GTK_FILL|GTK_EXPAND),
		   (GtkAttachOptions) 0, 0, 0);

  gtk_table_attach(GTK_TABLE(table),cyan_editor->getPreview(),
		   7, 8, 1, 2,
		   (GtkAttachOptions) (GTK_FILL|GTK_EXPAND),
		   (GtkAttachOptions) 0, 0, 0);

  gtk_table_attach(GTK_TABLE(table),black_editor->getPreview(),
		   8, 9, 1, 2,
		   (GtkAttachOptions) (GTK_FILL|GTK_EXPAND),
		   (GtkAttachOptions) 0, 0, 0);


  gtk_table_attach(GTK_TABLE(table),white_bold_editor->getPreview(),
		   1, 2, 2, 3,
		   (GtkAttachOptions) (GTK_FILL|GTK_EXPAND),
		   (GtkAttachOptions) 0, 0, 0);

  gtk_table_attach(GTK_TABLE(table),red_bold_editor->getPreview(),
		   2, 3, 2, 3,
		   (GtkAttachOptions) (GTK_FILL|GTK_EXPAND),
		   (GtkAttachOptions) 0, 0, 0);

  gtk_table_attach(GTK_TABLE(table),green_bold_editor->getPreview(),
		   3, 4, 2, 3,
		   (GtkAttachOptions) (GTK_FILL|GTK_EXPAND),
		   (GtkAttachOptions) 0, 0, 0);

  gtk_table_attach(GTK_TABLE(table),blue_bold_editor->getPreview(),
		   4, 5, 2, 3,
		   (GtkAttachOptions) (GTK_FILL|GTK_EXPAND),
		   (GtkAttachOptions) 0, 0, 0);

  gtk_table_attach(GTK_TABLE(table),yellow_bold_editor->getPreview(),
		   5, 6, 2, 3,
		   (GtkAttachOptions) (GTK_FILL|GTK_EXPAND),
		   (GtkAttachOptions) 0, 0, 0);

  gtk_table_attach(GTK_TABLE(table),magenta_bold_editor->getPreview(),
		   6, 7, 2, 3,
		   (GtkAttachOptions) (GTK_FILL|GTK_EXPAND),
		   (GtkAttachOptions) 0, 0, 0);

  gtk_table_attach(GTK_TABLE(table),cyan_bold_editor->getPreview(),
		   7, 8, 2, 3,
		   (GtkAttachOptions) (GTK_FILL|GTK_EXPAND),
		   (GtkAttachOptions) 0, 0, 0);

  gtk_table_attach(GTK_TABLE(table),black_bold_editor->getPreview(),
		   8, 9, 2, 3,
		   (GtkAttachOptions) (GTK_FILL|GTK_EXPAND),
		   (GtkAttachOptions) 0, 0, 0);

  setColourState(false);

  table = glade_xml_get_widget(xml, "window_colours_table");
  background_editor = new ColourEditor(0, 0, 0);
  gtk_table_attach(GTK_TABLE(table), background_editor->getPreview(),
		   1, 2, 2, 3,
		   (GtkAttachOptions) (GTK_FILL|GTK_EXPAND),
		   (GtkAttachOptions) 0, 0, 0);

  return vbox;
}

void ColourPreference::destroyWidget() {
  if (xml)
    g_object_unref(xml);
  xml = NULL;
}

Category * ColourPreference::getCategories() {
  return (Category *)colour_categories;
}

char * RGBToString(gushort red, gushort green, gushort blue) {
  static char buf[1024];
  snprintf(buf, 1024, "%d %d %d", red, green, blue);
  return buf;
}

void StringToRGB(char * string, gushort * red, gushort * green, gushort * blue) {
  if (string) {
    //    char * new_str = strdup(string);
    sscanf(string, "%hd %hd %hd", red, green, blue);
    //    free(new_str);
  }
}

void ColourPreference::loadPreferences(Prefs * prefs) {

  Preference::loadPreferences(prefs);

  gushort red = 0, green = 0, blue = 0;

  StringToRGB(prefs->getPreference("White_RGB"), &red, &green, &blue);
  white_editor->setRGB(red, green, blue);
  StringToRGB(prefs->getPreference("Red_RGB"), &red, &green, &blue);
  red_editor->setRGB(red, green, blue);
  StringToRGB(prefs->getPreference("Green_RGB"), &red, &green, &blue);
  green_editor->setRGB(red, green, blue);
  StringToRGB(prefs->getPreference("Blue_RGB"), &red, &green, &blue);
  blue_editor->setRGB(red, green, blue);
  StringToRGB(prefs->getPreference("Yellow_RGB"), &red, &green, &blue);
  yellow_editor->setRGB(red, green, blue);
  StringToRGB(prefs->getPreference("Magenta_RGB"), &red, &green, &blue);
  magenta_editor->setRGB(red, green, blue);
  StringToRGB(prefs->getPreference("Cyan_RGB"), &red, &green, &blue);
  cyan_editor->setRGB(red, green, blue);
  StringToRGB(prefs->getPreference("Black_RGB"), &red, &green, &blue);
  black_editor->setRGB(red, green, blue);

  StringToRGB(prefs->getPreference("White_Bold_RGB"), &red, &green, &blue);
  white_bold_editor->setRGB(red, green, blue);
  StringToRGB(prefs->getPreference("Red_Bold_RGB"), &red, &green, &blue);
  red_bold_editor->setRGB(red, green, blue);
  StringToRGB(prefs->getPreference("Green_Bold_RGB"), &red, &green, &blue);
  green_bold_editor->setRGB(red, green, blue);
  StringToRGB(prefs->getPreference("Blue_Bold_RGB"), &red, &green, &blue);
  blue_bold_editor->setRGB(red, green, blue);
  StringToRGB(prefs->getPreference("Yellow_Bold_RGB"), &red, &green, &blue);
  yellow_bold_editor->setRGB(red, green, blue);
  StringToRGB(prefs->getPreference("Magenta_Bold_RGB"), &red, &green, &blue);
  magenta_bold_editor->setRGB(red, green, blue);
  StringToRGB(prefs->getPreference("Cyan_Bold_RGB"), &red, &green, &blue);
  cyan_bold_editor->setRGB(red, green, blue);
  StringToRGB(prefs->getPreference("Black_Bold_RGB"), &red, &green, &blue);
  black_bold_editor->setRGB(red, green, blue);

  StringToRGB(prefs->getPreference("Background_RGB"), &red, &green, &blue);
  background_editor->setRGB(red, green, blue);

}

void ColourPreference::applyPreferences(Prefs * prefs) {

  Preference::applyPreferences(prefs);

  prefs->setPreference("White_RGB", RGBToString(white_editor->getRed(), white_editor->getGreen(), white_editor->getBlue()));
  prefs->setPreference("Red_RGB", RGBToString(red_editor->getRed(), red_editor->getGreen(), red_editor->getBlue()));
  prefs->setPreference("Green_RGB", RGBToString(green_editor->getRed(), green_editor->getGreen(), green_editor->getBlue()));
  prefs->setPreference("Blue_RGB", RGBToString(blue_editor->getRed(), blue_editor->getGreen(), blue_editor->getBlue()));
  prefs->setPreference("Yellow_RGB", RGBToString(yellow_editor->getRed(), yellow_editor->getGreen(), yellow_editor->getBlue()));
  prefs->setPreference("Magenta_RGB", RGBToString(magenta_editor->getRed(), magenta_editor->getGreen(), magenta_editor->getBlue()));
  prefs->setPreference("Cyan_RGB", RGBToString(cyan_editor->getRed(), cyan_editor->getGreen(), cyan_editor->getBlue()));
  prefs->setPreference("Black_RGB", RGBToString(black_editor->getRed(), black_editor->getGreen(), black_editor->getBlue()));

  prefs->setPreference("White_Bold_RGB", RGBToString(white_bold_editor->getRed(), white_bold_editor->getGreen(), white_bold_editor->getBlue()));
  prefs->setPreference("Red_Bold_RGB", RGBToString(red_bold_editor->getRed(), red_bold_editor->getGreen(), red_bold_editor->getBlue()));
  prefs->setPreference("Green_Bold_RGB", RGBToString(green_bold_editor->getRed(), green_bold_editor->getGreen(), green_bold_editor->getBlue()));
  prefs->setPreference("Blue_Bold_RGB", RGBToString(blue_bold_editor->getRed(), blue_bold_editor->getGreen(), blue_bold_editor->getBlue()));
  prefs->setPreference("Yellow_Bold_RGB", RGBToString(yellow_bold_editor->getRed(), yellow_bold_editor->getGreen(), yellow_bold_editor->getBlue()));
  prefs->setPreference("Magenta_Bold_RGB", RGBToString(magenta_bold_editor->getRed(), magenta_bold_editor->getGreen(), magenta_bold_editor->getBlue()));
  prefs->setPreference("Cyan_Bold_RGB", RGBToString(cyan_bold_editor->getRed(), cyan_bold_editor->getGreen(), cyan_bold_editor->getBlue()));
  prefs->setPreference("Black_Bold_RGB", RGBToString(black_bold_editor->getRed(), black_bold_editor->getGreen(), black_bold_editor->getBlue()));

  prefs->setPreference("Background_RGB", RGBToString(background_editor->getRed(), background_editor->getGreen(), background_editor->getBlue()));

}

void ColourPreference::setColourState(bool state) {

  white_editor->setSensitive(state);
  red_editor->setSensitive(state);
  green_editor->setSensitive(state);
  blue_editor->setSensitive(state);
  yellow_editor->setSensitive(state);
  magenta_editor->setSensitive(state);
  cyan_editor->setSensitive(state);
  black_editor->setSensitive(state);
  white_bold_editor->setSensitive(state);
  red_bold_editor->setSensitive(state);
  green_bold_editor->setSensitive(state);
  blue_bold_editor->setSensitive(state);
  yellow_bold_editor->setSensitive(state);
  magenta_bold_editor->setSensitive(state);
  cyan_bold_editor->setSensitive(state);
  black_bold_editor->setSensitive(state);

}

extern "C" G_MODULE_EXPORT gint on_enable_colour_checkbutton_toggled(GtkWidget * widget, gpointer data) {
  colourPreference->setColourState(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  return 1;
}

