#ifndef INCLUDE_FADE_H
#define INCLUDE_FADE_H

#include "papaya/ColourEditor.h"

/*
 * See doc/Fade.README for documentation.
 */

class Fade {

  // Event handlers requiring an in-depth knowledge of the widget
  friend gboolean fade_preview_expose(GtkWidget * widget,
                                      GdkEventExpose * event, gpointer data);
  friend gboolean fade_preview_conf(GtkWidget * widget,
                                    GdkEventConfigure * event, gpointer data);
  friend gboolean fade_swap_three(GtkWidget *widget, gpointer data);
  friend void ce_change_callback(ColourEditor *ce, gpointer data);

  public:
    Fade(gboolean three, char * min, char * mid, char *max);
    ~Fade();
    void reset(gboolean three, char * min, char * mid, char *max);
    void onPrefsOk();
    void onPrefsApply();
    void onPrefsCancel();
    GdkColor * getShade(int level, int max_level);
    GtkWidget * getEditor();
    char * stringMinColour();
    char * stringMidColour();
    char * stringMaxColour();
    char * stringUseThree();

  protected:
    gboolean use_three;
    gboolean update_preview;
    GdkColor minimum;
    GdkColor middle;
    GdkColor maximum;
    GdkColor shade;
    GdkPixmap * pixmap;
    GtkWidget * editor_toplevel;
    GtkWidget * preview;
    GtkWidget * three_choice;
    ColourEditor * min_edit;
    ColourEditor * mid_edit;
    ColourEditor * max_edit;

    void finalise_widgets();
    gboolean parseColour(GdkColor * colour, char * rgb);
    GdkColor * getShade(gboolean three, GdkColor * smin, GdkColor * smid,
                        GdkColor * smax, int level, int max_level);
    void copyColoursFromEditors(GdkColor * min, GdkColor * mid,
                                GdkColor * max);
    void updatePreview();
};

#endif
