/*
**  POP3Store.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _Pantomime_H_POP3Store
#define _Pantomime_H_POP3Store

#include <Pantomime/Connection.h>
#include <Pantomime/Service.h>
#include <Pantomime/Store.h>

#import <Foundation/NSObject.h>
#import <Foundation/NSString.h>

@class POP3Folder;

@interface POP3Store : NSObject <Service, Store>
{
  // ivars
  NSString *name, *timestamp, *username;
  int port;

  POP3Folder *pop3Folder;

  id<Connection> tcpConnection;

  BOOL messagesHaveBeenPrefetched;
}

- (POP3Folder *) folderForName: (NSString *) theName
                      prefetch: (BOOL) aBOOL;

- (BOOL) responseFromServerIsValid: (NSString **) theResponse;

- (NSString *) timestamp;

@end


//
// Private methods
//
@interface POP3Store (Private)

- (BOOL) _APOPAuthenticate: (NSString*) theUsername
                  password: (NSString*) thePassword;

- (BOOL) _postInit;

@end

#endif // _Pantomime_H_POP3Store
