/*
**  Sendmail.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#import <Pantomime/Sendmail.h>

#import <Pantomime/Constants.h>

@implementation Sendmail

- (id) initWithPathToSendmail: (NSString *) thePath;
{
  self = [super init];

  [self setPathToSendmail: thePath];

  return self;
}

- (void) dealloc
{
  RELEASE(pathToSendmail);

  [super dealloc];
}

- (NSString *) pathToSendmail
{
  return pathToSendmail;
}

- (void) setPathToSendmail: (NSString *) thePath
{
  RETAIN(thePath);
  RELEASE(pathToSendmail);
  pathToSendmail = thePath;
}

- (BOOL) sendMessage: (Message *) theMessage
{
  return [self sendMessageFromRawSource: [theMessage dataUsingSendingMode: SEND_USING_SENDMAIL]];
}

- (BOOL) sendMessageFromRawSource: (NSData *) theData
{
  if ([self pathToSendmail] == nil)
    {
      NSLog(@"-[Sendmail sendMessageFromRawSource:]: The mailer program was not specified");
      return NO;
    }
  else
    {
      /* TODO: Use gnustep-base's NSPipe which is more portable */
      FILE *stream;
      
      stream = popen ([[self pathToSendmail] cString], "w");
      fwrite ([theData bytes],[theData length],1,stream);
      pclose (stream);
    }

  return YES;
}

@end
