/*
**  IMAPCacheObject.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#import <Pantomime/IMAPCacheObject.h>

#import <Pantomime/Constants.h>
#import <Pantomime/Message.h>

@implementation IMAPCacheObject

- (id) init
{
  [super init];

  return self;
}


- (id) initWithUID: (int) theUID
	   message: (Message *) theMessage
{
  [self init];
 
  [self setUID: theUID];
  [self setMessage: theMessage];
  
  return self;
}

- (void) dealloc
{
  RELEASE(message);

  [super dealloc];
}


//
// NSCoding protocol
//
- (void) encodeWithCoder: (NSCoder *) theCoder
{
  [theCoder encodeObject: [NSNumber numberWithInt: [self uid]] ];
  [theCoder encodeObject: [self message] ];
}

- (id) initWithCoder: (NSCoder *) theCoder
{
  self = [super init];

  [self setUID: [[theCoder decodeObject] intValue] ];
  [self setMessage: [theCoder decodeObject] ];

  return self;
}

- (void) setUID: (int) theUID
{
  uid = theUID;
}

- (int) uid
{
  return uid;
}


- (void) setMessage: (Message *) theMessage
{
  RETAIN(theMessage);
  TEST_RELEASE(message);
  message = theMessage;
}

- (Message *) message
{
  return message;
}

@end
