//
// C++ Interface: runcommand
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef __RUNCOMMAND_H_2004_05_12
#define __RUNCOMMAND_H_2004_05_12

#include <qobject.h>

class QString;

namespace NApplication {

/** @brief Interface to execute a console application.
  *
  * After calling start the object will display the output of the started command to the user 
  * in an independant window. After exiting the signal processExited() will be emitted.\n
  * The command executed will consist of the list of arguments, where the first 
  * argument is the application itself. Arguments can be added via addArgument().
  * @author Benjamin Mesing
  */
class RunCommand : public QObject
{
	Q_OBJECT
public:
	RunCommand();
	virtual ~RunCommand();
	/** Adds a new argument to the command to be executed. */
	virtual void addArgument(const QString& arg)=0;
	/** @brief Execute the command, returning immidiately.
	  *
	  * The application will be launched and processed in the background. The control is 
	  * returned immidiately.
	  * @returns if the command could be executed
pa	  */
	virtual bool start()=0;
	/** @returns true if the process exited successful, i.e. was not aborted and returned an
	  * exit state of 0. */
	virtual bool processExitedSuccessful() const=0;
signals:
	/** This signal will be emitted, when the application requested has finished. */
	void processExited();
	/** This signal will be emitted, when RunCommand class is completly ready, this might happen long after
	  * the processExited signal was emitted (e.g. if the window has to be closed manually).\n 
	  * The quit signal is quaranteed to be emitted after the processExited() signal. 
	  * @note this signal is delete safe, i.e. you might delete the object as a reaction to it as the
	  * emitting function does not access its members after this. */
	void quit();
private:
	RunCommand(RunCommand& rc);
};

};

#endif	//  __RUNCOMMAND_H_2004_05_12
