//
// C++ Implementation: cacheaccess
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <iostream>

#include <apt-pkg/error.h>

#include "cacheaccess.h"

using namespace std;

// _config is a global Config* provided by the apt library

CacheAccess::CacheAccess()
{
	_config->Set("quiet",0);
	_config->Set("help",false); 

	if (pkgInitConfig(*_config) == false ||
			pkgInitSystem(*_config,_system) == false)
		cerr << "Error initializing apt-pkg library"<<endl;

	// Open the cache file
	
	_pSrcList = new pkgSourceList;
	_pSrcList->ReadMainList();

	// Generate it and map it
	OpProgress Prog;
	pkgMakeStatusCache(*_pSrcList,Prog,&_pMap,true);

	if (_error->PendingError() == true)
		cerr << "Error after pkgMakeStatusCache"<<endl;

	_pCache = new pkgCache(_pMap);

	if (_error->PendingError() == true)
		cerr << "Error after creating new Cache"<<endl;
}

CacheAccess::~CacheAccess()
{
	/// @todo do we have to delete _pMap here?
	delete _pSrcList;
	delete _pCache;
}

