/**
  @file state.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2006 Nokia Corporation. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

*/
#ifndef _STATE_H_
#define _STATE_H_

#include "btcond-hci.h"

/** Connection status */
typedef enum {
        CONN_STATUS_CONNECTED,    /**< Active connection to device */
        CONN_STATUS_DISCONNECTED, /**< Device is disconnected */
        CONN_STATUS_DISABLED      /**< BT disabled */
} ConnStatus;

/** Query device connection status
 * @param bda BT address or NULL (for any connection)
 * @returns Device connection status
 */
ConnStatus connection_status(const gchar *bda);

#ifdef USE_MCE
void update_cover_state(void);
void update_inactive_state(gboolean inactive);
#endif

void update_dev_state(int dev, gboolean down);

void update_state(con_evt_t *event);

const gchar *get_handle_bda(uint16_t handle);

gboolean handle_is_connected(uint16_t handle);

#endif /* _STATE_H_ */
