/**
  @file dbus.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2006 Nokia Corporation. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

*/
#ifndef _DBUS_H_
#define _DBUS_H_

#include <dbus/dbus.h>

/** Connect to the system D-Bus
 * @returns TRUE on success, FALSE on failure
 */
gboolean setup_dbus_connection(const char *name,
                          void (*handler_init)(DBusConnection *connection));

/** Disconnect from the system D-Bus */
void close_dbus_connection(void);

DBusConnection *get_dbus_connection(void);

#endif /* _DBUS_H_ */
