/**
  @file btcond-rfcomm.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2006 Nokia Corporation. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

*/
#ifndef _BTCOND_RFCOMM_H_
#define _BTCOND_RFCOMM_H_

#include <stdint.h>

#define ROLE_MASTER     0x00
#define ROLE_SLAVE      0x01
#define ROLE_ANY        0xFF

typedef struct {
    uint8_t  role;
    uint8_t  min_klen;
    gboolean auth;
    gboolean encrypt;
} rfcomm_params;

typedef void (*rfcomm_connect_cb)(gint dev_id, GIOChannel *io, GError *err,
                                  gpointer user_data);

/** Bind an RFCOMM device node to specific RFCOMM channel on a remote device
 * @param bda     Remote BT device to bind to
 * @param ch      Channel to bind
 * @param node    Return value for device node number (/dev/rfcommN)
 * @returns TRUE on success, FALSE on failure
 */
gboolean rfcomm_bind(const char *bda, uint8_t ch, int *node, GError **err);

gboolean rfcomm_release(int dev_num, GError **err);

gboolean rfcomm_connect(const char *bda, uint8_t ch, rfcomm_params *params,
                        rfcomm_connect_cb cb, gpointer user_data, GError **err);

gboolean rfcomm_cancel_connect(const char *bda, uint8_t ch, GError **err);

gboolean rfcomm_disconnect(GIOChannel *sock, int dev_num, GError **err);

gboolean rfcomm_init(GError **err);


#endif /* _BTCOND_RFCOMM_H_ */
