
/*****************************************************************************
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, visit www.shmoo.com/osiris for
**  details.
**
*****************************************************************************/

/*****************************************************************************
**
**  File:    log_brief.c
**  Date:    August 18, 2002
**
**  Author:  Brian Wotring
**
**  Purpose: structure representing a log file that can be
**           transported in a message.
**
******************************************************************************/

#include "libosirism.h"

void wrap_log_brief( OSI_LOG_BRIEF *log )
{
    if( log != NULL )
    {
        log->timestamp = OSI_HTONLL( log->timestamp );
    }
}

void unwrap_log_brief( OSI_LOG_BRIEF *log )
{
    if( log != NULL )
    {
        log->timestamp = OSI_NTOHLL( log->timestamp );
    }
}

