/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols.pbcast;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Hashtable;
import org.javagroups.Header;
import org.javagroups.protocols.pbcast.Gossip;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PbcastHeader
extends Header {
    public static final int MCAST_MSG = 0;
    public static final int GOSSIP = 1;
    public static final int XMIT_REQ = 2;
    public static final int XMIT_RSP = 3;
    public static final int NOT_MEMBER = 4;
    int type;
    long seqno;
    Gossip gossip;
    Hashtable xmit_reqs;

    public long getSeqno() {
        return this.seqno;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[PBCAST(" + PbcastHeader.type2String(this.type) + "), seqno=" + this.seqno);
        if (this.gossip != null) {
            sb.append(", gossip=" + this.gossip);
        }
        sb.append("]");
        return sb.toString();
    }

    public long size() {
        return 500L;
    }

    public static String type2String(int t) {
        switch (t) {
            case 0: {
                return "MCAST_MSG";
            }
            case 1: {
                return "GOSSIP";
            }
            case 2: {
                return "XMIT_REQ";
            }
            case 3: {
                return "XMIT_RSP";
            }
            case 4: {
                return "NOT_MEMBER";
            }
        }
        return "UNKNOWN";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.type);
        out.writeLong(this.seqno);
        out.writeObject(this.gossip);
        out.writeObject(this.xmit_reqs);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readInt();
        this.seqno = in.readLong();
        this.gossip = (Gossip)in.readObject();
        this.xmit_reqs = (Hashtable)in.readObject();
    }

    private final /* synthetic */ void this() {
        this.type = -1;
        this.seqno = -1;
        this.gossip = null;
        this.xmit_reqs = null;
    }

    public PbcastHeader() {
        this.this();
        this.type = -1;
    }

    public PbcastHeader(int type) {
        this.this();
        this.type = type;
    }

    public PbcastHeader(int type, long seqno) {
        this.this();
        this.type = type;
        this.seqno = seqno;
    }

    public PbcastHeader(Gossip g, int type) {
        this.this();
        this.type = type;
        this.gossip = g;
    }

    public PbcastHeader(Gossip g, int type, long seqno) {
        this.this();
        this.type = type;
        this.seqno = seqno;
        this.gossip = g;
    }
}

