/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols.pbcast;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.javagroups.Header;
import org.javagroups.util.Range;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NakAckHeader
extends Header {
    public static final int MSG = 1;
    public static final int XMIT_REQ = 2;
    public static final int XMIT_RSP = 3;
    int type;
    long seqno;
    Range range;

    public long size() {
        return 512L;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.type);
        out.writeLong(this.seqno);
        if (this.range != null) {
            out.writeBoolean(true);
            this.range.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readInt();
        this.seqno = in.readLong();
        boolean read_range = in.readBoolean();
        if (read_range) {
            this.range = new Range();
            this.range.readExternal(in);
        }
    }

    public NakAckHeader copy() {
        NakAckHeader ret = new NakAckHeader(this.type, this.seqno);
        ret.range = this.range;
        return ret;
    }

    public static String type2Str(int t) {
        switch (t) {
            case 1: {
                return "MSG";
            }
            case 2: {
                return "XMIT_REQ";
            }
            case 3: {
                return "XMIT_RSP";
            }
        }
        return "<undefined>";
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("[NAKACK: ").append(NakAckHeader.type2Str(this.type)).append(", seqno=").append(this.seqno);
        ret.append(", range=").append(this.range);
        ret.append("]");
        return ret.toString();
    }

    private final /* synthetic */ void this() {
        this.type = 0;
        this.seqno = -1;
        this.range = null;
    }

    public NakAckHeader() {
        this.this();
    }

    public NakAckHeader(int type, long seqno) {
        this.this();
        this.type = type;
        this.seqno = seqno;
    }

    public NakAckHeader(int type, long low, long high) {
        this.this();
        this.type = type;
        this.range = new Range(low, high);
    }
}

