/*
 * Copyright (c) 2012 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR(S) DISCLAIM ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL AUTHORS BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __MERGESTATE_H__
#define __MERGESTATE_H__

#include <stdint.h>
#include <time.h>

#include <utility>
#include <string>

#include <oriutil/objecthash.h>

class MergeState
{
public:
    MergeState();
    ~MergeState();
    void setParents(ObjectHash p1, ObjectHash p2 = ObjectHash());
    std::pair<ObjectHash, ObjectHash> getParents() const;
    std::string getBlob() const;
    void fromBlob(const std::string &blob);

    ObjectHash hash() const; // TODO: cache this
private:
    std::pair<ObjectHash, ObjectHash> parents;
};

#endif /* __MERGESTATE_H__ */

