/*
 * part.h
 *
 * 
 * Author: 
 *  Richard Hult <rhult@hem.passagen.se>
 * 
 *  http://www.dtek.chalmers.se/~d4hult/oregano/ 
 * 
 * Copyright (C) 1999,2000  Richard Hult 
 * 
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the 
 * License, or (at your option) any later version. 
 * 
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __PART_H
#define __PART_H

#include <gnome.h>
#include "sheet-pos.h"
#include "clipboard.h"
#include "load-common.h"

#define TYPE_PART            (part_get_type ())
#define PART(obj)            (GTK_CHECK_CAST ((obj), TYPE_PART, Part))
#define PART_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_PART, PartClass))
#define IS_PART(obj)         (GTK_CHECK_TYPE ((obj), TYPE_PART))
#define IS_PART_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_PART))

typedef struct _Part Part;
typedef struct _PartClass PartClass;
typedef struct _Pin Pin;
typedef struct _PartPriv PartPriv;

#include "item-data.h"

struct _Pin {
	SheetPos offset;
	guint pin_nr;
	Part *part;
};

#define PIN(x) ((Pin *)(x))

struct _Part {
	ItemData parent;

	PartPriv *priv;
};

struct _PartClass
{
	ItemDataClass parent_class;
};

guint  part_get_type (void);
Part  *part_new (void);
Part  *part_new_from_library_part (LibraryPart *library_part);
int    part_get_num_pins (Part *part);
Pin   *part_get_pins (Part *part);
int    part_set_pins (Part *part, GSList *connections);
int    part_get_rotation (Part *part);
IDFlip part_get_flip (Part *part);
void   part_labels_rotate (Part *part, int rotation);

char   *part_get_property (Part *part, char *name);
GSList *part_get_properties (Part *part);
GSList *part_get_labels (Part *part);

ClipboardData *part_clipboard_dup (Part *part);

#endif
