/*
 * item-data.h
 *
 * 
 * Author: 
 *  Richard Hult <rhult@hem.passagen.se>
 * 
 *  http://www.dtek.chalmers.se/~d4hult/oregano/ 
 * 
 * Copyright (C) 1999,2000  Richard Hult 
 * 
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the 
 * License, or (at your option) any later version. 
 * 
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __ITEM_DATA_H
#define __ITEM_DATA_H

#include <gnome.h>
#include "sheet-pos.h"
#include "print.h"

#define TYPE_ITEM_DATA            (item_data_get_type ())
#define ITEM_DATA(obj)            (GTK_CHECK_CAST ((obj), TYPE_ITEM_DATA, ItemData))
#define ITEM_DATA_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_ITEM_DATA, ItemDataClass))
#define IS_ITEM_DATA(obj)         (GTK_CHECK_TYPE ((obj), TYPE_ITEM_DATA))
#define IS_ITEM_DATA_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_ITEM_DATA))

typedef struct _ItemData ItemData;
typedef struct _ItemDataClass ItemDataClass;
typedef struct _ItemDataPriv ItemDataPriv;

typedef enum {
	ID_FLIP_NONE = 0,
	ID_FLIP_HORIZ = 1 << 0,
	ID_FLIP_VERT = 1 << 1
} IDFlip;	

struct _ItemData {
	GtkObject parent;
	ItemDataPriv *priv;
};

struct _ItemDataClass
{
	GtkObjectClass parent_class;
	
	/* Signals. */
	void (*moved) (ItemData *data, SheetPos *delta);
	
	/* Methods. */
	ItemData *(*clone) (ItemData *src);
	void (*copy) (ItemData *dest, ItemData *src);
	void (*rotate) (ItemData *data, int angle, SheetPos *center);
	void (*flip) (ItemData *data, gboolean horizontal, SheetPos *center);
	void (*unreg) (ItemData *data);
	void (*reg) (ItemData *data);
	
	char* (*get_refdes_prefix) (ItemData *data);
	void (*set_property) (ItemData *data, char *property, char *value);

	void (*print) (ItemData *data, OreganoPrintContext *ctxt);
};

guint     item_data_get_type (void);
ItemData *item_data_new (void);
ItemData *item_data_clone (ItemData *src);
void      item_data_get_pos (ItemData *item_data, SheetPos *pos);
void      item_data_set_pos (ItemData *item_data, SheetPos *pos);
void      item_data_move (ItemData *item_data, SheetPos *delta);
void      item_data_get_relative_bbox (ItemData *data, SheetPos *p1, SheetPos *p2);
void      item_data_set_relative_bbox (ItemData *data, SheetPos *p1, SheetPos *p2);
void      item_data_get_absolute_bbox (ItemData *data, SheetPos *p1, SheetPos *p2);
void      item_data_list_get_absolute_bbox (GList *item_data_list, SheetPos *p1, SheetPos *p2);
void      item_data_rotate (ItemData *data, int angle, SheetPos *center);
void      item_data_flip (ItemData *data, gboolean horizontal, SheetPos *center);
gpointer  item_data_get_store (ItemData *item_data);
void      item_data_unregister (ItemData *data);
void      item_data_register (ItemData *data);
char     *item_data_get_refdes_prefix (ItemData *data);
void      item_data_set_property (ItemData *data, char *property, char *value);
void	  item_data_print (ItemData *data, OreganoPrintContext *ctxt);


#endif
