###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Apache HPSBUX00197
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835025);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "HPSBUX", value: "00197");
  script_name( "HP-UX Update for Apache HPSBUX00197");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identifiedwith HP-UX running 
  Apache that may allow a remote user to cause a Denial of Service (DoS) or 
  elevation of privilege or execution of arbitrary code. 

  Impact:
  

  Affected Software/OS:
  Apache on
  HP-UX B.11.00, B.11.04, B.11.11, B.11.20, and B.11.23 running Apache and 
  OpenView Network Node Manager (NNM) 6.01, 6.1, 6.2, 6.31 and Solaris 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00904239-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Apache");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"ApacheStrong", revision:"1.3.26.05", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HPApache", revision:"2.0.39.05", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OVPlatform.OVWWW-SRV", patch_list:['PHSS_29987'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OVPlatform.OVWWW-SRV", patch_list:['PHSS_27639'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OVPlatform.OVWWW-SRV", patch_list:['PHSS_27784'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HPOVSIP.OVSIP", patch_list:['PHSS_27547'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"ApacheStrong", revision:"1.3.26.05", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HPApache", revision:"2.0.39.05", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.20")
{

  if(ishpuxpkgvuln(pkg:"ApacheStrong", revision:"1.3.26.05", rls:"HPUX11.20"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HPApache", revision:"2.0.39.05", rls:"HPUX11.20"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OVPlatform.OVWWW-SRV", patch_list:['PHSS_27638'], rls:"HPUX11.20"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OVPlatform.OVWWW-SRV", patch_list:['PHSS_27935'], rls:"HPUX11.20"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OVPlatform.OVWWW-SRV", patch_list:['PHSS_27783'], rls:"HPUX11.20"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.04")
{

  if(ishpuxpkgvuln(pkg:"ApacheStrong", revision:"1.3.26.05", rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HPApache", revision:"2.0.39.05", rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VaultWS.WS-CORE", patch_list:['PHSS_27371', 'PHSS_27477'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VaultTS.VV-IWS", patch_list:['PHSS_27371', 'PHSS_27477'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VaultTS.VV-CORE-CMN", patch_list:['PHSS_27371', 'PHSS_27477'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VaultWS.WS-CORE", patch_list:['PHSS_27361', 'PHSS_27423'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VaultTS.VV-IWS", patch_list:['PHSS_27361', 'PHSS_27423'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VaultTS.VV-CORE-CMN", patch_list:['PHSS_27361', 'PHSS_27423'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"ApacheStrong", revision:"1.3.26.05", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HPApache", revision:"2.0.39.05", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OVPlatform.OVWWW-SRV", patch_list:['PHSS_29987'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OVPlatform.OVWWW-SRV", patch_list:['PHSS_27639'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OVPlatform.OVWWW-SRV", patch_list:['PHSS_27784'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HPOVSIP.OVSIP", patch_list:['PHSS_27547'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
