#
#VID 37a8603d-4494-11de-bea7-000c29a67389
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 37a8603d-4494-11de-bea7-000c29a67389
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64048);
 script_cve_id("CVE-2009-1755");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Ports: nsd";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   nsd
   nsd2

CVE-2009-1755
Off-by-one error in the packet_read_query_section function in packet.c
in nsd 3.2.1, and process_query_section in query.c in nsd 2.3.7,
allows remote attackers to cause a denial of service (crash) and
possibly execute arbitrary code via unspecified vectors that trigger a
buffer overflow.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.nlnetlabs.nl/publications/NSD_vulnerability_announcement.html
http://www.vuxml.org/freebsd/37a8603d-4494-11de-bea7-000c29a67389.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: nsd";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"nsd");
if(!isnull(bver) && revcomp(a:bver, b:"3.2.2")<0) {
    security_note(0, data:"Package nsd version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"nsd2");
if(!isnull(bver) && revcomp(a:bver, b:"2.3.7_1")<0) {
    security_note(0, data:"Package nsd2 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
