/* OpenVAS-Client
*
* Description: Utilities for parsing
*
* Authors:
* Joey Schulze <joey@infodrom.org>
*
* Copyright:
* Copyright (C) 2009 Intevation GmbH
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 2,
* or, at your option, any later version as published by the Free
* Software Foundation
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
*
* In addition, as a special exception, you have
* permission to link the code of this program with the OpenSSL
* library (or with modified versions of OpenSSL that use the same
* license as OpenSSL), and distribute linked combinations including
* the two. You must obey the GNU General Public License in all
* respects for all of the code used other than OpenSSL. If you
* modify this file, you may extend this exception to your version
* of the file, but you are not obligated to do so. If you do not
* wish to do so, delete this exception statement from your version.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "parser.h"
#include "parseutils.h"


/**
 * @brief Convert message type into integer value
 * 
 * Return value is one of MSG_HOLE, MSG_INFO, MSG_NOTE, MSG_FALSE, MSG_LOG,
 * MSG_DEBUG and -1 for unknown message type.
 * 
 * @param str Message type name
 * @return Message type code or -1 if unknown.
 */
int
priority_str_to_type(char *str)
{
  if (!strcmp("Security Hole", str)) return MSG_HOLE;
  if (!strcmp("Security Warning", str)) return MSG_INFO;
  if (!strcmp("Security Note", str)) return MSG_NOTE;
  if (!strcmp("False Positive", str)) return MSG_FALSE;
  if (!strcmp("Log Message", str)) return MSG_LOG;
  if (!strcmp("Debug Message", str)) return MSG_DEBUG;

  return -1;
}

/**
 * @brief Convert message type into internal message type name
 * 
 * Return value is one of MSG_HOLE_STR, MSG_INFO_STR, MSG_NOTE_STR,
 * MSG_FALSE_STR and exists for unknown message type.
 * 
 * @param type Message type
 * @return Message type name
 */
char *
priority_type_to_name(int type)
{
  switch (type) {
  case MSG_HOLE:
    return MSG_HOLE_STR;
    break;
  case MSG_NOTE:
    return MSG_NOTE_STR;
    break;
  case MSG_INFO:
    return MSG_INFO_STR;
    break;
  case MSG_FALSE:
    return MSG_FALSE_STR;
    break;
  default:
    fprintf(stderr, "priority_type_to_name: Unknown message type %d\n", type);
    exit(1);
    break;
  }
}
