// SWIG file uncertainty_module.i
// Author : $LastChangedBy: schueller $
// Date : $LastChangedDate: 2012-01-04 12:26:21 +0100 (Wed, 04 Jan 2012) $
// Id : $Id: uncertainty_module.i 2302 2012-01-04 11:26:21Z schueller $

%module(package="openturns", docstring="Probabilistic meta-package.") uncertainty
#pragma SWIG nowarn=302,509
%feature("autodoc","1");

%{
#include "OTconfig.hxx"
#include "OTBase.hxx"
#include "OTUncertainty.hxx"
%}

%include typemaps.i
%include OTtypes.i
%include OTexceptions.i
%include std_vector.i

%import common_module.i
%import typ_module.i
%include TestResult.i
%import base_module.i

/* Uncertainty/Model */
/* Uncertainty/Distribution */
%import model_copula_module.i
%import UncertaintyModelCopulaTemplateDefs.i
%import randomvector_module.i
%import dist_module.i

/* FIXME: Wrong place in Base/Stat */
/* Base/Stat */
%include CorrelationAnalysis.i
%include SensitivityAnalysis.i

/* Uncertainty/Algorithm/Experiment */
%import experiment_module.i
%import UncertaintyExperimentTemplateDefs.i

/* Uncertainty/Algorithm/OrthogonalBasis */
%import orthogonalbasis_module.i
%import UncertaintyOrthogonalBasisTemplateDefs.i

/* Uncertainty/Algorithm/MetaModel */
%import metamodel_module.i
%import UncertaintyMetaModelTemplateDefs.i

/* Uncertainty/Algorithm/QuadraticCumul */
%include QuadraticCumul.i

/* Uncertainty/Algorithm/Transformation */
%import transformation_module.i
%import UncertaintyTransformationTemplateDefs.i

/* Uncertainty/Algorithm/Analytical */
%import analytical_module.i
%import UncertaintyAnalyticalTemplateDefs.i

/* Uncertainty/Algorithm/Simulation */
%import simulation_module.i
%import UncertaintySimulationTemplateDefs.i

/* Uncertainty/StatTests */
%import stattests_module.i
%import UncertaintyStatTestsTemplateDefs.i

/* Uncertainty/Process*/
%import model_process_module.i
%import UncertaintyProcessTemplateDefs.i 

/* At last we include template definitions */
%include UncertaintyTemplateDefs.i
