// SWIG file NumericalSample.i
// Author : $LastChangedBy: schueller $
// Date : $LastChangedDate: 2012-03-21 10:13:56 +0100 (Wed, 21 Mar 2012) $
// Id : $Id: NumericalSample.i 2430 2012-03-21 09:13:56Z schueller $

%{
#include "NumericalSampleImplementation.hxx"
#include "NumericalSample.hxx"
%}

%template(NumericalSampleImplementationTypedInterfaceObject) OT::TypedInterfaceObject<OT::NumericalSampleImplementation>;

#define OT_TYPECHECK_NUMERICALSAMPLE 5

%typemap(in) const NumericalSample & ($1_basetype temp) {
  if (! SWIG_IsOK(SWIG_ConvertPtr($input, (void **) &$1, $1_descriptor, 0))) {
    temp = OT::convert<OT::_PySequence_,OT::NumericalSample>( $input );
    $1 = &temp;
  }
}

%typemap(typecheck,precedence=OT_TYPECHECK_NUMERICALSAMPLE) const NumericalSample & {
  $1 = SWIG_IsOK(SWIG_ConvertPtr($input, NULL, $1_descriptor, 0)) || OT::isAPythonSequenceOf<OT::_PySequence_>( $input );
}

%apply const NumericalSample & { const OT::NumericalSample & };

%include NumericalSampleImplementation.hxx
%include NumericalSample.hxx
//%copyctor NumericalSample;

%pythoncode %{
# This code has been added to conform to Numpy ndarray interface
# that tries to reuse the data stored in the NumericalSample (zero copy)
# see http://docs.scipy.org/doc/numpy/reference/arrays.interface.html#arrays-interface
# for details.
# See python doc http://docs.python.org/reference/datamodel.html?highlight=getattribute#object.__getattribute__
# for details on how to write such a method.
def NumericalSample___getattribute__(self, name):
  """__getattribute__(self, name) -> value"""
  if (name == '__array_interface__'):
    self.__dict__['__array_interface__'] = { 'shape'   : ( self.getSize(), self.getDimension() ),
					     'typestr' : "|f" + str(self.__elementsize__()),
					     'data'    : ( int(self.__baseaddress__()), True),
					     'version' : 3,
    }
  return object.__getattribute__(self,name)
NumericalSample.__getattribute__ = NumericalSample___getattribute__
%}

namespace OT{  
%extend NumericalSample {

	NumericalScalar __getitem__(PyObject * args) const {

          OT::UnsignedLong arg2 ;
          OT::UnsignedLong arg3 ;
          unsigned long val2 ;
          int ecode2 = 0 ;
          unsigned long val3 ;
          int ecode3 = 0 ;
          PyObject * obj1 = 0 ;
          PyObject * obj2 = 0 ;

          if (!PyArg_ParseTuple(args,(char *)"OO:NumericalSample___getitem__",&obj1,&obj2)) SWIG_fail;

          ecode2 = SWIG_AsVal_unsigned_SS_long(obj1, &val2);
          if (!SWIG_IsOK(ecode2)) {
            SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "NumericalSample___getitem__" "', argument " "2"" of type '" "OT::UnsignedLong""'");
          }
          arg2 = static_cast< OT::UnsignedLong >(val2);


          ecode3 = SWIG_AsVal_unsigned_SS_long(obj2, &val3);
          if (!SWIG_IsOK(ecode3)) {
            SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "NumericalSample___getitem__" "', argument " "3"" of type '" "OT::UnsignedLong""'");
          }
          arg3 = static_cast< OT::UnsignedLong >(val3);

          return (*self).at(arg2, arg3);
fail:
          return 0.;
	}



	void __setitem__(PyObject * args, NumericalScalar val) {

          OT::UnsignedLong arg2 ;
          OT::UnsignedLong arg3 ;
          unsigned long val2 ;
          int ecode2 = 0 ;
          unsigned long val3 ;
          int ecode3 = 0 ;
          PyObject * obj1 = 0 ;
          PyObject * obj2 = 0 ;

          if (!PyArg_ParseTuple(args,(char *)"OO:NumericalSample___setitem__",&obj1,&obj2)) SWIG_fail;

          ecode2 = SWIG_AsVal_unsigned_SS_long(obj1, &val2);
          if (!SWIG_IsOK(ecode2)) {
            SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "NumericalSample___setitem__" "', argument " "2"" of type '" "OT::UnsignedLong""'");
          }
          arg2 = static_cast< OT::UnsignedLong >(val2);


          ecode3 = SWIG_AsVal_unsigned_SS_long(obj2, &val3);
          if (!SWIG_IsOK(ecode3)) {
            SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "NumericalSample___setitem__" "', argument " "3"" of type '" "OT::UnsignedLong""'");
          }
          arg3 = static_cast< OT::UnsignedLong >(val3);
          (*self).at(arg2, arg3) = val;
fail:
	  return;
	}

NumericalSample(const NumericalSample & other)
{
 return new OT::NumericalSample( other );
}

NumericalSample(PyObject * pyObj)
{
 return new OT::NumericalSample( OT::convert<OT::_PySequence_,OT::NumericalSample>(pyObj) );
}

Bool __eq__(const NumericalSample & other) { return (*self) == other; }

} // %extend
}
