//                                               -*- C++ -*-
/**
 *  @file  ArcsineFactory.hxx
 *  @brief Factory for DerivativeArcsine distribution
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2009-09-30 17:51:57 +0200 (mer. 30 sept. 2009) $
 *  Id:      $Id: ArcsineFactory.hxx 1357 2009-09-30 15:51:57Z schueller $
 */
#ifndef OPENTURNS_ARCSINEFACTORY_HXX
#define OPENTURNS_ARCSINEFACTORY_HXX

#include "OTprivate.hxx"
#include "DistributionImplementationFactory.hxx"
#include "Arcsine.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class ArcsineFactory
 */
class ArcsineFactory
  : public DistributionImplementationFactory
{
public:

  /** Default constructor */
  ArcsineFactory();

  /** Virtual constructor */
  ArcsineFactory * clone() const;

  /* Here is the interface that all derived class must implement */
  using DistributionImplementationFactory::build;

  Arcsine * build(const NumericalSample & sample) const;
  Arcsine * build(const NumericalPointCollection & parameters) const;
  Arcsine * build() const;


}; /* class ArcsineFactory */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_ARCSINEFACTORY_HXX */
