//                                               -*- C++ -*-
/**
 *  @file               LowDiscrepancySequence.cxx
 *  @brief      Interface for low discrepancy sequences
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy$
 *  @date:   $LastChangedDate$
 *  Id:      $Id$
 */

#include "LowDiscrepancySequence.hxx"

BEGIN_NAMESPACE_OPENTURNS

CLASSNAMEINIT(LowDiscrepancySequence);


/* Default constructor */
LowDiscrepancySequence::LowDiscrepancySequence()
  : TypedInterfaceObject<LowDiscrepancySequenceImplementation>(LowDiscrepancySequenceImplementation().clone())
{
  // Nothing to do
}


/* Constructor with parameters*/
LowDiscrepancySequence::LowDiscrepancySequence(const UnsignedLong dimension)
  : TypedInterfaceObject<LowDiscrepancySequenceImplementation>(LowDiscrepancySequenceImplementation(dimension).clone())
{
  // Nothing to do
}


/* Constructor with parameters */
LowDiscrepancySequence::LowDiscrepancySequence(Implementation & p_implementation)
  : TypedInterfaceObject<LowDiscrepancySequenceImplementation>(p_implementation)
{
  // Nothing to do
}


/* Constructor with parameters */
LowDiscrepancySequence::LowDiscrepancySequence(const LowDiscrepancySequenceImplementation & implementation)
  : TypedInterfaceObject<LowDiscrepancySequenceImplementation>(implementation.clone())
{
  // Nothing to do
}


/* Initialize the sequence */
void LowDiscrepancySequence::initialize(const UnsignedLong dimension)
{
  getImplementation()->initialize(dimension);
}


/* Dimension accessor*/
UnsignedLong LowDiscrepancySequence::getDimension() const
{
  return getImplementation()->getDimension();
}


/* Generate a sample of pseudo-random vectors of numbers uniformly distributed over [0, 1) */
NumericalPoint LowDiscrepancySequence::generate()
{
  return getImplementation()->generate();
}


/* Generate a sample of pseudo-random vectors of numbers uniformly distributed over [0, 1) */
NumericalSample LowDiscrepancySequence::generate(const UnsignedLong size)
{
  return getImplementation()->generate(size);
}


/* Compute the star discrepancy of a sample uniformly distributed over [0, 1) */
NumericalScalar LowDiscrepancySequence::computeStarDiscrepancy(const NumericalSample & sample) const
{
  return getImplementation()->ComputeStarDiscrepancy(sample);
}


/* String converter */
String LowDiscrepancySequence::__repr__() const
{
  OSS oss;
  oss << "class=" << LowDiscrepancySequence::GetClassName()
      << " implementation=" << getImplementation()->__repr__();
  return oss;
}


END_NAMESPACE_OPENTURNS
